@extends('students-dashboard.app')
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 m-auto">
            <div class="card-body card__head">
                <div class="page-header">
                    <div class="page-block mb-0 mt-3">
                        <div class="row align-items-center">
                            <div class="col-md-12">
                                <div class="page-header-title mb-0">
                                    <h4 class="mb-0">Others Mark</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-4">
                    <form method="GET" action="{{ route('student.view-others-mark-sheet') }}">
                        <div class="row gap-1">
                            <div class="col-md-3 my-2">
                                <select name="exam_id" class="form-control select2 exam_id" id="exam_id" required>
                                        <option value="">Exam</option>
                                        @foreach ($exams as $examItem)
                                            <option value="{{ $examItem->id }}" @selected($exam_id == $examItem->id || (!$exam_id && $loop->first)) >
                                                {{ $examItem->exam_name . ' ' . $examItem->academic_year->year }}
                                            </option>
                                        @endforeach 
                                    </select>
                                    
                            </div>
                            <div class="col-md-3 my-2">
                                <button type="submit" class="btn btn-info btn__search">Search</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            @if(isset($students) && !$students->isEmpty())
                <div class="data__table my-3">
                    <div class="card-body table-border-style">
                        <div class="table-responsive">
                            <table class="table table-strip">
                                <thead class="thead-light">
                                    <tr>
                                        <th style="width: 60px" class="text-center h_stl_2">Position</th>
                                        <th class="text-center">Student ID</th>
                                        <th class="h_stl_1">Student Name</th>
                                        <th class="text-center">Roll</th>
                                        <th class="bg-gray text-center" style="width: 130px">Full Marks</th>
                                        <th class="text-center h_stl_3">Total Obt.</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($students)
                                        @php

                                            $head_marks_array = json_decode($assignedMarksHead->first(), true);
                                            $head_id_array = array_keys($head_marks_array);
                                            $subject_head_marks = $assignedMarksHead;
                                            $highest_grand_total_obtain = 0;

                                            // Calculate grand total obtained for each student
                                            $students_with_grand_total = [];

                                            foreach ($students as $student) {
                                                $grand_total_obtain = 0;
                                                $examRecords = $student?->examRecords ?? '';

                                                if ($examRecords->isNotEmpty()) {
                                                    foreach ($examRecords as $record) {
                                                        $head_wise_marks_record = json_decode($record->head_wise_marks);
                                                        $head_marks_data = $subject_head_marks[$record->subject->id];
                                                        $head_marks_array = json_decode($head_marks_data);
                                                        $total_marks_obtain = 0;

                                                        foreach ($markHeads as $head) {
                                                            if (in_array($head->id, $head_id_array)) {
                                                                $total_marks_obtain += $head_wise_marks_record?->{$head->id} ?? 0;
                                                            }
                                                        }

                                                        $grand_total_obtain += $total_marks_obtain;
                                                    }
                                                }

                                                // Add student and their total obtained marks
                                                $students_with_grand_total[] = [
                                                    'student' => $student,
                                                    'grand_total_obtain' => $grand_total_obtain
                                                ];

                                                // Update highest total if this student's grand_total_obtain is higher
                                                if ($grand_total_obtain > $highest_grand_total_obtain) {
                                                    $highest_grand_total_obtain = $grand_total_obtain;
                                                }
                                            }

                                            // Sort students by grand_total_obtain in descending order
                                            usort($students_with_grand_total, function ($a, $b) {
                                                return $b['grand_total_obtain'] <=> $a['grand_total_obtain'];
                                            });

                                            $position = 1; // To assign position based on sorted order
                                        @endphp
                                        @foreach ($students_with_grand_total as $data)
                                            @php
                                                $student = $data['student'];
                                                $grand_total_obtain = $data['grand_total_obtain'];
                                                $grand_total = 0;
                                                $fail_count = 0;
                                                $examRecords = $student?->examRecords ?? '';
                                                $section = $sections[$student->section_id] ?? '';
                                                $class = $studentClasses[$student->student_class_id] ?? '';
                                                $academic_year = request()->query('academic_year') ?? $defaultYear;
                                                $academicYear = $academicYears[$academic_year] ?? '';
                                            @endphp

                                            @if ($examRecords->isNotEmpty())
                                                @foreach ($examRecords as $record)
                                                    @php
                                                        $full_marks = 0;
                                                        $head_wise_total_obtain = [];
                                                        $total_marks_obtain = 0;

                                                        $head_wise_marks_record = json_decode($record->head_wise_marks);
                                                        $head_marks_data = $subject_head_marks[$record->subject->id];
                                                        $head_marks_array = json_decode($head_marks_data);
                                                    @endphp

                                                    @if (isset($head_wise_marks_record))
                                                        @foreach ($markHeads as $head)
                                                            @if (in_array($head->id, $head_id_array))
                                                                @php
                                                                    $full_marks += $head_marks_array->{$head?->id};
                                                                    $total_marks_obtain += $head_wise_marks_record?->{$head?->id} ?? 0;
                                                                @endphp
                                                            @endif
                                                        @endforeach

                                                        @php
                                                            $grand_total += $full_marks;
                                                        @endphp
                                                    @endif
                                                @endforeach
                                            @endif
                                            @if ($studentInfo->id==$student->id)
                                                <tr class="bg__highlight">
                                                    <td class="text-center">{{ $position++ }}</td>
                                                    <td class="text-center">{{ $student->student_id_no }}</td>
                                                    <td class="b_stl_1">{{ $student->name }}</td>
                                                    <td class="text-center">{{ $student->class_roll }}</td>
                                                    <td class="bg-gray text-center"><b>{{ $grand_total }}</b></td>
                                                    <td class="text-center b_stl_3"><b>{{ $grand_total_obtain }}</b></td>
                                                </tr>
                                            @else
                                                <tr>
                                                    <td class="text-center b_stl_2">{{ $position++ }}</td>
                                                    <td class="text-center">{{ $student->student_id_no }}</td>
                                                    <td class="b_stl_1">{{ $student->name }}</td>
                                                    <td class="text-center">{{ $student->class_roll }}</td>
                                                    <td class="bg-gray text-center"><b>{{ $grand_total }}</b></td>
                                                    <td class="text-center b_stl_3"><b>{{ $grand_total_obtain }}</b></td>
                                                </tr>
                                            @endif

                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="8">There is no data found</td>
                                        </tr>
                                    @endif

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            @endif
        </div>
    </div>
</div>
@endsection


@section('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var highestGrandTotalObtain = {{ $highest_grand_total_obtain ?? 0 }};
            var elements = document.querySelectorAll('.highest-grand-total');
            elements.forEach(function(element) {
                element.innerHTML = '<b>' + highestGrandTotalObtain + '</b>';
            });
        });
    </script>
@endsection
