@extends('students-dashboard.app')
@section('content')
    <section class="std__summary student__profile mb-4">
        <div class="row">
            <div class="col-md-12 col-lg-10 m-auto">
                <div class="row">
                    <div class="col-md-5 col-xl-4 std__summary__profile">
                        <div class="card text-center">
                            <div class="card-block profile-intro">
                                <div class="content text-center">
                                    <div class="avatar">
                                        @php
                                            $student_image = $studentInfo->profile_image ? $studentInfo->profile_image : 'uploads/student/graduated_student.png';
                                        @endphp
                                        <img src="{{asset($student_image)}}" alt="Student Name">
                                    </div>
                                    <h4 class="profile-user">{{$studentInfo->name}}</h4>
                                    <p class="profile-job">

                                    </p>
                                    <table class="table mt-20">
                                        <tbody>
                                        <tr>
                                            <th>ID</th>
                                            <td>{{$studentInfo->student_id_no}}</td>
                                        </tr>
                                        <tr>
                                            <th>Session</th>
                                            <td>{{getDefaultAcademicYearValue()}}</td>
                                        </tr>
                                        <tr>
                                            <th>Class</th>
                                            <td>{{$studentInfo->studentClass->class_name}}</td>
                                        </tr>
                                        <tr>
                                            <th>Section</th>
                                            <td>{{$studentInfo->section->section_name ?? 'N/A'}}</td>
                                        </tr>
                                        <tr>
                                            <th>Roll</th>
                                            <td>{{$studentInfo->class_roll}}</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <div style="height: 20px"></div>
                                <svg class="svg-intro-bottom" xmlns="http://www.w3.org/2000/svg"
                                     viewBox="0 0 100 100" preserveAspectRatio="none">
                                    <path d="M0,70 C30,130 70,50 100,70 L100,100 0,100 Z" fill="#f6f7fb">
                                    </path>
                                </svg>
                                <svg class="svg-intro-bottom-2" xmlns="http://www.w3.org/2000/svg"
                                     viewBox="0 0 100 100" preserveAspectRatio="none">
                                    <path d="M0,70 C30,130 70,50 100,70 L100,100 0,100 Z" fill="#ffffff"
                                          fill-opacity="0.4"></path>
                                </svg>
                                <svg class="svg-intro-bottom-3" xmlns="http://www.w3.org/2000/svg"
                                     viewBox="0 0 100 100" preserveAspectRatio="none">
                                    <path d="M95,0 Q90,90 10,100 L100,100 100,0 Z" fill="#ffffff"
                                          fill-opacity="0.1"></path>
                                </svg>
                            </div>
                        </div>
                        <div class="content card-block d-none d-md-none d-lg-none text-center">
                            <div class="avatar">
                                <img src="https://book-shop.godevsbd.com/settings/1707319512_logo.png"
                                     alt="Student Name">
                            </div>
                            <div class="std__info text-center">
                                <div class="name">
                                    <h4>{{$studentInfo->name}}</h4>
                                </div>
                                <div class="d-flex justify-content-center">
                                    <p>Student ID: {{$studentInfo->student_id_no}}</p>
                                    <p>Class: {{$studentInfo->studentClass->class_name}}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-7 col-xl-8 std__summary">
                        <div class="row">
                            <!-- TODO: Profile Details -->
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title mb-4">Personal Information</h5>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-calendar"></i>
                                                        <span class="label">Date of Birth:</span>
                                                        <span
                                                            class="value">{{$studentInfo->date_of_birth ?? 'N/A'}} <span>My Age: </span></span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-tint"></i>
                                                        <span class="label">Blood Group:</span>
                                                        <span
                                                            class="value">{{$studentInfo->blood_group ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-venus-mars"></i>
                                                        <span class="label">Gender:</span>
                                                        <span class="value">{{$studentInfo->gender ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-pray"></i>
                                                        <span class="label">Religion:</span>
                                                        <span class="value">{{$studentInfo->religion ?? 'N/A'}}</span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-user"></i>
                                                        <span class="label">Father Name:</span>
                                                        <span
                                                            class="value">{{$studentInfo->father_name ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-phone"></i>
                                                        <span class="label">Father Mobile:</span>
                                                        <span
                                                            class="value">{{$studentInfo->father_mobile ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-user"></i>
                                                        <span class="label">Guardian Name:</span><br>
                                                        <span
                                                            class="value">{{$studentInfo->guardian_name ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-phone"></i>
                                                        <span class="label">Guardian Mobile:</span>
                                                        <span
                                                            class="value">{{$studentInfo->guardian_mobile ?? 'N/A'}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title mb-4">Address</h5>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <div class="profile-detail-item" style="height: 110px">
                                                        <i class="fas fa-home"></i>
                                                        <span class="label">Present Address:</span>
                                                        <span
                                                            class="value">{{$studentInfo->present_address ?? 'N/A'}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <div class="profile-detail-item" style="height: 110px">
                                                        <i class="fas fa-map-marked-alt"></i>
                                                        <span class="label">Permanent Address:</span>
                                                        <span
                                                            class="value">{{$studentInfo->permanent_address ?? 'N/A'}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card d-none">
                                    <div class="card-body">
                                        <h5 class="card-title mb-4">Personal Information</h5>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="info__title">Guardian Information</label>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-user"></i>
                                                        <span class="label">Guardian Name:</span><br>
                                                        <span
                                                            class="value">{{$studentInfo->guardian_name ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-phone"></i>
                                                        <span class="label">Guardian Mobile:</span>
                                                        <span
                                                            class="value">{{$studentInfo->guardian_mobile ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-map-marker-alt"></i>
                                                        <span class="label">Guardian Address:</span>
                                                        <span
                                                            class="value">{{$studentInfo->guardian_address ?? 'N/A'}}</span>
                                                    </div>

                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-envelope"></i>
                                                        <span class="label">Email:</span>
                                                        <span class="value">{{$studentInfo->email ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-phone"></i>
                                                        <span class="label">Mobile:</span>
                                                        <span
                                                            class="value">{{$studentInfo->guardian_mobile ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-calendar"></i>
                                                        <span class="label">Date of Birth:</span>
                                                        <span
                                                            class="value">{{$studentInfo->date_of_birth ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-venus-mars"></i>
                                                        <span class="label">Gender:</span>
                                                        <span class="value">{{$studentInfo->gender ?? 'N/A'}}</span>
                                                    </div>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="text-muted small">Additional Information</label>

                                                </div>
                                                <div class="mb-3">
                                                    <label class="text-muted small">Parent Information</label>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-user"></i>
                                                        <span class="label">Father Name:</span>
                                                        <span
                                                            class="value">{{$studentInfo->father_name ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-phone"></i>
                                                        <span class="label">Father Mobile:</span>
                                                        <span
                                                            class="value">{{$studentInfo->father_mobile ?? 'N/A'}}</span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="text-muted small">Guardian Information</label>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-user"></i>
                                                        <span class="label">Guardian Name:</span>
                                                        <span
                                                            class="value">{{$studentInfo->guardian_name ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-phone"></i>
                                                        <span class="label">Guardian Mobile:</span>
                                                        <span
                                                            class="value">{{$studentInfo->guardian_mobile ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-map-marker-alt"></i>
                                                        <span class="label">Guardian Address:</span>
                                                        <span
                                                            class="value">{{$studentInfo->guardian_address ?? 'N/A'}}</span>
                                                    </div>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="text-muted small">Address Information</label>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-home"></i>
                                                        <span class="label">Present Address:</span>
                                                        <span
                                                            class="value">{{$studentInfo->present_address ?? 'N/A'}}</span>
                                                    </div>
                                                    <div class="profile-detail-item">
                                                        <i class="fas fa-map-marked-alt"></i>
                                                        <span class="label">Permanent Address:</span>
                                                        <span
                                                            class="value">{{$studentInfo->permanent_address ?? 'N/A'}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
