<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Academic\GroupController;
use App\Http\Controllers\Academic\ShiftController;
use App\Http\Controllers\Academic\BranchController;
use App\Http\Controllers\Academic\SectionController;
use App\Http\Controllers\Academic\SubjectController;
use App\Http\Controllers\Academic\BuildingController;
use App\Http\Controllers\Academic\ClassRoomController;
use App\Http\Controllers\Academic\DepartmentController;
use App\Http\Controllers\Academic\AcademicYearController;
use App\Http\Controllers\Academic\ClassRoutineController;
use App\Http\Controllers\Academic\StudentClassController;
use App\Http\Controllers\Academic\SubjectSetupController;
use App\Http\Controllers\Academic\AcademicSetupController;
use App\Http\Controllers\Academic\BuildingFloorController;
use App\Http\Controllers\Academic\BuildingSetupController;
use App\Http\Controllers\Academic\SubjectsAssignController;
use App\Http\Controllers\Academic\SubjectTeacherController;
use App\Http\Controllers\Academic\ClassTimePeriodController;
use App\Http\Controllers\Academic\TeacherEnrollmentController;
use App\Http\Controllers\Academic\AssignClassTeacherController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::middleware('auth')->group(function () {

    

    Route::prefix('academic-setup')->group(function () {
        Route::get('/', [AcademicSetupController::class, 'index'])->name('academic-setup.index');

        Route::post('section/store', [AcademicSetupController::class, 'section_store'])->name('sections.store');
        Route::post('section/update', [AcademicSetupController::class, 'section_update'])->name('sections.update');

        Route::post('group/store', [AcademicSetupController::class, 'group_store'])->name('groups.store');
        Route::post('group/update', [AcademicSetupController::class, 'group_update'])->name('groups.update');

        Route::post('department/store', [AcademicSetupController::class, 'department_store'])->name('department.store');
        Route::post('department/update', [AcademicSetupController::class, 'department_update'])->name('department.update');

        Route::post('shift/store', [AcademicSetupController::class, 'shift_store'])->name('shifts.store');
        Route::post('shift/update', [AcademicSetupController::class, 'shift_update'])->name('shifts.update');

        Route::post('student-class/store', [AcademicSetupController::class, 'student_class_store'])->name('student_class.store');
        Route::post('student-class/update', [AcademicSetupController::class, 'student_class_update'])->name('student_class.update');
    });

    Route::prefix('subject-setup')->group(function () {
        Route::get('/', [SubjectSetupController::class, 'index'])->name('subject-setup.index');
        Route::post('subject/store', [SubjectSetupController::class, 'subject_store'])->name('subjects.store');
        Route::post('subject/update', [SubjectSetupController::class, 'subject_update'])->name('subjects.update');
    });

    Route::prefix('building-setup')->group(function () {
        Route::get('/', [BuildingSetupController::class, 'index'])->name('building-setup.index');

        Route::post('/buildings', [BuildingSetupController::class, 'building_store'])->name('buildings.store');
        Route::post('/buildings/update', [BuildingSetupController::class, 'building_update'])->name('buildings.update');
        Route::delete('/buildings/{building}', [BuildingSetupController::class, 'building_destroy'])->name('buildings.destroy');

        Route::post('class-rooms/store', [BuildingSetupController::class, 'class_room_store'])->name('class_rooms.store');
        Route::post('class-rooms/update}', [BuildingSetupController::class, 'class_room_update'])->name('class_rooms.update');
        Route::get('class-rooms/destroy/{class_room}', [BuildingSetupController::class, 'class_room_destroy'])->name('class_rooms.destroy');

    });

    //---------branch Route List--------------------
    Route::prefix('branches')->group(function () {
        Route::get('/', [BranchController::class, 'index'])->name('branches.index');
        Route::get('/create', [BranchController::class, 'create'])->name('branches.create');
        Route::post('/', [BranchController::class, 'store'])->name('branches.store');
        Route::get('/{branch}', [BranchController::class, 'show'])->name('branches.show');
        Route::get('/{branch}/edit', [BranchController::class, 'edit'])->name('branches.edit');
        Route::post('/update', [BranchController::class, 'update'])->name('branches.update');
        Route::delete('/{branch}', [BranchController::class, 'destroy'])->name('branches.destroy');
    });


    //-------------Building----------------------
    Route::get('/buildings', [BuildingController::class, 'index'])->name('buildings.index');
    // Route::post('/buildings', [BuildingController::class, 'store'])->name('buildings.store');
    Route::get('/buildings/{building}', [BuildingController::class, 'show'])->name('buildings.show');
    // Route::post('/buildings/update', [BuildingController::class, 'update'])->name('buildings.update');
    // Route::delete('/buildings/{building}', [BuildingController::class, 'destroy'])->name('buildings.destroy');

    //----------Buildings Floor---------------------
    Route::get('building-floors', [BuildingFloorController::class, 'index'])->name('building_floors.index');
    Route::post('building-floors', [BuildingFloorController::class, 'store'])->name('building_floors.store');
    Route::post('building-floors/update', [BuildingFloorController::class, 'update'])->name('building_floors.update');
    Route::delete('building-floors/{buildingFloor}', [BuildingFloorController::class, 'destroy'])->name('building_floors.destroy');

    Route::get('building-floors-search', [BuildingFloorController::class, 'get_building_floors'])->name('building_floors.search_floor');

    //---------Groups Route List--------------------
    // Route::prefix('shifts')->group(function () {
    //     Route::get('/', [ShiftController::class, 'index'])->name('shifts.index');
    //     Route::get('/create', [ShiftController::class, 'create'])->name('shifts.create');
    //     Route::post('/store', [ShiftController::class, 'store'])->name('shifts.store');
    //     Route::get('/{shift}', [ShiftController::class, 'show'])->name('shifts.show');
    //     Route::get('/edit/{shift}', [ShiftController::class, 'edit'])->name('shifts.edit');
    //     Route::post('/update', [ShiftController::class, 'update'])->name('shifts.update');
    //     Route::get('/destroy/{shift}', [ShiftController::class, 'destroy'])->name('shifts.destroy');
    // });

    //-------------Class Rooms-----------------
    Route::prefix('class-rooms')->group(function () {
        Route::get('/', [ClassRoomController::class, 'index'])->name('class_rooms.index');
        // Route::post('/store', [ClassRoomController::class, 'store'])->name('class_rooms.store');
        Route::get('/show/{class_room}', [ClassRoomController::class, 'show'])->name('class_rooms.show');
        // Route::post('/update}', [ClassRoomController::class, 'update'])->name('class_rooms.update');
        // Route::get('/destroy/{class_room}', [ClassRoomController::class, 'destroy'])->name('class_rooms.destroy');
    });
    Route::get('/class-rooms-search', [ClassRoomController::class, 'get_class_rooms'])->name('class_rooms.search_rooms');

    //---------Groups CRUD Rooute--------------
    // Route::prefix('groups')->group(function () {
    //     Route::get('/', [GroupController::class, 'index'])->name('groups.index');
    //     Route::post('/store', [GroupController::class, 'store'])->name('groups.store');
    //     Route::get('/{group}/show', [GroupController::class, 'show'])->name('groups.show');
    //     Route::post('/update', [GroupController::class, 'update'])->name('groups.update');
    //     Route::delete('/destroy/{group}', [GroupController::class, 'destroy'])->name('groups.destroy');
    // });

    //----------Section Route List-----------------
    // Route::prefix('sections')->group(function () {
    //     Route::get('/', [SectionController::class, 'index'])->name('sections.index');
    //     Route::get('/create', [SectionController::class, 'create'])->name('sections.create');
    //     Route::post('/store', [SectionController::class, 'store'])->name('sections.store');
    //     Route::get('/show/{section}', [SectionController::class, 'show'])->name('sections.show');
    //     Route::get('/edit/{section}', [SectionController::class, 'edit'])->name('sections.edit');
    //     Route::post('/update', [SectionController::class, 'update'])->name('sections.update');
    //     Route::get('/destroy/{section}', [SectionController::class, 'destroy'])->name('sections.destroy');
    // });
    Route::get('/sections-by-class-id', [SectionController::class, 'getSectionByClassID'])->name('sections.list_by_class');

    //---------Subjects Route List---------------
    Route::prefix('subjects')->group(function () {
        Route::get('/', [SubjectController::class, 'index'])->name('subjects.index');
        // Route::post('/store', [SubjectController::class, 'store'])->name('subjects.store');
        Route::get('/{subject}/show', [SubjectController::class, 'show'])->name('subjects.show');
        // Route::post('/update', [SubjectController::class, 'update'])->name('subjects.update');
        Route::delete('destroy/{subject}', [SubjectController::class, 'destroy'])->name('subjects.destroy');
    });

    Route::get('/subjects-by-class-id', [SubjectController::class, 'getSubjectByClassID'])->name('subjects.list_by_class');

    //---------Class Time Period Route List---------
    Route::get('/class-time-periods', [ClassTimePeriodController::class, 'index'])->name('class_time_periods.index');
    Route::get('/class-time-periods/create', [ClassTimePeriodController::class, 'create'])->name('class_time_periods.create');
    Route::post('/class-time-periods/search', [ClassTimePeriodController::class, 'search'])->name('class_time_periods.search');
    Route::post('/class-time-periods', [ClassTimePeriodController::class, 'store'])->name('class_time_periods.store');
    Route::get('/class-time-periods/{id}', [ClassTimePeriodController::class, 'show'])->name('class_time_periods.show');
    Route::get('/class-time-periods/{id}/edit', [ClassTimePeriodController::class, 'edit'])->name('class_time_periods.edit');
    Route::put('/class-time-periods/{id}', [ClassTimePeriodController::class, 'update'])->name('class_time_periods.update');
    Route::delete('/class-time-periods/{id}', [ClassTimePeriodController::class, 'destroy'])->name('class_time_periods.destroy');

    //---------Class Routine Route List---------

    Route::prefix('class-routine')->group(function () {
        Route::get('/', [ClassRoutineController::class, 'index'])->name('class-routine.index');
        Route::get('/create', [ClassRoutineController::class, 'create'])->name('class-routine.create');
        Route::post('/store', [ClassRoutineController::class, 'store'])->name('class-routine.store');
        Route::get('/{classRoutine}/show', [ClassRoutineController::class, 'show'])->name('class-routine.show');
        Route::get('/{classRoutine}/edit', [ClassRoutineController::class, 'edit'])->name('class-routine.edit');
        Route::put('/{classRoutine}/update', [ClassRoutineController::class, 'update'])->name('class-routine.update');
        Route::delete('/destroy/{classRoutine}', [ClassRoutineController::class, 'destroy'])->name('class-routine.destroy');
    });

    //---------Class Teacher Assign Route List -------
    Route::prefix('class-teachers')->group(function () {
        Route::get('/', [AssignClassTeacherController::class,'index'])->name('class_teachers.index');
        Route::get('/create', [AssignClassTeacherController::class,'create'])->name('class_teachers.create');
        Route::post('/store', [AssignClassTeacherController::class,'store'])->name('class_teachers.store');
        Route::get('/{id}/show', [AssignClassTeacherController::class,'show'])->name('class_teachers.show');
        Route::get('/{id}/edit', [AssignClassTeacherController::class,'edit'])->name('class_teachers.edit');
        Route::put('/{id}/update', [AssignClassTeacherController::class,'update'])->name('class_teachers.update');
        Route::delete('/destroy/{id}', [AssignClassTeacherController::class,'destroy'])->name('class_teachers.destroy');
        Route::post('/update-class-teacher', [AssignClassTeacherController::class,'updateAjax'])->name('class_teachers.update.ajax');
    });

    //-------------Student class-------------
    // Route::prefix('student-class')->group(function () {
    //     Route::get('/', [StudentClassController::class, 'index'])->name('student_class.index');
    //     Route::get('/create', [StudentClassController::class, 'create'])->name('student_class.create');
    //     Route::post('/store', [StudentClassController::class, 'store'])->name('student_class.store');
    //     Route::get('/{studentClass}', [StudentClassController::class, 'show'])->name('student_class.show');
    //     Route::get('/edit/{studentClass}', [StudentClassController::class, 'edit'])->name('student_class.edit');
    //     Route::post('/update', [StudentClassController::class, 'update'])->name('student_class.update');
    //     Route::get('/destroy/{studentClass}', [StudentClassController::class, 'destroy'])->name('student_class.destroy');
    // });

    //-------------Subjects Assigns----------------
    Route::prefix('subjects-assigns')->group(function () {
        Route::get('/', [SubjectsAssignController::class, 'index'])->name('subjects_assigns.index');
        Route::get('/create', [SubjectsAssignController::class, 'create'])->name('subjects_assigns.create');
        Route::post('/store', [SubjectsAssignController::class, 'store'])->name('subjects_assigns.store');
        Route::get('/{id}/show', [SubjectsAssignController::class, 'show'])->name('subjects_assigns.show');
        Route::get('/edit/{student_class_id}/{department_id?}', [SubjectsAssignController::class, 'edit'])->name('subjects_assigns.edit');
        Route::put('/{id}/update', [SubjectsAssignController::class, 'update'])->name('subjects_assigns.update');
        Route::delete('/destroy/{student_class_id}/{department_id?}', [SubjectsAssignController::class, 'destroy'])->name('subjects_assigns.destroy');
    });

    //---------Academic Year Route List----------
    Route::prefix('academic-years')->group(function () {
        Route::get('/', [AcademicYearController::class, 'index'])->name('academic-years.index');
        Route::post('/store', [AcademicYearController::class, 'store'])->name('academic-years.store');
        Route::get('/{academicYear}/show', [AcademicYearController::class, 'show'])->name('academic-years.show');
        Route::post('/update', [AcademicYearController::class, 'update'])->name('academic-years.update');
        Route::delete('/destroy/{academicYear}', [AcademicYearController::class, 'destroy'])->name('academic-years.destroy');
    });

    //---------Department Route List--------------------
    // Route::prefix('departments')->group(function () {
    //     Route::get('/', [DepartmentController::class, 'index'])->name('department.index');
    //     Route::get('/create', [DepartmentController::class, 'create'])->name('department.create');
    //     Route::post('/store', [DepartmentController::class, 'store'])->name('department.store');
    //     Route::get('/edit/{type}', [DepartmentController::class, 'edit'])->name('department.edit');
    //     Route::post('/update', [DepartmentController::class, 'update'])->name('department.update');
    //     Route::delete('/destroy/{id}', [DepartmentController::class, 'destroy'])->name('department.destroy');
    // });

    Route::prefix('subject-teachers')->group(function () {
        Route::get('/', [SubjectTeacherController::class,'index'])->name('subject-teachers.index');
        Route::get('/create', [SubjectTeacherController::class,'create'])->name('subject-teachers.create');
        Route::post('/store', [SubjectTeacherController::class,'store'])->name('subject-teachers.store');
        Route::get('/{id}/show', [SubjectTeacherController::class,'show'])->name('subject-teachers.show');
        Route::get('/{id}/edit', [SubjectTeacherController::class,'edit'])->name('subject-teachers.edit');
        Route::put('/{id}/update', [SubjectTeacherController::class,'update'])->name('subject-teachers.update');
        Route::delete('/destroy/{id}', [SubjectTeacherController::class,'destroy'])->name('subject-teachers.destroy');
    });

    Route::prefix('teacher-enroll')->group(function () {
        Route::get('/', [TeacherEnrollmentController::class,'index'])->name('teachers-enroll.index');
        Route::get('/create', [TeacherEnrollmentController::class,'create'])->name('teachers-enroll.create');
        Route::post('/store', [TeacherEnrollmentController::class,'store'])->name('teachers-enroll.store');
        Route::get('/edit/{id}', [TeacherEnrollmentController::class,'edit'])->name('teachers-enroll.edit');
        Route::post('/update/', [TeacherEnrollmentController::class,'update'])->name('teachers-enroll.update');
        Route::delete('/destroy/{id}', [TeacherEnrollmentController::class,'destroy'])->name('teachers-enroll.destroy');
    });

    
});

