<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Accounting\IncomeController;
use App\Http\Controllers\Accounting\ExpenseController;
use App\Http\Controllers\Accounting\FeeTypeController;
use App\Http\Controllers\Accounting\ClassFeeController;
use App\Http\Controllers\Accounting\CheckBookController;
use App\Http\Controllers\Accounting\FeeCollectController;
use App\Http\Controllers\Accounting\IncomeItemController;
use App\Http\Controllers\Accounting\BankAccountController;
use App\Http\Controllers\Accounting\BankDepositController;
use App\Http\Controllers\Accounting\ExpenseItemController;
use App\Http\Controllers\Accounting\FeeDiscountController;
use App\Http\Controllers\Accounting\BankWithdrawController;
use App\Http\Controllers\Accounting\AccountingHeadController;
use App\Http\Controllers\Accounting\StudentDiscountController;

Route::middleware('auth')->group(function () {

    //----------------------Fee Category Route------------------------
    Route::prefix('fee-type')->group(function () {
        Route::get('/', [FeeTypeController::class, 'index'])->name('fee_types.index');
        Route::get('create', [FeeTypeController::class, 'create'])->name('fee_types.create');
        Route::post('store', [FeeTypeController::class, 'store'])->name('fee_types.store');
        Route::get('{feeType}/edit', [FeeTypeController::class, 'edit'])->name('fee_types.edit');
        Route::put('update/{feeType}', [FeeTypeController::class, 'update'])->name('fee_types.update');
        Route::delete('delete/{feeType}', [FeeTypeController::class, 'destroy'])->name('fee_types.destroy');
    });

    //----------------------Class Fees Assign Route------------------------
    Route::prefix('class-fees')->group(function () {
        Route::get('/', [ClassFeeController::class, 'index'])->name('class_fees.index');
        Route::get('create', [ClassFeeController::class, 'create'])->name('class_fees.create');
        Route::post('store', [ClassFeeController::class, 'store'])->name('class_fees.store');
        Route::get('view/{student_class_id}/{academic_year_id}', [ClassFeeController::class, 'show'])->name('class_fees.show');
        Route::get('edit/{student_class_id}/{academic_year_id}', [ClassFeeController::class, 'edit'])->name('class_fees.edit');
        Route::get('copy/{student_class_id}/{academic_year_id}', [ClassFeeController::class, 'copy'])->name('class_fees.copy');
        Route::put('update', [ClassFeeController::class, 'update'])->name('class_fees.update');
        Route::delete('delete/{student_class_id}/{academic_year_id}', [ClassFeeController::class, 'destroy'])->name('class_fees.destroy');
    });

    //----------------------Fees Discount Route------------------------
    Route::prefix('fee-discounts')->group(function () {
        Route::get('/', [FeeDiscountController::class, 'index'])->name('fee_discounts.index');
        Route::get('create', [FeeDiscountController::class, 'create'])->name('fee_discounts.create');
        Route::post('store', [FeeDiscountController::class, 'store'])->name('fee_discounts.store');
        Route::get('show/{feeDiscount}', [FeeDiscountController::class, 'show'])->name('fee_discounts.show');
        Route::get('{feeDiscount}/edit', [FeeDiscountController::class, 'edit'])->name('fee_discounts.edit');
        Route::put('update/{feeDiscount}', [FeeDiscountController::class, 'update'])->name('fee_discounts.update');
        Route::delete('delete/{feeDiscount}', [FeeDiscountController::class, 'destroy'])->name('fee_discounts.destroy');
    });

    //----------------------Assign Discount Route------------------------
    Route::prefix('student-discount')->group(function () {
        Route::get('/', [StudentDiscountController::class, 'index'])->name('student_discount.index');
        Route::get('create', [StudentDiscountController::class, 'create'])->name('student_discount.create');
        Route::post('search', [StudentDiscountController::class, 'search'])->name('student_discount.search');
        Route::post('store', [StudentDiscountController::class, 'store'])->name('student_discount.store');
    });

    //----------------------Fees Fine Route------------------------
    Route::prefix('collect-fees')->group(function () {
        Route::get('/', [FeeCollectController::class, 'index'])->name('collect_fee.index');
        Route::get('create', [FeeCollectController::class, 'create'])->name('collect_fee.create');
        Route::post('search', [FeeCollectController::class, 'searchFees'])->name('collect_fee.search_fees');
        Route::post('store', [FeeCollectController::class, 'store'])->name('collect_fee.store');
        Route::get('{uuid}/view', [FeeCollectController::class, 'show'])->name('collect_fee.show');
        Route::delete('delete/{invoice_id}', [FeeCollectController::class, 'destroy'])->name('collect_fee.destroy');
        Route::get('due-list', [FeeCollectController::class, 'dueList'])->name('collect_fee.due-list');
    });

    Route::prefix('accounting-head')->group(function () {
        Route::get('list', [AccountingHeadController::class, 'index'])->name('accounting_head.index');
        Route::post('store', [AccountingHeadController::class, 'store'])->name('accounting_head.store');
        Route::get('{id}/edit', [AccountingHeadController::class, 'edit'])->name('accounting_head.edit');
        Route::put('update/{id}', [AccountingHeadController::class, 'update'])->name('accounting_head.update');
        Route::delete('delete/{id}', [AccountingHeadController::class, 'destroy'])->name('accounting_head.destroy');
    });

    Route::prefix('income')->group(function () {
        Route::get('/', [IncomeController::class, 'index'])->name('income.index');
        Route::post('store', [IncomeController::class, 'store'])->name('income.store');
        Route::get('{id}/show', [IncomeController::class, 'show'])->name('income.show');
        Route::get('{id}/edit', [IncomeController::class, 'edit'])->name('income.edit');
        Route::post('/update', [IncomeController::class, 'update'])->name('income.update');
        Route::delete('delete/{id}', [IncomeController::class, 'destroy'])->name('income.destroy');
        Route::get('{id}/print', [IncomeController::class, 'print'])->name('income.print');
    });

    Route::prefix('expense')->group(function () {
        Route::get('/', [ExpenseController::class, 'index'])->name('expense.index');
        Route::post('store', [ExpenseController::class, 'store'])->name('expense.store');
        Route::get('{id}/show', [ExpenseController::class, 'show'])->name('expense.show');
        Route::get('{id}/edit', [ExpenseController::class, 'edit'])->name('expense.edit');
        Route::post('/update', [ExpenseController::class, 'update'])->name('expense.update');
        Route::delete('delete/{id}', [ExpenseController::class, 'destroy'])->name('expense.destroy');
        Route::get('{id}/print', [ExpenseController::class, 'print'])->name('expense.print');
    });

    //----------------------bank account Route------------------------
    Route::prefix('bank-account')->group(function () {
        Route::get('/', [BankAccountController::class, 'index'])->name('bank_account.index');
        Route::post('store', [BankAccountController::class, 'store'])->name('bank_account.store');
        Route::get('{id}/show', [BankAccountController::class, 'show'])->name('bank_account.show');
        Route::post('/update', [BankAccountController::class, 'update'])->name('bank_account.update');
        Route::delete('delete/{id}', [BankAccountController::class, 'destroy'])->name('bank_account.destroy');
    });

    //----------------------bank deposit Route------------------------
    Route::prefix('bank-deposit')->group(function () {
        Route::get('/', [BankDepositController::class, 'index'])->name('bank_deposit.index');
        Route::post('store', [BankDepositController::class, 'store'])->name('bank_deposit.store');
        Route::get('{id}/show', [BankDepositController::class, 'show'])->name('bank_deposit.show');
        Route::post('/update', [BankDepositController::class, 'update'])->name('bank_deposit.update');
        Route::delete('delete/{id}', [BankDepositController::class, 'destroy'])->name('bank_deposit.destroy');
    });

    //----------------------bank withdraw Route------------------------
    Route::prefix('bank-withdraw')->group(function () {
        Route::get('/', [BankWithdrawController::class, 'index'])->name('bank_withdraw.index');
        Route::post('store', [BankWithdrawController::class, 'store'])->name('bank_withdraw.store');
        Route::post('/update', [BankWithdrawController::class, 'update'])->name('bank_withdraw.update');
        Route::delete('delete/{id}', [BankWithdrawController::class, 'destroy'])->name('bank_withdraw.destroy');
    });

    Route::prefix('check-books')->group(function () {
        Route::get('/', [CheckBookController::class, 'index'])->name('check-books.index');
        Route::post('store', [CheckBookController::class, 'store'])->name('check-books.store');
        Route::post('/update', [CheckBookController::class, 'update'])->name('check-books.update');
        Route::delete('delete/{id}', [CheckBookController::class, 'destroy'])->name('check-books.destroy');
    });

    //----------------------Income Item Route------------------------
    Route::prefix('income-item')->group(function () {
        Route::get('/', [IncomeItemController::class, 'index'])->name('income-item.index');
        Route::get('create', [IncomeItemController::class, 'create'])->name('income-item.create');
        Route::post('store', [IncomeItemController::class, 'store'])->name('income-item.store');
        Route::get('{incomeItem}/edit', [IncomeItemController::class, 'edit'])->name('income-item.edit');
        Route::put('update/{incomeItem}', [IncomeItemController::class, 'update'])->name('income-item.update');
        Route::delete('delete/{incomeItem}', [IncomeItemController::class, 'destroy'])->name('income-item.destroy');
    });

    //----------------------Expense Item Route------------------------
    Route::prefix('expense-item')->group(function () {
        Route::get('/', [ExpenseItemController::class, 'index'])->name('expense-item.index');
        Route::get('create', [ExpenseItemController::class, 'create'])->name('expense-item.create');
        Route::post('store', [ExpenseItemController::class, 'store'])->name('expense-item.store');
        Route::get('{expenseItem}/edit', [ExpenseItemController::class, 'edit'])->name('expense-item.edit');
        Route::put('update/{expenseItem}', [ExpenseItemController::class, 'update'])->name('expense-item.update');
        Route::delete('delete/{expenseItem}', [ExpenseItemController::class, 'destroy'])->name('expense-item.destroy');
    });

    //----------------------Product Sales Route------------------------

});
