<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admission\AdmissionFeeController;
use App\Http\Controllers\Admission\OnlineAdmissionController;
use App\Http\Controllers\Admission\OnlineAdmissionSettingController;

Route::middleware('auth')->group(function () {

    
    //----------------------Admission Setting Route------------------------
    Route::prefix('setting')->group(function () {
        Route::get('/', [OnlineAdmissionSettingController::class, 'index'])->name('admission-setting.index');
        Route::post('update/{id}', [OnlineAdmissionSettingController::class, 'update'])->name('admission-setting.update');
    });
    //----------------------admission fees Route------------------------
    Route::prefix('admission-fees')->group(function () {
        Route::get('/', [AdmissionFeeController::class, 'index'])->name('admission-fee.index');
        Route::post('store', [AdmissionFeeController::class, 'store'])->name('admission-fee.store');
        Route::post('update', [AdmissionFeeController::class, 'update'])->name('admission-fee.update');
        Route::get('delete/{feeType}', [AdmissionFeeController::class, 'destroy'])->name('admission-fee.destroy');
    });

    //===================== online-admission Related Route List ===========================
    Route::prefix('online-admission')->group(function () {
        Route::get('/list', [OnlineAdmissionController::class, 'index'])->name('online-admission.index');
        Route::get('/selected-applicant-list', [OnlineAdmissionController::class, 'selectedApplicantList'])->name('online-admission.selected-applicant-list');
        Route::post('/applicant-to-selected', [OnlineAdmissionController::class, 'applicantsToSelected'])->name('online-admission.applicant-to-selected');
        Route::post('/selected-to-admitted', [OnlineAdmissionController::class, 'selectedToAdmitted'])->name('online-admission.selected-to-admitted');
        Route::get('/show/{id}', [OnlineAdmissionController::class, 'show'])->name('online-admission.show');
        Route::get('/admitted-list', [OnlineAdmissionController::class, 'admittedList'])->name('online-admission.admitted-ist');
        Route::get('/selected-applicant-payment/{id}', [OnlineAdmissionController::class, 'selectedApplicantPayment'])->name('selected-applicant-payment');
        Route::post('/selected-applicant-admitted/{id}', [OnlineAdmissionController::class, 'selectedApplicantAdmitted'])->name('selected-applicant-admitted');
        Route::get('/invoice-print/{id}', [OnlineAdmissionController::class, 'invoicePrint'])->name('selected-applicant-payment-print');
    });




});
