<?php

use App\Http\Controllers\Api\V1\IBBLPaymentController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\V1\StudentPaymentController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::middleware('checkApi')->group(function () {
    Route::get('student', [StudentPaymentController::class, 'create']);
});

Route::prefix('v1')->group(function () {
    Route::post('getFeeInfo', [IBBLPaymentController::class, 'getFeeInfo']);
    Route::post('payment', [IBBLPaymentController::class, 'handlePaymentNotification']);
});
