<?php

use App\Http\Controllers\Attendance\StudentAttendanceController;
use Illuminate\Support\Facades\Route;

Route::middleware('auth')->prefix('student-attendance')->group(function () {
    Route::get('/', [StudentAttendanceController::class, 'index'])->name('student_attendance.index');
    Route::get('/create', [StudentAttendanceController::class, 'create'])->name('student_attendance.create');
    Route::get('/my-student', [StudentAttendanceController::class, 'myStudent'])->name('student_attendance.my-student');
    Route::post('/search', [StudentAttendanceController::class, 'search'])->name('student_attendance.search');
    Route::post('/store', [StudentAttendanceController::class, 'store'])->name('student_attendance.store');

    Route::get('/attendance-report', [StudentAttendanceController::class, 'attendanceReport'])->name('student_attendance.report');
    Route::post('/attendance-search', [StudentAttendanceController::class, 'searchAttendance'])->name('student_attendance.attendance_report');

    Route::get('/attendance-report-date-to-date', [StudentAttendanceController::class, 'attendanceReportDateToDate'])->name('student_attendance.report.date_to_date');
    Route::get('/attendance-report-date-to-date-search', [StudentAttendanceController::class, 'attendanceReportDateToDateSearch'])->name('student_attendance.report.date_to_date.search');

    Route::get('attendance-report-export', [StudentAttendanceController::class, 'attendanceExport'])->name('attendance.export');
});