<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Holiday\HolidayController;
Route::middleware('auth')->group(function () {
    Route::prefix('setup')->group(function () {
        Route::get('/', [HolidayController::class, 'index'])->name('holiday.index');
        Route::get('/create', [HolidayController::class, 'create'])->name('holiday.create');
        Route::post('/store', [HolidayController::class, 'store'])->name('holiday.store');
        Route::get('/show/{holiday}', [HolidayController::class, 'show'])->name('holiday.show');
        Route::get('/edit/{holiday}', [HolidayController::class, 'edit'])->name('holiday.edit');
        Route::put('/update/{holiday}', [HolidayController::class, 'update'])->name('holiday.update');
        Route::delete('/delete/{holiday}', [HolidayController::class, 'destroy'])->name('holiday.destroy');
        Route::get('copy/{holiday}', [HolidayController::class, 'copyRecord'])->name('holiday.copy');
        Route::post('copy/{holiday}', [HolidayController::class, 'copyStore'])->name('holiday.copy.store');
        Route::get('/calendar', [HolidayController::class, 'calendar'])->name('calendar.index');
        Route::get('/calendar/events', [HolidayController::class, 'fetchEvents'])->name('calendar.events');
        Route::post('/calendar/events', [HolidayController::class, 'storeEvent'])->name('calendar.store');
    });
});
