<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Homework\HomeworkController;
use App\Http\Controllers\Homework\HomeworkSubmissionController;

Route::middleware('auth')->group(function () {
    Route::prefix('homework')->group(function () {
        Route::get('/', [HomeworkController::class, 'index'])->name('homework.index');
        Route::get('/create', [HomeworkController::class, 'create'])->name('homework.create');
        Route::post('/store', [HomeworkController::class, 'store'])->name('homework.store');
        Route::get('/show/{homework}', [HomeworkController::class, 'show'])->name('homework.show');
        Route::get('/edit/{homework}', [HomeworkController::class, 'edit'])->name('homework.edit');
        Route::put('/update/{homework}', [HomeworkController::class, 'update'])->name('homework.update');
        Route::delete('/delete/{homework}', [HomeworkController::class, 'destroy'])->name('homework.destroy');
    });
    Route::prefix('homework-submission')->group(function () {
        Route::get('/', [HomeworkSubmissionController::class, 'index'])->name('homework_submission.index');
        Route::get('/create', [HomeworkSubmissionController::class, 'create'])->name('homework_submission.create');
        Route::post('/store', [HomeworkSubmissionController::class, 'store'])->name('homework_submission.store');
        Route::get('/show/{id}', [HomeworkSubmissionController::class, 'show'])->name('homework_submission.show');
        Route::get('/edit/{id}', [HomeworkSubmissionController::class, 'edit'])->name('homework_submission.edit');
        Route::put('/update/{id}', [HomeworkSubmissionController::class, 'update'])->name('homework_submission.update');
        Route::delete('/delete/{id}', [HomeworkSubmissionController::class, 'destroy'])->name('homework_submission.destroy');
        Route::get('/view', [HomeworkSubmissionController::class, 'resultView'])->name('homework.result.view');
        Route::post('/view-search', [HomeworkSubmissionController::class, 'resultViewSearch'])->name('homework.result.search');
        Route::post('/marks-entry', [HomeworkSubmissionController::class, 'resultMarksEntry'])->name('homework.marks.entry');
    });
});
