<?php

use App\Http\Controllers\Hostel\MultipleAssignHostelRoomController;
use App\Http\Controllers\Hostel\AssignHostelRoomController;
use App\Http\Controllers\Hostel\HostelController;
use App\Http\Controllers\Hostel\HostelRoomController;
use App\Http\Controllers\Hostel\RoomTypeController;
use Illuminate\Support\Facades\Route;


Route::middleware('auth')->group(function () {

    //----------Dormatory Route List--------------
    Route::get('/list', [HostelController::class, 'index'])->name('hostel.index');
    Route::get('/create', [HostelController::class, 'create'])->name('hostel.create');
    Route::post('/store', [HostelController::class, 'store'])->name('hostel.store');
    Route::get('/{hostel}', [HostelController::class, 'show'])->name('hostel.show');
    Route::get('/edit/{hostel}', [HostelController::class, 'edit'])->name('hostel.edit');
    Route::put('/update/{hostel}', [HostelController::class, 'update'])->name('hostel.update');
    Route::delete('/{hostel}', [HostelController::class, 'destroy'])->name('hostel.destroy');

    //------------Dormitory Room Route List-------

    Route::prefix('hostel-rooms')->group(function () {
        Route::get('/list', [HostelRoomController::class, 'index'])->name('hostel-room.index');
        Route::get('/create', [HostelRoomController::class, 'create'])->name('hostel-room.create');
        Route::post('/store', [HostelRoomController::class, 'store'])->name('hostel-room.store');
        // Route::get('/{hostelRoom}', [HostelRoomController::class, 'show'])->name('hostel-room.show');
        // Route::get('/edit/{hostelRoom}', [HostelRoomController::class, 'edit'])->name('hostel-room.edit');
        Route::put('/update/{hostelRoom}', [HostelRoomController::class, 'update'])->name('hostel-room.update');
        Route::delete('/{hostelRoom}', [HostelRoomController::class, 'destroy'])->name('hostel-room.destroy');

        Route::get('list-by-floor', [HostelRoomController::class, 'getHostelRooms'])->name('hostel-room-by-floor');
        
        Route::get('/get-room-list-by-hostel', [HostelRoomController::class, 'roomList'])->name('rooms_by_hostel');
    });

    Route::prefix('hostel-floor')->group(function () {
        Route::get('list-by-hostel', [HostelRoomController::class, 'getHostelFloors'])->name('hostel.floors');
    });

    Route::prefix('room-type')->group(function () {
        Route::get('/list', [RoomTypeController::class, 'index'])->name('room-type.index');
        Route::get('/create', [RoomTypeController::class, 'create'])->name('room-type.create');
        Route::post('/store', [RoomTypeController::class, 'store'])->name('room-type.store');
        Route::get('/{roomType}', [RoomTypeController::class, 'show'])->name('room-type.show');
        Route::get('/edit/{roomType}', [RoomTypeController::class, 'edit'])->name('room-type.edit');
        Route::put('/update/{roomType}', [RoomTypeController::class, 'update'])->name('room-type.update');
        Route::delete('/{roomType}', [RoomTypeController::class, 'destroy'])->name('room-type.destroy');

    });

    Route::prefix('assign-room')->group(function () {
        Route::get('/list', [AssignHostelRoomController::class, 'index'])->name('assign_room.index');
        Route::post('/store', [AssignHostelRoomController::class, 'assignHostelRoom'])->name('assign_room.store');

        Route::get('/search-hostel-rooms', [AssignHostelRoomController::class, 'searchHostelRooms'])->name('hostel-rooms.search');
        Route::get('/student-hostel-room', [AssignHostelRoomController::class, 'studentHostelRooms'])->name('student-hostel-rooms');
        Route::get('/list-by-hostel', [AssignHostelRoomController::class, 'listByHostel'])->name('hostel_room.list_by_hostel');
    });

    Route::prefix('multiple-student-assign')->group(function () {
        Route::get('/list', [MultipleAssignHostelRoomController::class, 'index'])->name('multi.assign_room.index');
        Route::post('/store', [MultipleAssignHostelRoomController::class, 'assignHostelRoom'])->name('multi.assign_room.store');
    });


});
