<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HrPayroll\HrDepartmentController;
use App\Http\Controllers\HrPayroll\EmployeeController;
use App\Http\Controllers\HrPayroll\EmployeeSalaryController;
use App\Http\Controllers\HrPayroll\EmployeeTypeController;
use App\Http\Controllers\HrPayroll\DesignationController;
use App\Http\Controllers\HrPayroll\LeaveController;
use App\Http\Controllers\HrPayroll\LeaveTypeController;
use App\Http\Controllers\HrPayroll\SalarySettingController;
use App\Http\Controllers\HrPayroll\EmployeeAttendanceController;

Route::middleware('auth')->group(function () {

    //---------Employee Route List---------
    Route::prefix('employees')->group(function () {
        Route::get('/', [EmployeeController::class, 'index'])->name('employees.index');
        Route::get('/create', [EmployeeController::class, 'create'])->name('employees.create');
        Route::post('/store', [EmployeeController::class, 'store'])->name('employees.store');
        Route::get('/show/{employee}', [EmployeeController::class, 'show'])->name('employees.show');
        Route::get('/edit/{employee}', [EmployeeController::class, 'edit'])->name('employees.edit');
        Route::put('/update/{employee}', [EmployeeController::class, 'update'])->name('employees.update');
        Route::delete('/destroy/{employee}', [EmployeeController::class, 'destroy'])->name('employees.destroy');

        Route::get('search', [EmployeeController::class, 'searchEmployee'])->name('employees.search');
    });

    Route::prefix('salary-setting')->group(function () {

        Route::get('/', [SalarySettingController::class, 'index'])->name('salary-setting.index');

        Route::get('view-head', [SalarySettingController::class, 'viewHead'])->name('salary-heads.view');
        Route::post('store-head', [SalarySettingController::class, 'storeHead'])->name('salary-heads.store');
        Route::put('update-head/{salaryHead}', [SalarySettingController::class, 'updateHead'])->name('salary-heads.update');
        Route::delete('destroy-head/{salaryHead}', [SalarySettingController::class, 'destroyHead'])->name('salary-heads.destroy');

        Route::get('view-grade', [SalarySettingController::class, 'viewGrade'])->name('salary-grades.view');
        Route::post('store-grade', [SalarySettingController::class, 'storeGrade'])->name('salary-grades.store');
        Route::post('update-grade/{salaryGrade}', [SalarySettingController::class, 'updateGrade'])->name('salary-grades.update');
        Route::get('edit-grade/{salaryGrade}', [SalarySettingController::class, 'editGrade'])->name('salary-grades.edit');
        Route::delete('destroy-grade/{salaryGrade}', [SalarySettingController::class, 'destroyGrade'])->name('salary-grades.destroy');

    });

    //---------Employee salary Route List---------
    Route::prefix('employee-salaries')->group(function () {
        Route::get('/', [EmployeeSalaryController::class, 'index'])->name('employee-salary.index');
        Route::get('create', [EmployeeSalaryController::class, 'create'])->name('employee-salary.create');
        Route::post('store', [EmployeeSalaryController::class, 'store'])->name('employee-salary.store');
    });

    Route::prefix('monthly-salaries')->group(function () {
        Route::get('/', [EmployeeSalaryController::class, 'salarySheet'])->name('monthly-salary.index');
        Route::get('create', [EmployeeSalaryController::class, 'monthlySalaryCreate'])->name('monthly-salary.create');
        Route::post('store', [EmployeeSalaryController::class, 'monthlySalaryStore'])->name('monthly-salary.store');
        Route::get('sheet', [EmployeeSalaryController::class, 'monthlySalarySheet'])->name('monthly-salary.sheet');
    });

    //---------Employee type Route List---------
    Route::prefix('employee-types')->group(function () {
        Route::get('/', [EmployeeTypeController::class, 'index'])->name('employee_type.index');
        Route::get('create', [EmployeeTypeController::class, 'create'])->name('employee_type.create');
        Route::post('store', [EmployeeTypeController::class, 'store'])->name('employee_type.store');
        Route::get('edit/{type}', [EmployeeTypeController::class, 'edit'])->name('employee_type.edit');
        Route::post('update', [EmployeeTypeController::class, 'update'])->name('employee_type.update');
        Route::delete('destroy/{type}', [EmployeeTypeController::class, 'destroy'])->name('employee_type.destroy');
    });

    //---------Designation Route List---------
    Route::prefix('designations')->group(function () {
        Route::get('/', [DesignationController::class, 'index'])->name('designation.index');
        Route::get('create', [DesignationController::class, 'create'])->name('designation.create');
        Route::post('store', [DesignationController::class, 'store'])->name('designation.store');
        Route::get('edit/{type}', [DesignationController::class, 'edit'])->name('designation.edit');
        Route::post('update', [DesignationController::class, 'update'])->name('designation.update');
        Route::delete('destroy/{id}', [DesignationController::class, 'destroy'])->name('designation.destroy');
    });

    //---------Department Route List----------
    Route::prefix('departments')->group(function () {
        Route::get('/', [HrDepartmentController::class, 'index'])->name('hr-department.index');
        Route::get('create', [HrDepartmentController::class, 'create'])->name('hr-department.create');
        Route::post('store', [HrDepartmentController::class, 'store'])->name('hr-department.store');
        Route::get('edit/{type}', [HrDepartmentController::class, 'edit'])->name('hr-department.edit');
        Route::post('update', [HrDepartmentController::class, 'update'])->name('hr-department.update');
        Route::delete('destroy/{id}', [HrDepartmentController::class, 'destroy'])->name('hr-department.destroy');
    });

    //=================Leave Management================
    Route::prefix('leave-type')->group(function () {
        Route::get('/', [LeaveTypeController::class, 'index'])->name('leave-type.index');
        Route::post('/store', [LeaveTypeController::class, 'store'])->name('leave-type.store');
        Route::post('/update/{leaveType}', [LeaveTypeController::class, 'update'])->name('leave-type.update');
        Route::delete('/destroy/{leaveType}', [LeaveTypeController::class, 'destroy'])->name('leave-type.destroy');
    });

    Route::prefix('leaves')->group(function () {
        Route::get('/', [LeaveController::class, 'index'])->name('leaves.index');
        Route::get('/create', [LeaveController::class, 'create'])->name('leaves.create');
        Route::post('/store', [LeaveController::class, 'store'])->name('leaves.store');
        Route::get('/{leave}/details', [LeaveController::class, 'details'])->name('leaves.details');
        Route::get('/{leave}/edit', [LeaveController::class, 'edit'])->name('leaves.edit');
        Route::post('/update', [LeaveController::class, 'update'])->name('leaves.update');
        Route::delete('/destroy/{leave}', [LeaveController::class, 'destroy'])->name('leaves.destroy');

        Route::get('/request', [LeaveController::class, 'leaveRequest'])->name('leaves-request.index');
        Route::get('/request/create', [LeaveController::class, 'leaveRequestCreate'])->name('leaves-request.create');
        Route::post('/request/store', [LeaveController::class, 'leaveRequestStore'])->name('leaves-request.store');
        Route::get('/request/{leave}/edit', [LeaveController::class, 'leaveRequestEdit'])->name('leaves-request.edit');
        Route::put('/request/{leave}/update', [LeaveController::class, 'leaveRequestUpdate'])->name('leaves-request.update');
    });

    //=================Leave Management================
    Route::prefix('attendance')->group(function () {
        Route::get('/', [EmployeeAttendanceController::class, 'index'])->name('employee.attendance.index');
        Route::post('/attendance-file-upload', [EmployeeAttendanceController::class, 'attendanceFileUpload'])->name('employee.attendance.file.upload');
        Route::post('/update/{leaveType}', [EmployeeAttendanceController::class, 'update'])->name('employee.attendance.update');
        Route::get('/destroy/{leaveType}', [EmployeeAttendanceController::class, 'destroy'])->name('employee.attendance.destroy');
    });

});
