<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Hsc\GroupSubjectController;
use App\Http\Controllers\Hsc\HscAdmissionController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::middleware('auth')->group(function () {
    //---------subject-grouping Route List----------
    Route::prefix('subject-grouping')->group(function () {
        Route::get('/', [GroupSubjectController::class, 'index'])->name('group-subject.index');
        Route::post('/store', [GroupSubjectController::class, 'store'])->name('group-subject.store');
        Route::get('/{id}/show', [GroupSubjectController::class, 'show'])->name('group-subject.show');
        Route::get('/{id}/edit', [GroupSubjectController::class, 'edit'])->name('group-subject.edit');
        Route::post('/{id}/update', [GroupSubjectController::class, 'update'])->name('group-subject.update');
        Route::delete('/destroy/{id}', [GroupSubjectController::class, 'destroy'])->name('group-subject.destroy');
    });

    Route::prefix('applicant')->group(function () {
        Route::get('/', [HscAdmissionController::class, 'index'])->name('hsc-admission.index');
        Route::post('/hsc-admission.selected-data', [HscAdmissionController::class, 'bulkSelectedData'])->name('hsc-admission.selected-data');
        Route::get('/{id}/show', [HscAdmissionController::class, 'show'])->name('hsc-admission.show');
        Route::get('/{id}/edit', [HscAdmissionController::class, 'edit'])->name('hsc-admission.edit');
        Route::post('/{id}/update', [HscAdmissionController::class, 'update'])->name('hsc-admission.update');
        Route::get('/{id}/destroy', [HscAdmissionController::class, 'destroy'])->name('hsc-admission.destroy');
        Route::get('/{id}/print', [HscAdmissionController::class, 'print'])->name('hsc-admission.print');
    });

});


   
