<?php

use App\Http\Controllers\Inventory\ProductController;
use App\Http\Controllers\Inventory\SalesController;
use Illuminate\Support\Facades\Route;


Route::middleware('auth')->group(function () {

    Route::prefix('products')->group(function () {
        Route::get('/', [ProductController::class, 'index'])->name('product.index');
        Route::get('/create', [ProductController::class, 'create'])->name('product.create');
        Route::post('/store', [ProductController::class, 'store'])->name('product.store');
        Route::get('/show/{product}', [ProductController::class, 'show'])->name('product.show');
        Route::get('/edit/{product}', [ProductController::class, 'edit'])->name('product.edit');
        Route::post('/update', [ProductController::class, 'update'])->name('product.update');
        Route::delete('/delete/{product}', [ProductController::class, 'destroy'])->name('product.destroy');
    });

    Route::prefix('sales')->group(function () {
        Route::get('/', [SalesController::class, 'index'])->name('sales.index');
        Route::get('/create', [SalesController::class, 'create'])->name('sales.create');
        Route::post('/store', [SalesController::class, 'store'])->name('sales.store');
        Route::get('/show/{sale}', [SalesController::class, 'show'])->name('sales.show');
        Route::get('/edit/{sale}', [SalesController::class, 'edit'])->name('sales.edit');
        Route::put('/update/{sale}', [SalesController::class, 'update'])->name('sales.update');
        Route::delete('/delete/{sale}', [SalesController::class, 'destroy'])->name('sales.destroy');
        Route::get('/search', [SalesController::class, 'search'])->name('products.search');
        Route::get('/product-search', [SalesController::class, 'productSearch'])->name('product.search');
        Route::get('/print/{sale}', [SalesController::class, 'print'])->name('sales.print');

    });
    

});
