<?php

use App\Http\Controllers\Library\BooklistController;
use App\Http\Controllers\Library\BookmemberController;
use App\Http\Controllers\Library\BookissueController;
use Illuminate\Support\Facades\Route;

Route::middleware('auth')->group(function () {

    Route::prefix('book-list')->group(function () {
        Route::get('/', [BooklistController::class, 'index'])->name('booklist.index');
        Route::get('/create', [BooklistController::class, 'create'])->name('booklist.create');
        Route::post('/store', [BooklistController::class, 'store'])->name('booklist.store');
        Route::get('/show/{booklist}', [BooklistController::class, 'show'])->name('booklist.show');
        Route::get('/edit/{booklist}', [BooklistController::class, 'edit'])->name('booklist.edit');
        Route::put('/update/{booklist}', [BooklistController::class, 'update'])->name('booklist.update');
        Route::delete('/delete/{booklist}', [BooklistController::class, 'destroy'])->name('booklist.destroy');
    });

    Route::prefix('member')->group(function () {
        Route::get('/', [BookmemberController::class, 'index'])->name('bookmember.index');
        Route::get('/create', [BookmemberController::class, 'create'])->name('bookmember.create');
        Route::post('/store', [BookmemberController::class, 'store'])->name('bookmember.store');
        Route::get('/show/{bookmember}', [BookmemberController::class, 'show'])->name('bookmember.show');
        Route::get('/edit/{bookmember}', [BookmemberController::class, 'edit'])->name('bookmember.edit');
        Route::put('/update/{bookmember}', [BookmemberController::class, 'update'])->name('bookmember.update');
        Route::delete('/delete/{bookmember}', [BookmemberController::class, 'destroy'])->name('bookmember.destroy');
        Route::get('/userByType/{user_type?}', [BookmemberController::class, 'userByType'])->name('userByType');
    });

    Route::prefix('book-issue')->group(function () {
        Route::get('/', [BookissueController::class, 'index'])->name('bookissue.index');
        Route::get('/create', [BookissueController::class, 'create'])->name('bookissue.create');
        Route::post('/store', [BookissueController::class, 'store'])->name('bookissue.store');
        Route::get('/show/{bookissue}', [BookissueController::class, 'show'])->name('bookissue.show');
        Route::get('/edit/{bookissue}', [BookissueController::class, 'edit'])->name('bookissue.edit');
        Route::put('/update/{bookissue}', [BookissueController::class, 'update'])->name('bookissue.update');
        Route::delete('/delete/{bookissue}', [BookissueController::class, 'destroy'])->name('bookissue.destroy');
        Route::get('/{member_id}', [BookissueController::class, 'bookIssue'])->name('book.issue');
        Route::post('/book-return', [BookissueController::class, 'bookReturn'])->name('book.return');
    });

});
