<?php

use App\Http\Controllers\Report\AccountingReportController;
use App\Http\Controllers\Report\AttendanceReportController;
use App\Http\Controllers\Report\ExamResultReportController;
use App\Http\Controllers\Report\TransportReportController;
use App\Http\Controllers\Report\LibraryReportController;
use App\Http\Controllers\Report\StudentReportController;
use App\Http\Controllers\Report\SyllabusReportController;
use App\Http\Controllers\Report\HostelReportController;
use App\Http\Controllers\Report\MultiBranchReportController;
use App\Http\Controllers\Report\ResultReportController;
use Illuminate\Support\Facades\Route;

Route::middleware('auth')->group(function () {
    Route::prefix('library')->group(function () {
        Route::get('/', [LibraryReportController::class, 'index'])->name('library.report.index');
        Route::get('/book-issue-report', [LibraryReportController::class, 'bookIssueReport'])->name('library-book-issue-report');
        Route::post('/book-issue-report-search', [LibraryReportController::class, 'bookIssueReportSearch'])->name('library-book-issue-report-search');
        Route::post('/excel-export-library', [LibraryReportController::class, 'exportExcel'])->name('excel-export-library');
        Route::post('/pdf-export-library', [LibraryReportController::class, 'exportPDF'])->name('pdf-export-library');

        Route::get('/book-due-report', [LibraryReportController::class, 'bookDueReport'])->name('library-book-due-report');
        Route::post('/book-due-report-search', [LibraryReportController::class, 'bookDueReportSearch'])->name('library-book-due-report-search');
        Route::post('/book-due-excel-export-library', [LibraryReportController::class, 'dueExportExcel'])->name('library-book-due-excel-export');
        Route::post('/book-due-pdf-export-library', [LibraryReportController::class, 'dueExportPDF'])->name('library-book-due-pdf-export');

        Route::get('/book-return-report', [LibraryReportController::class, 'bookReturnReport'])->name('library-book-return-report');
        Route::post('/book-return-report-search', [LibraryReportController::class, 'bookReturnReportSearch'])->name('library-book-return-report-search');
        Route::post('/book-return-excel-export-library', [LibraryReportController::class, 'returnExportExcel'])->name('library-book-return-excel-export');
        Route::post('/book-return-pdf-export-library', [LibraryReportController::class, 'returnExportPDF'])->name('library-book-return-pdf-export');
    });

    Route::prefix('syllabus')->group(function () {
        Route::get('/', [SyllabusReportController::class, 'index'])->name('syllabus.report.index');
        Route::get('/syllabus-status-report', [SyllabusReportController::class, 'syllabusStatus'])->name('syllabus.status.report');
        Route::post('/syllabus-status-report-search', [SyllabusReportController::class, 'syllabusStatusSearch'])->name('syllabus.status.report.search');
        Route::post('/syllabus-pdf-export', [SyllabusReportController::class, 'pdfExport'])->name('syllabus.pdf.export');
    });

    Route::prefix('attendance')->group(function () {
        Route::get('/', [AttendanceReportController::class, 'index'])->name('report.attendance.index'); 
        Route::get('/attendance-date-to-date-report', [AttendanceReportController::class, 'dateToDateReport'])->name('attendance-date-to-date-report');
        Route::post('/attendance-date-to-date-report-search', [AttendanceReportController::class, 'dateToDateReportSearch'])->name('attendance-date-to-date-report-search');
        Route::post('/attendance-date-to-date-excel-export', [AttendanceReportController::class, 'dateToDateExportExcel'])->name('attendance-date-to-date-excel-export');
        Route::post('/attendance-date-to-date-pdf-export', [AttendanceReportController::class, 'dateToDateExportPDF'])->name('attendance-date-to-date-pdf-export');
        
        // type-wise-attendance-repost
        Route::get('/type-wise-attendance-report', [AttendanceReportController::class, 'typeWiseAttendanceReport'])->name('type-wise-attendance-report');
        Route::post('/type-wise-attendance-report-search', [AttendanceReportController::class, 'typeWiseAttendanceReportSearch'])->name('type-wise-attendance-report-search');
        Route::post('/type-wise-attendance-excel-export', [AttendanceReportController::class, 'typeWiseAttendanceExportExcel'])->name('type-wise-attendance-excel-export');
        Route::post('/type-wise-attendance-pdf-export', [AttendanceReportController::class, 'typeWiseAttendanceExportPDF'])->name('type-wise-attendance-pdf-export');

        // type-wise-attendance-repost
        Route::get('/total-attendance-report', [AttendanceReportController::class, 'totalAttendanceReport'])->name('total-attendance-report');
        Route::post('/total-attendance-report-search', [AttendanceReportController::class, 'totalAttendanceReportSearch'])->name('total-attendance-report-search');
        Route::post('/total-attendance-excel-export', [AttendanceReportController::class, 'totalAttendanceExportExcel'])->name('total-attendance-excel-export');
        Route::post('/total-attendance-pdf-export', [AttendanceReportController::class, 'totalAttendanceExportPDF'])->name('total-attendance-pdf-export');
    });

    Route::prefix('students')->group(function () {
        Route::get('/', [StudentReportController::class, 'index'])->name('report.students.index');

        Route::get('/information-report', [StudentReportController::class, 'informationReport'])->name('students.information.report');
        Route::post('/information-report-export-excel', [StudentReportController::class, 'informationReportExportExcel'])->name('students.information.export-excel');
        Route::post('/information-report-export-pdf', [StudentReportController::class, 'informationReportExportPDF'])->name('students.information.export-pdf');
        Route::get('/information-report-export-print', [StudentReportController::class, 'informationReportExportPrint'])->name('students.information.export-print');
        
        Route::get('/class-section-report', [StudentReportController::class, 'classSectionReport'])->name('students.class-section.report');
        Route::post('/class-section-report-export-pdf', [StudentReportController::class, 'classSectionReportExportPDF'])->name('students.class-section.export-pdf');
        Route::get('/class-section-report-export-print', [StudentReportController::class, 'classSectionReportExportPrint'])->name('students.class-section.export-print');
        
        Route::get('/sibling-report', [StudentReportController::class, 'siblingReport'])->name('student-sibling.report');
        Route::post('/sibling-report-export-pdf', [StudentReportController::class, 'siblingReportExportPDF'])->name('students.sibling.export-pdf');
        Route::get('/sibling-report-export-print', [StudentReportController::class, 'siblingReportExportPrint'])->name('students.sibling.export-print');
    });

    Route::prefix('accounting')->group(function () {
        Route::get('/', [AccountingReportController::class, 'index'])->name('report.accounting.index');
        
        Route::get('/daily-collection-report', [AccountingReportController::class, 'dailyCollection'])->name('accounting.daily-collection.report');
        Route::post('/daily-collection-report-export-excel', [AccountingReportController::class, 'dailyCollectionExportExcel'])->name('accounting.daily-collection.export-excel');
        Route::post('/daily-collection-report-export-pdf', [AccountingReportController::class, 'dailyCollectionExportPDF'])->name('accounting.daily-collection.export-pdf');
        Route::get('/daily-collection-report-export-print', [AccountingReportController::class, 'dailyCollectionExportPrint'])->name('accounting.daily-collection.export-print');

        Route::get('/payment-details-report', [AccountingReportController::class, 'paymentDetailsReport'])->name('accounting.payment-details.report');
        Route::post('/payment-details-report-export-excel', [AccountingReportController::class, 'paymentDetailsReportExportExcel'])->name('accounting.payment-details.export-excel');
        Route::post('/payment-details-report-export-pdf', [AccountingReportController::class, 'paymentDetailsReportExportPDF'])->name('accounting.payment-details.export-pdf');
        Route::get('/payment-details-report-export-print', [AccountingReportController::class, 'paymentDetailsReportExportPrint'])->name('accounting.payment-details.export-print');

        Route::get('/due-fees-report', [AccountingReportController::class, 'dueFeesReport'])->name('accounting.due-fees.report');
        Route::post('/due-fees-report-export-excel', [AccountingReportController::class, 'dueFeesReportExportExcel'])->name('accounting.due-fees.export-excel');
        Route::post('/due-fees-report-export-pdf', [AccountingReportController::class, 'dueFeesReportExportPDF'])->name('accounting.due-fees.export-pdf');
        Route::get('/due-fees-report-export-print', [AccountingReportController::class, 'dueFeesReportExportPrint'])->name('accounting.due-fees.export-print');

        Route::get('/income-report', [AccountingReportController::class, 'incomeReport'])->name('accounting.income.report');
        Route::post('/income-report-export-excel', [AccountingReportController::class, 'incomeReportExportExcel'])->name('accounting.income.export-excel');
        Route::post('/income-report-export-pdf', [AccountingReportController::class, 'incomeReportExportPDF'])->name('accounting.income.export-pdf');
        Route::get('/income-report-export-print', [AccountingReportController::class, 'incomeReportExportPrint'])->name('accounting.income.export-print');

        Route::get('/expense-report', [AccountingReportController::class, 'expenseReport'])->name('accounting.expense.report');
        Route::post('/expense-report-export-excel', [AccountingReportController::class, 'expenseReportExportExcel'])->name('accounting.expense.export-excel');
        Route::post('/expense-report-export-pdf', [AccountingReportController::class, 'expenseReportExportPDF'])->name('accounting.expense.export-pdf');
        Route::get('/expense-report-export-print', [AccountingReportController::class, 'expenseReportExportPrint'])->name('accounting.expense.export-print');
        
        Route::get('/payroll-report', [AccountingReportController::class, 'payrollReport'])->name('accounting.payroll.report');
        Route::post('/payroll-report-export-excel', [AccountingReportController::class, 'payrollReportExportExcel'])->name('accounting.payroll.export-excel');
        Route::post('/payroll-report-export-pdf', [AccountingReportController::class, 'payrollReportExportPDF'])->name('accounting.payroll.export-pdf');
        Route::get('/payroll-report-export-print', [AccountingReportController::class, 'payrollReportExportPrint'])->name('accounting.payroll.export-print');

        Route::get('/income-expense-summary', [AccountingReportController::class, 'incomeExpenseSummary'])->name('accounting.income-expense.summary');
        Route::post('/income-expense-summary-export-excel', [AccountingReportController::class, 'incomeExpenseSummaryExportExcel'])->name('accounting.income-expense.summary-export-excel');
        Route::post('/income-expense-summary-export-pdf', [AccountingReportController::class, 'incomeExpenseSummaryExportPDF'])->name('accounting.income-expense.summary-export-pdf');
        Route::get('/income-expense-summary-export-print', [AccountingReportController::class, 'incomeExpenseSummaryExportPrint'])->name('accounting.income-expense.summary-export-print');

        Route::get('/income-expense-headwise-report', [AccountingReportController::class, 'incomeExpenseHeadwiseReport'])->name('accounting.income-expense.headwise-report');   
    });

    Route::prefix('exam-result')->group(function () {
        Route::get('/', [ExamResultReportController::class, 'index'])->name('report.exam-result.index');
        Route::get('/class-rank-report', [ExamResultReportController::class, 'classRankReport'])->name('exam-result.class-rank.report');
        Route::post('/class-rank-report-pdf', [ExamResultReportController::class, 'classRankReportPDF'])->name('exam-result.class-rank.pdf');
        Route::get('/class-rank-report-print', [ExamResultReportController::class, 'classRankReportPrint'])->name('exam-result.class-rank.print');
        Route::get('/class-gpa-report', [ExamResultReportController::class, 'classGPAReport'])->name('exam-result.class-gpa.report');
        //mark-sheet download
        Route::get('/individule-mark-sheet-download', [ExamResultReportController::class, 'individuleMarkSheetDownload'])->name('individule-mark-sheet-download');
        Route::get('/all-mark-sheet-download', [ExamResultReportController::class, 'AllMarkSheetDownload'])->name('all-mark-sheet-download');
        //result report
        Route::get('/result-report', [ResultReportController::class, 'resultReportIndex'])->name('reports.result-report');
        Route::post('/student-marks-by-class', [ResultReportController::class, 'getMarksResultByClass'])->name('reports.marks_by_class');
        //grade count by class
        Route::get('/result-grade-count-report', [ResultReportController::class, 'gradeCount'])->name('reports.grade_count');
        Route::post('/result-grade-report-by-class', [ResultReportController::class, 'countGradeByClass'])->name('reports.grade.count_by_class');
        
    });


    Route::prefix('hostel')->group(function () {
        Route::get('/', [HostelReportController::class, 'index'])->name('hostel.report.index');
        //hostel wise route
        Route::get('/hostel-wise-report', [HostelReportController::class, 'hostelReport'])->name('hostel-wise-report');
        Route::post('/hostel-wise-report-search', [HostelReportController::class, 'hostelReportSearch'])->name('hostel-wise-report-search');
        Route::post('/hostel-wise-pdf-report', [HostelReportController::class, 'hostelReportPDF'])->name('hostel-wise-pdf-report');
        Route::post('/hostel-wise-excel-report', [HostelReportController::class, 'hostelReportExcel'])->name('hostel-wise-excel-report');
        //class wise route
        Route::get('/class-wise-report', [HostelReportController::class, 'classReport'])->name('class-wise-hostel-report');
    });

    Route::prefix('transport')->group(function () {
        Route::get('/', [TransportReportController::class, 'index'])->name('transport.report.index');
        Route::get('/route-wise-student-report', [TransportReportController::class, 'routeWiseStudent'])->name('transport-route-wise-student-report');
        Route::post('/route-wise-student-report-search', [TransportReportController::class, 'routeWiseStudentSearch'])->name('transport-route-wise-student-report-search');
        Route::post('/transport-route-wise-student-pdf-export', [TransportReportController::class, 'routeWiseStudentPDF'])->name('transport-route-wise-student-pdf-export');
        Route::post('/transport-route-wise-student-excel-export', [TransportReportController::class, 'routeWiseStudentExcel'])->name('transport-route-wise-student-excel-export');
        Route::get('/class-wise-student-report', [TransportReportController::class, 'classWiseStudent'])->name('transport-class-wise-student-report');
    });

    Route::prefix('multi-branch')->group(function () {
        Route::get('/', [MultiBranchReportController::class, 'index'])->name('multi-branch.report');
        Route::get('/total-collection', [MultiBranchReportController::class, 'totalCollection'])->name('multi-branch.total-collection');
        Route::get('/income-report', [MultiBranchReportController::class, 'incomeReport'])->name('multi-branch.income-report');
        Route::get('/expense-report', [MultiBranchReportController::class, 'expenseReport'])->name('multi-branch.expense-report');
    });
});
