<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdmitCardController;
use App\Http\Controllers\Result\SeatPlanController;
use App\Http\Controllers\Result\ExamSetupController;
use App\Http\Controllers\Result\MarksEntryController;
use App\Http\Controllers\Result\MarksHeadAssignController;

Route::middleware('auth')->group(function () {
    //---------grade Route List--------------------
    Route::prefix('exam-setup')->group(function () {
        Route::get('/', [ExamSetupController::class, 'index'])->name('exam-setup.index');

        Route::post('/grade-point', [ExamSetupController::class, 'grade_store'])->name('grade.store');
        Route::post('/grade-point/update', [ExamSetupController::class, 'grade_update'])->name('grade.update');
        Route::delete('/grade/{grade}', [ExamSetupController::class, 'grade_destroy'])->name('grade.destroy');

        Route::post('/exam/store', [ExamSetupController::class, 'exam_store'])->name('exam.store');
        Route::post('/exam/update', [ExamSetupController::class, 'exam_update'])->name('exam.update');
        Route::delete('/exam/{exam}/destroy', [ExamSetupController::class, 'exam_destroy'])->name('exam.destroy');

        Route::post('/mark-head/store', [ExamSetupController::class, 'mark_head_store'])->name('markHead.store');
        Route::post('/mark-head/update', [ExamSetupController::class, 'mark_head_update'])->name('markHead.update');
        Route::delete('/mark-head/{mark}/destroy', [ExamSetupController::class, 'mark_head_destroy'])->name('markHead.destroy');

        Route::post('result-publish/store', [ExamSetupController::class, 'storePublish'])->name('publish.store');
    });

    Route::prefix('marks')->group(function () {

        Route::get('/list', [MarksEntryController::class, 'index'])->name('marks.index');
        Route::get('/create', [MarksEntryController::class, 'create'])->name('marks.create');
        Route::post('/store', [MarksEntryController::class, 'store'])->name('marks.store');
        // Route::get('/{mark}', [MarksEntryController::class, 'show'])->name('marks.show');
        Route::get('/{mark}/edit', [MarksEntryController::class, 'edit'])->name('marks.edit');
        Route::put('/{mark}', [MarksEntryController::class, 'update'])->name('marks.update');
        Route::post('/destroy', [MarksEntryController::class, 'destroy'])->name('marks.destroy');

        Route::post('/student-by-class', [MarksEntryController::class, 'getStudentsByClass'])->name('student_by_class');
        // Route::get('/student-by-class', [MarksEntryController::class, 'getStudentsByClass'])->name('student_by_class');
        Route::post('/student-marks-list', [MarksEntryController::class, 'search_student_marks_list'])->name('students_marks_list');
        Route::get('/marks-sheet', [MarksEntryController::class, 'getMarksSheetByClass'])->name('marks.sheet');
        Route::post('/student-marks-by-class', [MarksEntryController::class, 'getMarksByClass'])->name('marks_by_class');
        Route::post('/marks-sheet-download', [MarksEntryController::class, 'downloadMarksSheet'])->name('marks_sheet_download');

        Route::get('/teacher-marks-entry', [MarksEntryController::class, 'teacherMarksEntry'])->name('teacher.marks.entry');
        Route::post('/teacher-marks-entry-create', [MarksEntryController::class, 'teacherMarksEntryCreate'])->name('teacher.marks.entry.create');
        Route::post('/teacher-store', [MarksEntryController::class, 'teacherMarksStore'])->name('teacher.marks.store');
    });

    //---------------Mrak Head Assign Route List--------------------

    Route::prefix('mark-head-assign')->group(function () {
        Route::get('/list', [MarksHeadAssignController::class, 'assignList'])->name('markHeadAssign.index');
        Route::get('/create', [MarksHeadAssignController::class, 'assignCreate'])->name('markHeadAssign.create');
        Route::post('/search', [MarksHeadAssignController::class, 'assignSearch'])->name('markHeadAssign.search');
        Route::post('/search-update', [MarksHeadAssignController::class, 'assignSearchUpdate'])->name('markHeadAssign.searchUpdate');
        Route::post('/store', [MarksHeadAssignController::class, 'assignStore'])->name('markHeadAssign.store');
        Route::get('/{student_class}', [MarksHeadAssignController::class, 'show'])->name('markHeadAssign.show');
        Route::get('/{student_class}/{exam_id}/edit', [MarksHeadAssignController::class, 'assignEdit'])->name('markHeadAssign.edit');
        Route::get('/{student_class}/{exam_id}/copy', [MarksHeadAssignController::class, 'assignCopy'])->name('markHeadAssign.copy');
        Route::put('/{student_class}', [MarksHeadAssignController::class, 'assignUpdate'])->name('markHeadAssign.update');
        Route::delete('/{student_class}/{exam_id}/destroy', [MarksHeadAssignController::class, 'assignDestroy'])->name('markHeadAssign.destroy');
        //copy
        Route::get('/copy/mark-head', [MarksHeadAssignController::class, 'assignCopyCreate'])->name('markHeadAssign.copy.create');
        Route::post('/copy/store', [MarksHeadAssignController::class, 'assignCopyStore'])->name('markHeadAssign.copy.store');

    });

    Route::prefix('admit-card')->group(function () {
        Route::get('/', [AdmitCardController::class, 'index'])->name('admit-card.index');
        Route::post('/filter', [AdmitCardController::class, 'filter'])->name('admit-card.student.filter');
        Route::get('/filter-ajax', [AdmitCardController::class, 'filterAjax'])->name('admit-card.student.filter.ajax');
    });


    //---------seat-plan Route List--------------------
    Route::prefix('seat-plan')->group(function () {
        Route::get('/', [SeatPlanController::class, 'index'])->name('seat-plan.index');
        Route::post('/', [SeatPlanController::class, 'filter'])->name('seat-plan.filter');
    });

});
