<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Student\StudentInfoController;
use App\Http\Controllers\HrPayroll\OccupationController;
use App\Http\Controllers\Result\StudentPromotionController;
use App\Http\Controllers\Guardian\GuardianRelationController;

Route::middleware('auth')->group(function () {
    Route::get('list/', [StudentInfoController::class, 'index'])->name('student_info.index');
    Route::get('/create', [StudentInfoController::class, 'create'])->name('student_info.create');
    Route::post('/store', [StudentInfoController::class, 'store'])->name('student_info.store');
    Route::get('/show/{student_id}', [StudentInfoController::class, 'show'])->name('student_info.show');
    Route::get('/edit/{student_info}', [StudentInfoController::class, 'edit'])->name('student_info.edit');
    Route::put('/update/{student_info}', [StudentInfoController::class, 'update'])->name('student_info.update');
    Route::get('/delete/{student_id}', [StudentInfoController::class, 'destroy'])->name('student_info.destroy');
    Route::post('/status-update', [StudentInfoController::class, 'studentStatusUpdate'])->name('student.status.update');
    //view student all info
    Route::get('/view/{student_id}', [StudentInfoController::class, 'view'])->name('student_info.view');

    Route::post('/search', [StudentInfoController::class, 'search'])->name('student_info.search');

    //-----Auto Complete Search------
    Route::get('/search-students', [StudentInfoController::class, 'searchStudent'])->name('students.search');

    //----Import Student---------
    Route::get('/import-students-info', [StudentInfoController::class, 'showImportForm'])->name('import_student.form');
    Route::post('/import-students-info/store', [StudentInfoController::class, 'importStudentInfo'])->name('import_student.store');

    //----Export Student---------
    Route::get('/export-students-info/download', [StudentInfoController::class, 'exportStudentInfo'])->name('export_student.download');

    Route::get('id-card', [StudentInfoController::class, 'studentIDCard'])->name('student.id-card.index');
    // student card download by pdf 
    Route::get('id-card/studentIdCardDownload', [StudentInfoController::class, 'studentIdCardDownload'])->name('studentIdCardDownload');

    //---------Occupation type Route List----------
    Route::prefix('occupation')->group(function () {
        Route::get('/', [OccupationController::class, 'index'])->name('occupation.index');
        Route::get('create', [OccupationController::class, 'create'])->name('occupation.create');
        Route::post('store', [OccupationController::class, 'store'])->name('occupation.store');
        Route::get('edit/{type}', [OccupationController::class, 'edit'])->name('occupation.edit');
        Route::post('update', [OccupationController::class, 'update'])->name('occupation.update');
        Route::get('destroy/{id}', [OccupationController::class, 'destroy'])->name('occupation.destroy');
    });

    //---------Occupation type Route List---------
    Route::prefix('guardian-relation')->group(function () {
        Route::get('/', [GuardianRelationController::class, 'index'])->name('guardian_relation.index');
        Route::get('/create', [GuardianrelationController::class, 'create'])->name('guardian_relation.create');
        Route::post('/store', [GuardianrelationController::class, 'store'])->name('guardian_relation.store');
        Route::get('/edit/{type}', [GuardianrelationController::class, 'edit'])->name('guardian_relation.edit');
        Route::post('/update', [GuardianrelationController::class, 'update'])->name('guardian_relation.update');
        Route::get('/destroy/{id}', [GuardianrelationController::class, 'destroy'])->name('guardian_relation.destroy');
    });

    Route::prefix('student-promotion')->group(function () {
        Route::get('/create', [StudentPromotionController::class, 'create'])->name('student.promotion.create');
        Route::post('/store', [StudentPromotionController::class, 'storePromotion'])->name('student.promotion.store');
    });

    Route::prefix('student-graduation')->group(function () {
        Route::get('/create', [StudentPromotionController::class, 'graduation'])->name('student.graduation.create');
        Route::post('/store', [StudentPromotionController::class, 'graduationStore'])->name('student.graduation.store');
    });

    Route::get('/update-merit-positions', [StudentPromotionController::class, 'updateMeritPositions'])->name('student.promotion.update-merit-positions');

});
