<?php

use App\Http\Controllers\Student\Auth\StudentAuthController;
use App\Http\Controllers\Student\StudentDashBoardController;
use App\Http\Controllers\Student\StudentHomeworkController;
use App\Http\Controllers\Student\StudentSyllabusController;
use App\Http\Controllers\Student\StudentLibraryController;
use App\Http\Controllers\Student\StudentNoticeController;
use Illuminate\Support\Facades\Route;


Route::middleware('auth:student')->group(function () {
    Route::get('/dashboard', [StudentDashBoardController::class, 'index'])->name('student.dashboard');
    Route::get('/profile', [StudentDashBoardController::class, 'profile'])->name('student.profile');
    Route::get('/class-time-table', [StudentDashBoardController::class, 'classTimeTable'])->name('student.class-time-table');
    Route::get('/my-fees', [StudentDashBoardController::class, 'myFees'])->name('student.my-fees');
    Route::get('/my-friends', [StudentDashBoardController::class, 'myFriends'])->name('student.my-friends');
    Route::get('/my-subjects', [StudentDashBoardController::class, 'mySubjects'])->name('student.my-subjects');
    Route::get('/my-attendance', [StudentDashBoardController::class, 'myAttendance'])->name('student.my-attendance');
    Route::get('/my-mark-sheet', [StudentDashBoardController::class, 'myMarkSheet'])->name('student.my-mark-sheet');
    Route::get('/view-others-mark-sheet', [StudentDashBoardController::class, 'viewOthersMarkSheet'])->name('student.view-others-mark-sheet');
    Route::get('/my-exam-routine', [StudentDashBoardController::class, 'myExamRoutine'])->name('student.my-exam-routine');
    // Route::get('/my-notice-board', [StudentDashBoardController::class, 'myNoticeBoard'])->name('student.my-notice-board');
    Route::get('/my-payment-history', [StudentDashBoardController::class, 'myPaymentHistory'])->name('student.my-payment-history');
    Route::get('/apply-leave', [StudentDashBoardController::class, 'applyLeave'])->name('student.apply-leave');
    Route::post('/apply-leave/store', [StudentDashBoardController::class, 'storeApplyLeave'])->name('student.apply-leave.store');
    Route::get('/apply-leave/{leave}/edit', [StudentDashBoardController::class, 'editApplyLeave'])->name('student.apply-leave.edit');
    Route::put('/apply-leave/{leave}/update', [StudentDashBoardController::class, 'updateApplyLeave'])->name('student.apply-leave.update');
    Route::get('/apply-leave/{leave}/delete', [StudentDashBoardController::class, 'deleteApplyLeave'])->name('student.apply-leave.delete');
    Route::get('/leave-history', [StudentDashBoardController::class, 'leaveHistory'])->name('student.leave-history');

    Route::get('/due-fees', [StudentDashBoardController::class, 'dueFees'])->name('student.due-fees');

    //homework
    Route::get('/homework', [StudentHomeworkController::class, 'homeworkHistory'])->name('student.homework-history');
    Route::get('/homework-view/{id}', [StudentHomeworkController::class, 'view'])->name('student.homework-view');
    Route::post('/my-homework-store', [StudentHomeworkController::class, 'store'])->name('student.homework.store');
    //syllabus
    Route::get('/syllabus', [StudentSyllabusController::class, 'index'])->name('student.syllabus');
    Route::get('/syllabus-search', [StudentSyllabusController::class, 'search'])->name('student.syllabus.search');
    Route::post('/syllabus-pdf-export', [StudentSyllabusController::class, 'pdfExport'])->name('student.syllabus.pdf.export');

    //library
    Route::get('/library', [StudentLibraryController::class, 'index'])->name('student.library');
    Route::get('/library-search', [StudentLibraryController::class, 'search'])->name('student.library.search');
    Route::post('/library-search/store', [StudentLibraryController::class, 'store'])->name('student.syllabus.store');

    //notice
    Route::get('/my-notice', [StudentNoticeController::class, 'myNotice'])->name('my.notice');
    Route::get('/my-notice-show/{id}', [StudentNoticeController::class, 'myNoticeShow'])->name('my.notice.show');

    //===================Update Password================
    Route::get('/password/change', [StudentAuthController::class, 'updatePassword'])->name('student.password-change');
    Route::post('/password/change', [StudentAuthController::class, 'updatePasswordSubmit'])->name('student.password-change');

});


