<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Syllabus\LessonController;
use App\Http\Controllers\Syllabus\LessonTopicController;

Route::middleware('auth')->group(function () {
    Route::prefix('lesson')->group(function () {
        Route::get('/', [LessonController::class, 'index'])->name('lesson.index');
        Route::get('/create', [LessonController::class, 'create'])->name('lesson.create');
        Route::post('/store', [LessonController::class, 'store'])->name('lesson.store');
        Route::get('/show/{lesson}', [LessonController::class, 'show'])->name('lesson.show');
        Route::get('/edit/{lesson}', [LessonController::class, 'edit'])->name('lesson.edit');
        Route::put('/update/{lesson}', [LessonController::class, 'update'])->name('lesson.update');
        Route::delete('/delete/{lesson}', [LessonController::class, 'destroy'])->name('lesson.destroy');
        Route::get('/get-lesson-list', [LessonController::class, 'lessonList'])->name('lesson.list_by_class');
    });

    Route::get('/status', [LessonController::class, 'syllabusStatus'])->name('syllabus.status');
    Route::post('/status', [LessonController::class, 'syllabusStatusSearch'])->name('syllabus.status.search');
    
    Route::prefix('lesson-topic')->group(function () {
        Route::get('/', [LessonTopicController::class, 'index'])->name('lesson_topic.index');
        Route::get('/create', [LessonTopicController::class, 'create'])->name('lesson_topic.create');
        Route::post('/store', [LessonTopicController::class, 'store'])->name('lesson_topic.store');
        Route::get('/show/{lesson_topic}', [LessonTopicController::class, 'show'])->name('lesson_topic.show');
        Route::get('/edit/{lesson_topic}', [LessonTopicController::class, 'edit'])->name('lesson_topic.edit');
        Route::put('/update/{lesson_topic}', [LessonTopicController::class, 'update'])->name('lesson_topic.update');
        Route::delete('/delete/{lesson_topic}', [LessonTopicController::class, 'destroy'])->name('lesson_topic.destroy');
        Route::post('/topic-status-change', [LessonTopicController::class, 'statusChange'])->name('lesson_topic.status.change');
    });


});
