<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HrPayroll\TeacherController;

Route::middleware('auth')->group(function () {

    //-------------------Teacher Route List--------------------
    Route::get('/list', [TeacherController::class, 'index'])->name('teacher.index');
    Route::get('/create', [TeacherController::class, 'create'])->name('teacher.create');
    Route::post('/store', [TeacherController::class, 'store'])->name('teacher.store');
    Route::get('/show/{employee}', [TeacherController::class, 'show'])->name('teacher.show');
    Route::get('/edit/{employee}', [TeacherController::class, 'edit'])->name('teacher.edit');
    Route::put('/update/{employee}', [TeacherController::class, 'update'])->name('teacher.update');
    Route::delete('/destroy/{employee}', [TeacherController::class, 'destroy'])->name('teacher.destroy');

});
