<?php

use App\Http\Controllers\Transport\StudentTransportController;
use App\Http\Controllers\Transport\TransportRouteController;
use App\Http\Controllers\Transport\MultipleAssignTransport;
use App\Http\Controllers\Transport\StoppageController;
use App\Http\Controllers\Transport\VehicleController;
use Illuminate\Support\Facades\Route;

Route::middleware('auth')->group(function () {

    Route::prefix('vehicle')->group(function () {
        Route::get('/', [VehicleController::class, 'index'])->name('vehicle.index');
        Route::get('/create', [VehicleController::class, 'create'])->name('vehicle.create');
        Route::post('/store', [VehicleController::class, 'store'])->name('vehicle.store');
        Route::get('/{vehicle}', [VehicleController::class, 'show'])->name('vehicle.show');
        Route::get('/edit/{vehicle}', [VehicleController::class, 'edit'])->name('vehicle.edit');
        Route::put('/update/{vehicle}', [VehicleController::class, 'update'])->name('vehicle.update');
        Route::delete('/{vehicle}', [VehicleController::class, 'destroy'])->name('vehicle.destroy');
    });

    Route::prefix('transport-route')->group(function () {
        Route::get('/', [TransportRouteController::class, 'index'])->name('transport-route.index');
        Route::get('/create', [TransportRouteController::class, 'create'])->name('transport-route.create');
        Route::post('/store', [TransportRouteController::class, 'store'])->name('transport-route.store');
        Route::get('/{transport}', [TransportRouteController::class, 'show'])->name('transport-route.show');
        Route::get('/edit/{transport}', [TransportRouteController::class, 'edit'])->name('transport-route.edit');
        Route::put('/update/{transport}', [TransportRouteController::class, 'update'])->name('transport-route.update');
        Route::delete('/{transport}', [TransportRouteController::class, 'destroy'])->name('transport-route.destroy');
    });

    Route::prefix('stoppage')->group(function () {
        Route::get('/', [StoppageController::class, 'index'])->name('stoppage.index');
        Route::get('/create', [StoppageController::class, 'create'])->name('stoppage.create');
        Route::post('/store', [StoppageController::class, 'store'])->name('stoppage.store');
        // Route::get('/{stoppage}', [StoppageController::class, 'show'])->name('stoppage.show');
        Route::get('/edit/{stoppage}', [StoppageController::class, 'edit'])->name('stoppage.edit');
        Route::put('/update/{stoppage}', [StoppageController::class, 'update'])->name('stoppage.update');
        Route::delete('/{stoppage}', [StoppageController::class, 'destroy'])->name('stoppage.destroy');
        Route::get('/list-by-route', [StoppageController::class, 'listByRoute'])->name('stoppage-list-by-route');
    });

    Route::prefix('assign-stoppage')->group(function () {
        Route::get('/', [StudentTransportController::class, 'index'])->name('assign-stoppage.index');
        // Route::get('/create', [StudentTransportController::class, 'create'])->name('assign-stoppage.create');
        Route::post('/store', [StudentTransportController::class, 'assignStoppge'])->name('assign-stoppage.store');
        // Route::get('/{stoppage}', [StudentTransportController::class, 'show'])->name('assign-stoppage.show');
        // Route::get('/edit/{stoppage}', [StudentTransportController::class, 'edit'])->name('assign-stoppage.edit');
        // Route::put('/update/{stoppage}', [StudentTransportController::class, 'update'])->name('assign-stoppage.update');
        // Route::delete('/{stoppage}', [StudentTransportController::class, 'destroy'])->name('assign-stoppage.destroy');

        Route::get('/search-stoppages', [StudentTransportController::class, 'searchStopages'])->name('assign-stoppage.search');
        Route::get('/student-assigned-stopage', [StudentTransportController::class, 'studentHostelRooms'])->name('student-assigned-stopage');
    });

    Route::prefix('multiple-student-assign')->group(function () {
        Route::get('/', [MultipleAssignTransport::class, 'index'])->name('multi.assign-stoppage.index');
        Route::post('/store', [MultipleAssignTransport::class, 'multiAssignStoppge'])->name('transport-multiple-student-assign.store');
    });

});
