<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SmsController;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\NoticeController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\ApiTokenController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Academic\BranchController;
use App\Http\Controllers\Hsc\HscAdmissionController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Report\TodaysReportController;
use App\Http\Controllers\RolePermission\RoleController;
use App\Http\Controllers\TransferCertificateController;
use App\Http\Controllers\Certificate\CertificateController;
use App\Http\Controllers\Student\Auth\StudentAuthController;
use App\Http\Controllers\Admission\OnlineAdmissionController;
use App\Http\Controllers\RolePermission\PermissionController;
use App\Http\Controllers\Certificate\CertificateTemplateController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// OnlineAdmission route
Route::get('/online-admission', [OnlineAdmissionController::class, 'create'])->name('online-admission.create');
Route::post('/online-admission', [OnlineAdmissionController::class, 'store'])->name('online-admission.store');


//--------- hsc admission Route List----------
Route::prefix('hsc-admission')->group(function () {
    Route::get('/science', [HscAdmissionController::class, 'science'])->name('hsc-admission.science');
    Route::post('/store/science', [HscAdmissionController::class, 'store_science'])->name('hsc-admission.store.science');

    Route::get('/arts', [HscAdmissionController::class, 'arts'])->name('hsc-admission.arts');
    Route::post('/store/arts', [HscAdmissionController::class, 'store_arts'])->name('hsc-admission.store.arts');

    Route::get('/commerce', [HscAdmissionController::class, 'commerce'])->name('hsc-admission.commerce');
    Route::post('/store/commerce', [HscAdmissionController::class, 'store_commerce'])->name('hsc-admission.store.commerce');
});

Route::middleware('auth')->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/income-expense-compare', [DashboardController::class, 'incomeExpenseCompare'])->name('income-expense-compare');
    Route::get('/present-absent-late-compare', [DashboardController::class, 'presentAbsentLateCompare'])->name('present-absent-late-compare');
    Route::get('/class-wise-student-pie-chart', [DashboardController::class, 'classWiseStudentPieChart'])->name('class-wise-student-pie-chart');
    Route::get('/student-gender-pie-chart', [DashboardController::class, 'studentGenderPieChart'])->name('student-gender-pie-chart');
    Route::get('/last-exam-grade-pie-chart', [DashboardController::class, 'lastExamGradePieChart'])->name('last-exam-grade-pie-chart');

    Route::get('/todays-student-attendance-report', [TodaysReportController::class, 'todaysStudentAttendance'])->name('todays-student-attendance-report');
    Route::get('/todays-student-absent-report', [TodaysReportController::class, 'todaysStudentAbsent'])->name('todays-student-absent-report');
    // ajax chart
    
    Route::get('/dashboard/exam-grade-chart', [DashboardController::class, 'examGradeChart'])->name('dashboard.exam.grade.chart');

    
    /*
    |-------------------------------------------------------------------------|
    |                       RBAC Route List Start                             |
    |-------------------------------------------------------------------------|
    */

    Route::prefix('api-key')->group(function () {
        Route::get('/', [ApiTokenController::class, 'index'])->name('apikey.index');
        Route::get('/create', [ApiTokenController::class, 'create'])->name('apikey.create');
        Route::post('/store/', [ApiTokenController::class, 'store'])->name('apikey.store');
        Route::get('/edit/{id}', [ApiTokenController::class, 'edit'])->name('apikey.edit');
        Route::post('/update/', [ApiTokenController::class, 'update'])->name('apikey.update');
        Route::delete('/delete/{id}', [ApiTokenController::class, 'destroy'])->name('apikey.destroy');
    });

    Route::prefix('roles')->group(function () {
        Route::get('/', [RoleController::class, 'index'])->name('roles.index');
        Route::get('create', [RoleController::class, 'create'])->name('roles.create');
        Route::post('/', [RoleController::class, 'store'])->name('roles.store');
        Route::get('{role}', [RoleController::class, 'show'])->name('roles.show');
        Route::get('{role}/edit', [RoleController::class, 'edit'])->name('roles.edit');
        Route::put('{role}', [RoleController::class, 'update'])->name('roles.update');
        Route::get('{role}/delete', [RoleController::class, 'destroy'])->name('roles.destroy');
        Route::get('{role}/assign-permission', [RoleController::class, 'assignPermission'])->name('roles.assign-permission');
        Route::put('{role}/assign-permission', [RoleController::class, 'storeAssignPermission'])->name('roles.store-assign-permission');
        Route::get('{user}/assign-role', [RoleController::class, 'assignRole'])->name('roles.assign-role');
        Route::post('assign-role-store', [RoleController::class, 'assignRoleStore'])->name('roles.assign-role-store');
    });


    Route::prefix('permissions')->group(function () {
        Route::get('/', [PermissionController::class, 'index'])->name('permissions.index');
        Route::get('/create', [PermissionController::class, 'create'])->name('permissions.create');
        Route::post('/', [PermissionController::class, 'store'])->name('permissions.store');
        Route::get('/{permission}', [PermissionController::class, 'show'])->name('permissions.show');
        Route::get('/{permission}/edit', [PermissionController::class, 'edit'])->name('permissions.edit');
        Route::put('/{permission}', [PermissionController::class, 'update'])->name('permissions.update');

        Route::get('{permission}/delete', [PermissionController::class, 'destroy'])->name('permissions.destroy');

        Route::get('users/list', [PermissionController::class, 'userList'])->name('permissions.users.list');
    });

    /*
    |-------------------------------------------------------------------------|
    |                       RBAC Route List End                               |
    |-------------------------------------------------------------------------|
    */


    
    //===================== SMS Related Route List ===========================
    Route::prefix('sms')->group(function () {
        Route::get('general-sms/list', [SmsController::class, 'generalSmsList'])->name('general-sms.list');
        Route::get('general-sms/create', [SmsController::class, 'generalSmsCreate'])->name('general-sms.create');
        Route::post('general-sms/send', [SmsController::class, 'generalSmsSend'])->name('general-sms.send');

        Route::get('student-sms/list', [SmsController::class, 'studentSmsList'])->name('student-sms.list');
        Route::get('student-sms/create', [SmsController::class, 'studentSmsCreate'])->name('student-sms.create');
        Route::post('student-sms/search-student', [SmsController::class, 'searchStudentInfo'])->name('student-sms.search-student');
        Route::post('student-sms/send', [SmsController::class, 'studentSmsSend'])->name('student-sms.send');

        Route::get('employee-sms/list', [SmsController::class, 'employeeSmsList'])->name('employee-sms.list');
        Route::get('employee-sms/create', [SmsController::class, 'employeeSmsCreate'])->name('employee-sms.create');
        Route::post('employee-sms/search-employee', [SmsController::class, 'searchEmployeeInfo'])->name('employee-sms.search-employee');
        Route::post('employee-sms/send', [SmsController::class, 'employeeSmsSend'])->name('employee-sms.send');

        Route::get('reports', [SmsController::class, 'smsReports'])->name('sms-reports');
        Route::post('reports/search-sms', [SmsController::class, 'searchSmsData'])->name('sms-reports.search-sms');

        // date-wise sms report
        Route::get('date-wise-reports', [SmsController::class, 'dateWiseSmsReports'])->name('date-wise-sms-reports');
        Route::post('date-wise-reports/search-sms', [SmsController::class, 'dateWiseSmsReportsSearch'])->name('date-wise-sms-reports.search-sms');

        //branch and class wise sms
        Route::get('student-class-sms', [SmsController::class, 'DepartmentWiseSms'])->name('student-sms.department-wise-sms');
        Route::POST('student-class-sms-search', [SmsController::class, 'DepartmentWiseStudent'])->name('student-sms.department-wise-student');
        Route::POST('student-class-sms-send', [SmsController::class, 'DepartmentWiseStudentSend'])->name('student-sms-department.send');
    });

    //===================== tc Related Route List ===========================
    Route::prefix('tc')->name('tc.')->group(function () {
        Route::get('/', [TransferCertificateController::class, 'index'])->name('index');
        Route::post('/store', [TransferCertificateController::class, 'store'])->name('store');
        Route::post('/update', [TransferCertificateController::class, 'update'])->name('update');
        Route::get('/show/{id}', [TransferCertificateController::class, 'show'])->name('show');
        Route::delete('/destroy/{id}', [TransferCertificateController::class, 'destroy'])->name('destroy');

        Route::get('/print/{id}', [TransferCertificateController::class, 'print'])->name('print');
    });

    //===================== Settings Related Route List ===========================
    Route::prefix('settings')->group(function () {
        Route::get('/', [SettingController::class, 'index'])->name('setting.index');
        Route::post('update', [SettingController::class, 'settingUpdate'])->name('setting.update');
        Route::get('accounting', [SettingController::class, 'accounting'])->name('setting.accounting');
    });

    //=================Certificate Route=====================
    Route::prefix('certificates')->group(function () {

        Route::prefix('template')->group(function () {
            Route::get('/', [CertificateTemplateController::class, 'index'])->name('certificate-templates.index');
            Route::get('/create', [CertificateTemplateController::class, 'create'])->name('certificate-templates.create');
            Route::post('/store', [CertificateTemplateController::class, 'store'])->name('certificate-templates.store');
            Route::get('/{certificateTemplate}/edit', [CertificateTemplateController::class, 'edit'])->name('certificate-templates.edit');
            Route::get('/{certificateTemplate}/show', [CertificateTemplateController::class, 'show'])->name('certificate-templates.show');
            Route::put('/{certificateTemplate}/update', [CertificateTemplateController::class, 'update'])->name('certificate-templates.update');
            Route::delete('/{certificateTemplate}/delete', [CertificateTemplateController::class, 'destroy'])->name('certificate-templates.destroy');
        });
        
        Route::prefix('student')->group(function () {
            Route::get('/', [CertificateController::class, 'index'])->name('student-certificate.index');
            Route::get('/create', [CertificateController::class, 'create'])->name('student-certificate.create');
            Route::post('/store', [CertificateController::class, 'store'])->name('student-certificate.store');
            Route::get('/{id}/edit', [CertificateTemplateController::class, 'edit'])->name('student-certificate.edit');
            Route::get('/{certificate}/show', [CertificateController::class, 'show'])->name('student-certificate.show');
            Route::post('/{id}/update', [CertificateController::class, 'update'])->name('student-certificate.update');
            Route::delete('/{id}/delete', [CertificateController::class, 'destroy'])->name('student-certificate.destroy');
        });
        
    });

    //=================Notice Route=====================
    Route::prefix('notice')->group(function () {
        Route::get('/', [NoticeController::class, 'index'])->name('notice.index');
        Route::get('/create', [NoticeController::class, 'create'])->name('notice.create');
        Route::post('/store', [NoticeController::class, 'store'])->name('notice.store');
        Route::get('/{id}/edit', [NoticeController::class, 'edit'])->name('notice.edit');
        Route::get('/{id}/show', [NoticeController::class, 'show'])->name('notice.show');
        Route::post('/{id}/update', [NoticeController::class, 'update'])->name('notice.update');
        Route::delete('/{id}/delete', [NoticeController::class, 'destroy'])->name('notice.destroy');

    });

    Route::get('user/profile', [ProfileController::class, 'index'])->name('profile.index');

    Route::post('branch-switch', [BranchController::class, 'branchSwitch'])->name('branch-switch');

    //===================Update Password================
    Route::get('/password/update', [ForgotPasswordController::class, 'updatePassword'])->name('password-update');
    Route::post('/password/update', [ForgotPasswordController::class, 'updatePasswordSubmit'])->name('password.update');


    //===================Clear Cache================
    Route::get('/clear-cache', function() {
        if (app()->environment('local')) {
            Artisan::call('cache:clear');
            Artisan::call('config:clear');
            Artisan::call('config:cache');
            Artisan::call('route:clear');
            Artisan::call('view:clear');
            return "All caches cleared";
        } else {
            return "Unauthorized access";
        }
    })->name('clear.cache');
});

Route::middleware('guest:student')->group(function () {
    Route::get('student/login', [StudentAuthController::class, 'showLoginForm'])->name('student.login');
    Route::post('student/login', [StudentAuthController::class, 'login']);

    //===================Forgot Password================
    Route::get('student/forgot-password', [StudentAuthController::class, 'showForgotPasswordForm'])->name('student.forgot-password');
    Route::post('student/forgot-password', [StudentAuthController::class, 'forgotPassword'])->name('student.forgot-password.post');
    Route::get('student/forgot-password/verify', [StudentAuthController::class, 'showVerifyOtpForm'])->name('student.forgot-password.verify');
    Route::post('student/forgot-password/verify', [StudentAuthController::class, 'verifyOtp'])->name('student.forgot-password.verify.post');
    Route::get('student/forgot-password/reset', [StudentAuthController::class, 'showResetPasswordForm'])->name('student.forgot-password.reset');
    Route::post('student/forgot-password/reset', [StudentAuthController::class, 'resetPassword'])->name('student.forgot-password.reset.post');

});

Route::middleware('auth:student')->group(function () {
    Route::post('student/logout', [StudentAuthController::class, 'logout'])->name('student.logout');
});

//===================Forgot Password================
Route::prefix('forgot-password')->group(function () {
    Route::get('/', [ForgotPasswordController::class, 'showForgotPasswordForm'])->name('forgot-password');
    Route::post('/request', [ForgotPasswordController::class, 'requestOtp'])->name('forgot-password.request');
    Route::get('/verify', [ForgotPasswordController::class, 'showVerifyOtpForm'])->name('forgot-password.verify');
    Route::post('/verify', [ForgotPasswordController::class, 'verifyOtp'])->name('forgot-password.verify.post');
    Route::get('/reset', [ForgotPasswordController::class, 'showResetPasswordForm'])->name('forgot-password.reset');
    Route::post('/reset', [ForgotPasswordController::class, 'resetPassword'])->name('forgot-password.reset.post');
});

//================= Location Dropdown Routes =================
Route::prefix('locations')->group(function () {
    Route::get('/divisions', [LocationController::class, 'getDivisions'])->name('locations.divisions');
    Route::get('/districts', [LocationController::class, 'getDistricts'])->name('locations.districts');
    Route::get('/upazilas', [LocationController::class, 'getUpazilas'])->name('locations.upazilas');
    Route::get('/unions', [LocationController::class, 'getUnions'])->name('locations.unions');
});
