<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12 col-xxl-12 m-auto">
            <div class="card mt-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 table__top__txt">Applicant List</h6>
                    <div class="m-0 float-right">
                        
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table data-table">
                                <thead class="thead-light">
                                <tr>
                                    <th><input type="checkbox" id="select-all"></th>
                                    <th>Form ID</th>
                                    <th>Name</th>
                                    <th>Class</th>
                                    <th>Shift</th>
                                    <th>Mobile No</th>
                                    <th class="action__col">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>

                        <form id="bulkActionForm" method="POST" action="<?php echo e(route('online-admission.applicant-to-selected')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="ids" id="selected-ids">
                            <div class="row">
                                <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                                    <button type="submit" class="btn btn-submit">Submit To Selected List</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">
   $(function () {
        var table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(route('online-admission.index')); ?>",
            columns: [
                {
                    data: 'id',
                    name: 'checkbox',
                    orderable: false,
                    searchable: false,
                    render: function (data, type, row) {
                        let isChecked = row.selected == 1 ? 'checked' : '';
                        let isDisabled = row.selected == 1 ? 'disabled' : '';   
                        return '<input type="checkbox" class="row-checkbox" value="' + data + '" ' + isChecked + ' ' + isDisabled + '>';
                    }
                },
                {data: 'form_id', name: 'form_id'},
                {data: 'name', name: 'name'}, // ✅ works now
                {data: 'class_name', name: 'class_name'},
                {data: 'shift_name', name: 'shift_name'},
                {data: 'mobile_no', name: 'mobile_no'},
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        let viewButton = '<a href="<?php echo e(route("online-admission.show", ":id")); ?>'
                            .replace(":id", row.id)
                            + '" class="btn btn-sm btn-soft-info mr-1" title="View" target="_blank"><i class="fas fa-eye"></i></a>';
                        return '<div class="d-flex justify-content-center">' + viewButton + '</div>';
                    }
                }
            ]
        });
    });


    $('#select-all').on('click', function() {
        var rows = $('.data-table').DataTable().rows({ 'search': 'applied' }).nodes();
        // Only affect checkboxes that are NOT disabled
        $('input.row-checkbox:not(:disabled)', rows).prop('checked', this.checked);
    });

    $('#bulkActionForm').on('submit', function(e) {
        e.preventDefault();

        var selected = [];
        $('.row-checkbox:checked:not(:disabled)').each(function() {
            selected.push($(this).val());
        });

        if (selected.length === 0) {
            alert('No rows selected!');
            return;
        }

        $('#selected-ids').val(selected.join(','));

        this.submit();
    });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/admission/online-admission/index.blade.php ENDPATH**/ ?>