<?php $__env->startSection('content'); ?>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400..700&family=Open+Sans:ital,wght@0,300..800;1,300..800&family=PT+Sans:ital,wght@0,400;0,700;1,400;1,700&family=Poppins:ital,wght@0,200;0,300;1,200;1,300;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');

        .list-unstyled li .lesson-name{
        padding-left: 7px;
    }
    .list-unstyled li ul {
        padding-left: 21px;
        list-style: none;
    }

        body {
            font-family: "Roboto", sans-serif;
            font-style: normal;
        }
        a {
            text-decoration: none;
        }
        .container {
            max-width: 860px;
            padding: 20px 10px;
            margin: auto;
            width: 100%;
        }
        .first-row {
            padding: 20px 10px;
            background-color: transparent;
            border: 3px double #ccc;
        }
        table, th, td {
            border: 1px solid black;
            border-collapse: collapse;
        }

        .first-table-wrapper {
            display: flex;
            gap: 20px;
            justify-content: center;
            margin-top: 15px;
            flex-wrap: nowrap;
        }

        .left-side {
            width: 30% !important;
            text-align: center;
        }

        .left-side h2 {
            font-size: 22px;
            width: 266px;
        }

        .left-side a {
            background-color: #000;
            padding: 8px 10px;
            color: #fff;
            display: inline-block;
            border-radius: 4px;
            cursor: pointer;
        }

        .result-table {
            border: 2px solid #565656;
            margin-top: 20px;
        }

        .second-and-third-wrapper {
            height: 560px;
        }

        .second-table-wrapper {
            margin-top: 25px;
        }

        .third-table-wrapper {
            display: flex;
            gap: 20px;
            margin-top: 25px;
        }

        .last-table-wrapper {
            margin-top: 25px;
        }

        .sig {
            font-family: "Dancing Script", cursive;
            font-weight: 600;
            text-align: center;
        }

        table tr td {
            padding-left: 5px;
        }

        .col-height {
            height: 34px;
        }

        .bg-gray {
            background-color: #e9e9e9;
        }

        /*//water-mark*/
        .container .first-row {
            position: relative;
        }

        .container .first-row .ms__icon {
            /* background-image: url(<?php echo e(asset('/default/icon-marksheet1.png')); ?>); */
            position: absolute;
            background-repeat: no-repeat;
            background-position: center;
            background-size: contain;
            width: 349px;
            height: 349px;
            opacity: .15;
            left: 37%;
            top: 48%;
        }

        .middle-side {
            width: 30% !important;
        }

        .right-side {
            width: 40% !important;
        }

        .work-information {
            width: 40% !important;
        }

        .conduct-info {
            width: 60% !important;
        }

        /* Mobile styles */
        @media screen and (max-width: 768px) {
            .first-table-wrapper {
                flex-wrap: wrap;
            }

            .first-table-wrapper > div,
            .left-side,
            .middle-side,
            .right-side,
            .work-information,
            .conduct-info {
                width: 100% !important;
                margin-bottom: 20px;
            }
            
            .second-and-third-wrapper {
                height: auto;
            }
            
            .third-table-wrapper {
                flex-direction: column;
            }
            
            .third-table-wrapper > div {
                width: 100% !important;
            }
            
            .result-table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }
            
            table {
                font-size: 14px;
            }
            
            .container .first-row .ms__icon {
                width: 200px;
                height: 200px;
                left: 50%;
                top: 50%;
                transform: translate(-50%, -50%);
            }
            
            .left-side h2 {
                width: 100%;
                font-size: 18px;
            }
        }

        @media print {
            .btn-primary {
                display: none;
            }

            .card {
                border: none !important;
            }

            .container-fluid {
                padding: 0 !important;
            }

            .result-table {
                page-break-inside: avoid;
            }
            
            .third-table-wrapper {
                page-break-inside: avoid;
            }
        }
     
    </style>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12 col-md-12 col-lg-10 m-auto">
                    <div class="card-body card__head">
                        <form method="GET" action="<?php echo e(route('student.syllabus.search')); ?>">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="form-group col-lg-4 col-md-12 col-sm-12">
                                        <select name="exam_id" class="form-control select2 exam_id" id="exam_id" required>
                                            <option value="">Exam</option>
                                            <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $examItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($examItem->id); ?>" <?php if($exam_id == $examItem->id || (!$exam_id && $loop->first)): echo 'selected'; endif; ?> >
                                                    <?php echo e($examItem->exam_name . ' ' . $examItem->academic_year->year); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-4 col-md-12 col-sm-12">
                                        <?php if(!empty($subjects)): ?>
                                        <select class="form-control form-control-sm subject_id" id="subject_id" name="subject_id">
                                            <option value="">All Subject</option>
                                            <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($subject->subject->id ?? 'N/A'); ?>" <?php if($subject->subject->id == $subject_id): ?> selected <?php endif; ?>><?php echo e($subject->subject->subject_name ?? 'N/A'); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                                        <button type="submit" class="btn btn-sm btn-info">Search</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
            </div>

            <?php if(!empty($lessons)): ?>
    <div class="col-12 col-md-12 col-lg-10 m-auto">
    <div class="card data__table">
        <div class="card-body table-border-style">
            <!-- Desktop View (Table) -->
            <div class="d-none d-md-block">
                <div class="table-responsive py-2">
                    <table class="table">
                        <thead>
                            <?php if(!empty($exam_name)): ?>
                            <tr class="hide" id="visible" >
                                <td colspan="5" class="text-left" style="color: white;"><?php if(!empty($exam_name)): ?> <strong class="font-weight-bold">Exam:</strong> <?php endif; ?> <?php echo e($exam_name ?? ''); ?>  <?php if(!empty($class_name)): ?> <strong class="font-weight-bold">Class:</strong> <?php echo e($class_name ?? ''); ?> <?php endif; ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <th>
                                    <div class="row">
                                        <div class="col-md-6 col-xs-7"> Lesson Topic</div>
                                        <div class="col-md-6 col-xs-5 pl-4">Status</div>
                                    </div>    
                               </th>
                            </tr>
                        </thead>
                        <tbody class="day-schedule">
                            <?php if(!empty($lessons)): ?>
                            <?php
                                $displayedSubjects = [];
                            ?>
                            <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lessonKey=>$lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if(!in_array($lesson->subject->id, $displayedSubjects)): ?>
                                        <?php
                                            $displayedSubjects[] = $lesson->subject->id;
                                        ?>
                                        <h5><?php echo e($lesson->subject->subject_name); ?></h5>
                                    <?php endif; ?>
                                    <ul class="list-unstyled">
                                        <li><h6><?php echo e($lessonKey+1); ?> <span class="lesson-name"><?php echo e($lesson->name); ?></span></h6>
                                        <ul>
                                            <?php if($lesson->lessonTopics->isNotEmpty()): ?>
                                            <?php $__currentLoopData = $lesson->lessonTopics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topicKey=>$topic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <div class="row">
                                                    <div class="col-md-6 col-xs-7"><span class="pr15"><?php echo e($lessonKey+1); ?>.<?php echo e($topicKey+1); ?></span> <?php echo e($topic->name); ?></div>
                                                   
                                                    <div class="col-md-6 col-xs-5">
                                                        <?php if($topic->status): ?>
                                                        <span class="text-black">Completed(<?php echo e($topic->completed_date); ?>)</span>
                                                        <?php else: ?>
                                                        <span class="text-secondary">Incomplete</span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <em>No topics available</em>
                                            <?php endif; ?>
                                        </ul>
                                        </li>
                                    </ul>
                                </td>        
                            </tr>
                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         <?php else: ?>
                         <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                        <?php endif; ?>

                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Mobile View (Cards) -->
            <div class="d-md-none">
                <div class="table-responsive py-2">
                    <table class="table">
                        <thead>
                            <?php if(!empty($exam_name)): ?>
                            <tr class="hide" id="visible">
                                <td colspan="5" class="text-left"><?php if(!empty($exam_name)): ?> <strong class="font-weight-bold">Exam:</strong> <?php endif; ?> <?php echo e($exam_name ?? ''); ?>  <?php if(!empty($class_name)): ?> <strong class="font-weight-bold">Class:</strong> <?php echo e($class_name ?? ''); ?> <?php endif; ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <th>
                                    <div class="row">
                                        <div class="col-md-6 col-xs-7"> Lesson Topic</div>
                                        <div class="col-md-6 col-xs-5 pl-4">Status</div>
                                    </div>    
                               </th>
                            </tr>
                        </thead>
                        <tbody class="day-schedule">
                            <?php if(!empty($lessons)): ?>
                            <?php
                                $displayedSubjects = [];
                            ?>
                            <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lessonKey=>$lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if(!in_array($lesson->subject->id, $displayedSubjects)): ?>
                                        <?php
                                            $displayedSubjects[] = $lesson->subject->id;
                                        ?>
                                        <h5><?php echo e($lesson->subject->subject_name); ?></h5>
                                    <?php endif; ?>
                                    <ul class="list-unstyled">
                                        <li><h6><?php echo e($lessonKey+1); ?> <span class="lesson-name"><?php echo e($lesson->name); ?></span></h6>
                                        <ul>
                                            <?php if($lesson->lessonTopics->isNotEmpty()): ?>
                                            <?php $__currentLoopData = $lesson->lessonTopics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topicKey=>$topic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <div class="row">
                                                    <div class="col-md-6 col-xs-7"><span class="pr15"><?php echo e($lessonKey+1); ?>.<?php echo e($topicKey+1); ?></span> <?php echo e($topic->name); ?></div>
                                                   
                                                    <div class="col-md-6 col-xs-5">
                                                        <?php if($topic->status): ?>
                                                        <span class="text-black">Completed(<?php echo e($topic->completed_date); ?>)</span>
                                                        <?php else: ?>
                                                        <span class="text-secondary">Incomplete</span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <em>No topics available</em>
                                            <?php endif; ?>
                                        </ul>
                                        </li>
                                    </ul>
                                </td>        
                            </tr>
                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         <?php else: ?>
                         <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                        <?php endif; ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    </div>
<?php endif; ?>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('students-dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/students-dashboard/pages/my-syllabus.blade.php ENDPATH**/ ?>