<div class="chart__dash">
    <form id="income-expense-filter-form">
        <div class="row">
            <div class="col-md-2  col-6">
                <input type="text" id="income-expense-daterange" class="form-control form-control-sm">
            </div>
            <div class="col-md-2  col-6">
                <button class="btn-sm btn-light-blue" type="submit">Filter</button>
            </div>
        </div>
    </form>
    <div class="chart__body" id="income-expense-compare"></div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(function () {
        let start = moment().subtract(30, 'days');
        let end = moment();

        // income-expense Initialize daterangepicker
        $('#income-expense-daterange').daterangepicker({
            startDate: start,
            endDate: end,
            locale: {
                format: 'YYYY-MM-DD'  // ✅ Laravel-compatible format
            },
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        }, function (start, end) {
            // Set visible value in input field
            $('#income-expense-daterange').val(start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD'));
        });

        // Set default value manually on page load
        $('#income-expense-daterange').val(start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD'));

        // Load chart on first page load
        loadChart(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));

        // Form submit handler
        $('#income-expense-filter-form').on('submit', function (e) {
            e.preventDefault();
            const range = $('#income-expense-daterange').val();

            if (!range.includes(' - ')) {
                alert("Invalid date range format.");
                return;
            }

            const [start, end] = range.split(' - ');
            console.log('Loading chart for:', start, end);

            loadChart(start.trim(), end.trim());
        });

        // Load chart with AJAX
        function loadChart(start, end) {
            $.ajax({
                url: '<?php echo e(route("income-expense-compare")); ?>',
                data: {
                    start_date: start,
                    end_date: end
                },
                success: function (res) {
                    Highcharts.chart('income-expense-compare', {
                        chart: {
                            type: 'line' // 👉 or 'line'
                        },
                        credits: {
                            enabled: false
                        },
                        title: {
                            text: 'Income vs Expense'
                        },
                        xAxis: {
                            categories: res.categories,
                            crosshair: true
                        },
                        yAxis: {
                            min: 0,
                            title: {
                                text: 'Amount (৳)'
                            }
                        },
                        tooltip: {
                            shared: true,
                            crosshairs: true
                        },
                        plotOptions: {
                            column: {
                                grouping: true,
                                shadow: false,
                                borderWidth: 0
                            }
                        },
                        series: res.series,
                        colors: ['#00e272', '#2caffe']
                    });
                },
                error: function (xhr) {
                    alert("Error loading chart: " + xhr.responseJSON?.error || xhr.statusText);
                }
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/html/EdueasyCollege/resources/views/components/income-expense-chart.blade.php ENDPATH**/ ?>