<?php $__env->startSection('content'); ?>
<div class="tab__item">
        <div class="row">
            <div class="col-xl-12 col-xxl-8 m-auto">
                <div class="card mt-4">
                    <div class="card-body">
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#grade-point-tab" role="tab">Grade Point</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#exam-tab" role="tab">Exam List</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#mark-head-tab" role="tab">Mark Head</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#result-publish-tab" role="tab">Result Publish</a>
                        </li>
                    </ul>


                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div id="grade-point-tab"
                             class="tab-pane fade <?php echo e(request()->query('tab', 'grade-point') === 'grade-point' ? 'show active' : ''); ?>">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Grade Point</h6>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-result.grade.create')): ?>
                                <button class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#gradePointStoreModal">Add
                                    New</button>
                                <?php endif; ?>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip">
                                    <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Mark</th>
                                        <th>GPA</th>
                                        <th>Remarks</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $geadeKey => $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(++$geadeKey); ?></td>
                                            <td><?php echo e($grade->name); ?></td>
                                            <td><?php echo e($grade->mark_from); ?>-<?php echo e($grade->mark_to); ?></td>
                                            <td><?php echo e($grade->gpa); ?></td>
                                            <td><?php echo e($grade->remark); ?></td>
                                            <td class="d-flex justify-content-start">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-result.grade.edit')): ?>
                                                    <button class="btn btn-sm btn-soft-info mr-1" data-toggle="modal"
                                                        data-target="#gradePointEditModal" data-name="<?php echo e($grade->name); ?>"
                                                        data-mark-from="<?php echo e($grade->mark_from); ?>" data-mark-to="<?php echo e($grade->mark_to); ?>"
                                                        data-gpa="<?php echo e($grade->gpa); ?>" data-remark="<?php echo e($grade->remark); ?>"
                                                        data-id="<?php echo e($grade->id); ?>"><i class="fas fa-edit"></i>
                                                    </button>
                                                <?php endif; ?>

                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-result.grade.delete')): ?>
                                                    <form action="<?php echo e(route('grade.destroy', $grade->id)); ?>" method="POST"
                                                        style="display: inline;"
                                                        onsubmit="return confirm('Are you sure you want to delete this')">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                                    </form>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div id="exam-tab" class="tab-pane fade <?php echo e(request()->query('tab') === 'exam' ? 'show active' : ''); ?>">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Exam</h6>
                                <div class="m-0 float-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-result.exam-list.create')): ?>
                                    <button class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#dataStoreModal">Add New</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip">
                                    <thead class="thead-light">
                                    <tr>
                                        <th scope="col">ID</th>
                                        <th scope="col">Exam Name</th>
                                        <th class="text-center" scope="col">Year</th>
                                        <th scope="col">Start Date</th>
                                        <th scope="col">End Date</th>
                                        <th class="text-center" scope="col">Current Exam</th>
                                        <th class="action__col" scope="col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(++$key); ?></td>
                                            <td><?php echo e($exam->exam_name); ?></td>
                                            <td class="text-center"><?php echo e($exam->academic_year->year); ?></td>
                                            <td><?php echo e(view_date_format($exam->exam_start_date)); ?></td>
                                            <td><?php echo e(view_date_format($exam->exam_end_date)); ?></td>
                                            <td class="text-center"><?php echo e($exam->is_published ? 'Yes' : 'No'); ?></td>
                                            <td class="d-flex justify-content-start">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-result.exam-list.edit')): ?>
                                                    <button class="btn btn-sm btn-soft-info mr-1" data-toggle="modal"
                                                        data-target="#dataEditModal" data-edit-name="<?php echo e($exam->exam_name); ?>"
                                                        data-year="<?php echo e($exam->academic_year->id); ?>"
                                                        data-start-date="<?php echo e(view_date_format($exam->exam_start_date)); ?>"
                                                        data-end-date="<?php echo e(view_date_format($exam->exam_end_date)); ?>"
                                                        data-is-published="<?php echo e($exam->is_published ?? 0); ?>"
                                                        data-id="<?php echo e($exam->id); ?>"><i class="fas fa-edit"></i></button>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-result.exam-list.delete')): ?>
                                                    <form action="<?php echo e(route('exam.destroy', $exam->id)); ?>" method="POST"
                                                        class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-soft-danger btn-sm"
                                                            onclick="return confirm('Are you sure you want to delete this exam?')"><i class="fas fa-trash"></i></button>
                                                    </form>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div id="mark-head-tab"
                             class="tab-pane fade <?php echo e(request()->query('tab') === 'mark-head' ? 'show active' : ''); ?>">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Mark Head</h6>
                                <div class="m-0 float-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.groups.create')): ?>
                                        <button class="btn btn-sm btn-light-blue" id="add-student-btn"
                                                data-toggle="modal" data-target="#markHeadStoreModal">Add
                                            New
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip">
                                    <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Head Name</th>
                                        <th>Short Name</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $marks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $mark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(++$key); ?></td>
                                            <td><?php echo e($mark->head_name); ?></td>
                                            <td><?php echo e($mark->short_name); ?></td>
                                            <td>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-result.mark-head.edit')): ?>
                                                    <button class="btn btn-sm btn-soft-info mr-2" id="add-student-btn"
                                                            data-toggle="modal" data-target="#markHeadEditModal"
                                                            data-head-name="<?php echo e($mark->head_name); ?>"
                                                            data-short-name="<?php echo e($mark->short_name); ?>"
                                                            data-full-mark="<?php echo e($mark->full_mark); ?>"
                                                            data-pass-mark="<?php echo e($mark->pass_mark); ?>"
                                                            data-status="<?php echo e($mark->is_separate_pass); ?>"
                                                            data-id="<?php echo e($mark->id); ?>"><i class="fas fa-edit"></i></button>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-result.mark-head.delete')): ?>
                                                    <form action="<?php echo e(route('markHead.destroy', $mark->id)); ?>" method="POST"
                                                        style="display: inline;"
                                                        onsubmit="return confirm('Are you sure you want to delete this')">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-soft-danger"><i
                                                                class="fas fa-trash"></i></button>
                                                    </form>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div id="result-publish-tab"
                             class="tab-pane fade <?php echo e(request()->query('tab') === 'result-publish' ? 'show active' : ''); ?>">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Result Publish</h6>
                                <div class="m-0 float-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-result.publish-result.create')): ?>
                                    <button class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#resultPublishStoreModal">Published Result</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>ID</th>
                                            <th>Exam name</th>
                                            <th>Is Published</th>
                                            <th>Published Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $published_exam; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e(++$key); ?></td>
                                                <td><?php echo e($exam->exam->exam_name .' '. $exam->academic_year->year); ?></td>
                                                <td><?php echo e($exam->is_published == 1 ? 'yes' : 'no'); ?></td>
                                                <td><?php echo e(view_date_format($exam->publish_date)); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                </div>
            </div>
        </div>
    </div>

    <!--  Modal grade point -->
    <div class="modal fade" id="gradePointStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('grade.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Grade Point </h4>
                        </div>
                        
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="name">Letter grade<span class="text-danger"> *</span></label>
                            <?php
                                $letterGrades = ['A+', 'A', 'A-', 'B', 'C', 'D', 'F'];
                            ?>
                            <select id="grade" name="name" class="form-control" required>
                                <option value="">Select Letter Grade</option>
                                <?php $__currentLoopData = $letterGrades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($grade); ?>"><?php echo e($grade); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="mark_from">Mark From (%)<span class="text-danger"> *</span></label>
                            <input id="mark_from" type="number" class="form-control " name="mark_from"
                                value="<?php echo e(old('mark_from')); ?>" placeholder="Enter mark from" autofocus required>
                        </div>
                        <div class="form-group">
                            <label for="mark_to">Mark To (%)<span class="text-danger"> *</span></label>
                            <input id="mark_to" type="number" class="form-control " name="mark_to"
                                value="<?php echo e(old('mark_to')); ?>" placeholder="Enter mark to" autofocus required>
                        </div>

                        

                        <div class="form-group">
                            <label for="gpa">Grade point<span class="text-danger"> *</span></label>
                            <input id="gpa" type="number" step="0.01" class="form-control" name="gpa"
                                value="<?php echo e(old('gpa')); ?>" autofocus required placeholder="Enter Grade Point. Ex: 5.00">
                        </div>

                        <div class="form-group">
                            <label for="remark">Remarks</label>
                            <input id="remark" type="text" class="form-control" name="remark"
                                value="<?php echo e(old('remark')); ?>" placeholder="Write remarks" autofocus>
                        </div>

                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="gradePointEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('grade.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Grade Point </h4>
                        </div>
                        
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="name">Letter grade<span class="text-danger"> *</span></label>
                            <?php
                                $letterGrades = ['A+', 'A', 'A-', 'B', 'C', 'D', 'F'];
                            ?>
                            <select id="grade" name="name" class="form-control" required>
                                <option value="">Select Letter Grade</option>
                                <?php $__currentLoopData = $letterGrades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($grade); ?>"><?php echo e($grade); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="mark_from">Mark From (%)<span class="text-danger"> *</span></label>
                            <input id="mark_from" type="number" class="form-control " name="mark_from"
                                value="<?php echo e(old('mark_from')); ?>" placeholder="Enter mark from" autofocus required>
                        </div>
                        <div class="form-group">
                            <label for="mark_to">Mark To (%)<span class="text-danger"> *</span></label>
                            <input id="mark_to" type="number" class="form-control " name="mark_to"
                                value="<?php echo e(old('mark_to')); ?>" placeholder="Enter mark to" autofocus required>
                        </div>

                        

                        <div class="form-group">
                            <label for="gpa">Grade point<span class="text-danger"> *</span></label>
                            <input id="gpa" type="number" step="0.01" class="form-control" name="gpa"
                                value="<?php echo e(old('gpa')); ?>" autofocus required placeholder="Enter Grade Point. Ex: 5.00">
                        </div>

                        <div class="form-group">
                            <label for="remark">Remarks</label>
                            <input id="remark" type="text" class="form-control" name="remark"
                                value="<?php echo e(old('remark')); ?>" placeholder="Write remarks" autofocus>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->


    <!-- create Modal -->
    <div class="modal fade" id="dataStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('exam.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Exam</h4>
                        </div>
                        
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="exam_name">Exam Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="exam_name" name="exam_name"
                                value="<?php echo e(old('exam_name')); ?>" placeholder="Enter Exam Name" required>
                        </div>
                        <!-- First Row: Year and Current Exam -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="year">Year <span class="text-danger">*</span></label>
                                    <?php echo e(generateDropdown($academicYears, 'name="year" class="form-control year" id="year"', $academic_year, 'Select Year')); ?>

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="is_published">Current Exam</label>
                                    <select class="form-control" id="is_published" name="is_published">
                                        <option value="1">Yes</option>
                                        <option value="0">No</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <!-- Second Row: Start Date and End Date -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exam_start_date">Exam Start Date</label>
                                    <input type="text" class="form-control date3601" id="exam_start_date" name="exam_start_date"
                                        value="<?php echo e(old('exam_start_date')); ?>" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exam_end_date">Exam End Date</label>
                                    <input type="text" class="form-control date3602" id="exam_end_date" name="exam_end_date"
                                        value="<?php echo e(old('exam_end_date')); ?>" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->
    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm2' method="POST" action="<?php echo e(route('exam.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel2">Edit Exam </h4>
                        </div>
                        
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <input type="hidden" id="id2" name="id">
                        <div class="form-group">
                            <label for="editExamName">Exam Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="editExamName" name="exam_name" placeholder="Enter Exam Name" required>
                        </div>
                        <!-- First Row: Year and Current Exam -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="year2">Year <span class="text-danger">*</span></label>
                                    <?php echo e(generateDropdown($academicYears, 'name="year" class="form-control year" id="year2"', $academic_year, 'Select Year')); ?>

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="is_published2">Current Exam</label>
                                    <select class="form-control" id="is_published2" name="is_published">
                                        <option value="1">Yes</option>
                                <option value="0">No</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <!-- Second Row: Start Date and End Date -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exam_start_date2">Exam Start Date</label>
                                    <input type="text" class="form-control date3603" id="exam_start_date2" name="exam_start_date"
                                        required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="exam_end_date2">Exam End Date</label>
                                    <input type="text" class="form-control date3604" id="exam_end_date2" name="exam_end_date"
                                        required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->


    <!-- Modal mark head -->
    <div class="modal fade" id="markHeadStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('markHead.store')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Mark Head </h4>
                        </div>
                        
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="head_name">Head Name<span class="text-danger"> *</span></label>
                            <input id="head_name" type="text"
                                   class="form-control <?php $__errorArgs = ['head_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="head_name"
                                   value="<?php echo e(old('head_name')); ?>" placeholder="Enter marks head name" autofocus
                                   required>
                        </div>
                        <div class="form-group">
                            <label for="short_name">Short Name<span class="text-danger"> *</span></label>
                            <input id="short_name" type="text"
                                   class="form-control <?php $__errorArgs = ['short_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="short_name"
                                   value="<?php echo e(old('short_name')); ?>" placeholder="Enter marks short name" autofocus
                                   required>
                        </div>

                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
   
    <div class="modal fade" id="markHeadEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('markHead.update')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Mark Head </h4>
                        </div>
                        
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="head_name">Head Name<span class="text-danger"> *</span></label>
                            <input id="head_name" type="text"
                                   class="form-control <?php $__errorArgs = ['head_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="head_name"
                                   value="<?php echo e(old('head_name')); ?>" placeholder="Enter marks head name" autofocus
                                   required>
                        </div>
                        <div class="form-group">
                            <label for="short_name">Short Name<span class="text-danger"> *</span></label>
                            <input id="short_name" type="text"
                                   class="form-control <?php $__errorArgs = ['short_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="short_name"
                                   value="<?php echo e(old('short_name')); ?>" placeholder="Enter marks short name" autofocus
                                   required>
                        </div>

                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->


    <!-- Modal exam publish -->
    <div class="modal fade" id="resultPublishStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('publish.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Publish Exam Result</h4>
                        </div>
                        
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>

                        <div class="form-group">

                            <select name="exam_id" class="form-control select2 exam_id" id="exam_id" required>
                                <option value="">Exam</option>
                                <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $examItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($examItem->id); ?>" <?php if($exam_id == $examItem->id || (!$exam_id && $loop->first)): echo 'selected'; endif; ?> >
                                        <?php echo e($examItem->exam_name . ' ' . $examItem->academic_year->year); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="publish_date">Publish Date</label>
                            <input type="text" name="publish_date" value="<?php echo e(date('d-m-Y')); ?>" readonly class="form-control date360">
                        </div>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger m-3">
                                <ul class="m-0">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" name="publish_and_send_sms" class="btn btn-info mx-2" onclick="return confirm('Are you sure you want to publish and send SMS?')">Publish & Send SMS</button>
                            <button type="submit" name="publish_only" class="btn btn-info">Publish</button>

                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        // Save active tab on click
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            localStorage.setItem('activeTab', $(e.target).attr('href'));
        });

        // Load active tab on page reload
        $(document).ready(function () {
            var activeTab = localStorage.getItem('activeTab');
            if (activeTab) {
                $('a[href="' + activeTab + '"]').tab('show');
            }
        });
        
        const today = new Date();
        $('.date3601').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true,
        }).datepicker('setDate', today);
        $('.date3602').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true,
        }).datepicker('setDate', today);
         $('.date3603').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true,
        })
        // Initialize the end date picker
        $('.date3604').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true,
        });
        $('.date360').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true,
        }).datepicker('setDate', today);

        $('#gradePointEditModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget)
            var name = button.data('name')
            var markFrom = button.data('mark-from')
            var markTo = button.data('mark-to')
            var gpa = button.data('gpa')
            var remark = button.data('remark')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#mark_from').val(markFrom)
            modal.find('#mark_to').val(markTo)
            modal.find('#gpa').val(gpa)
            modal.find('#remark').val(remark)
            modal.find("#grade").val(name).trigger('change');
            modal.find('#id').val(id)
        })

        $('#markHeadEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var head_name = button.data('head-name')
            var short_name = button.data('short-name')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#head_name').val(head_name)
            modal.find('#short_name').val(short_name)
            modal.find('#id').val(id)
        })


        $('#dataEditModal').on('hidden.bs.modal', function () {
            // Reset the form inside the modal
            $(this).find('form')[0].reset();
            // Optionally, reset specific fields manually (in case you're setting them dynamically)
            $(this).find('.form-control').val('');
            $(this).find('.form-control-sm').val('');
        });

        $('#dataEditModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget)
            var editExamName = button.data('edit-name')
            var year = button.data('year')
            var start_date = button.data('start-date')
            var end_date = button.data('end-date')
            var is_published = button.data('is-published')
            var id = button.data('id')
            var modal = $(this)
            // Populate the modal fields with data only if they are empty
            if (!modal.find('#editExamName').val()) {
                modal.find('#editExamName').val(editExamName)
            }
            if (!modal.find('#exam_start_date2').val()) {
                modal.find('#exam_start_date2').val(start_date)
            }
            if (!modal.find('#exam_end_date2').val()) {
                modal.find('#exam_end_date2').val(end_date)
            }
            if (!modal.find("#year2").val()) {
                modal.find("#year2 option[value=" + year + "]").prop("selected", true);
            }
            if (!modal.find("#is_published2").val()) {
                modal.find("#is_published2 option[value=" + is_published + "]").prop("selected", true);
            }
            if (!modal.find('#id2').val()) {
                modal.find('#id2').val(id)
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/result/exam_setup/index.blade.php ENDPATH**/ ?>