<?php $__env->startSection('styles'); ?>
    <style type="text/css">

    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="mt-4 std__attn pb-5">
        <div class="attn__header text-center mb-2">
            <h4 class="mb-1">Today's Attendance</h4>
            <h4><span><?php
                    echo date('l, jS F Y');?>
                </span>
            </h4>
           <h4>My Class: <b><?php echo e($student_class_name ?? ''); ?>, Section: <?php echo e($section_name ?? ''); ?></b></h4>
        </div>

        <div class="std__attn__body">
            <form method="POST" action="<?php echo e(route('student_attendance.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="form-inline">
                    <?php if(isset($students)): ?>
                        <div class="row">
                            <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-6 col-xl-4 col-xxl-3 col-12 std__single">
                                    <div class="std__card">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div class="std__info d-flex align-items-center">
                                                        <img src="/uploads/student/graduated_student.png"
                                                             alt="<?php echo e($studentInfo->name ?? 'N/A'); ?>" height="50">
                                                        <div class="info">
                                                            <p class="mb-1">Roll: <?php echo e($student->class_roll); ?></p>
                                                            <p class="mb-1"><b><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></b></p>
                                                            <p class="mb-1">Call: <a
                                                                    href="tel:<?php echo e($student->guardian_mobile); ?>">
                                                                    <svg
                                                                        xmlns="http://www.w3.org/2000/svg"
                                                                        width="32"
                                                                        height="32"
                                                                        viewBox="0 0 24 24"
                                                                        fill="none"
                                                                        stroke="#000000"
                                                                        stroke-width="1"
                                                                        stroke-linecap="round"
                                                                        stroke-linejoin="round"
                                                                    >
                                                                        <path
                                                                            d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2"/>
                                                                        <path d="M15 7a2 2 0 0 1 2 2"/>
                                                                        <path d="M15 3a6 6 0 0 1 6 6"/>
                                                                    </svg>
                                                                </a></p>
                                                        </div>
                                                    </div>
                                                    <div class="std__action">
                                                        <input type="hidden" name="student_id[]"
                                                               value="<?php echo e($student->id); ?>">
                                                        <div class="form-check-inline">
                                                            <label class="form-check-label "
                                                                   for="radioP<?php echo e($student->id); ?>">
                                                                <input type="radio" class="form-check-input"
                                                                       id="radioP<?php echo e($student->id); ?>"
                                                                       name="attendance_status[<?php echo e($student->id); ?>]"
                                                                       value="P"
                                                                       checked>Present
                                                            </label>
                                                        </div>
                                                        <div class="form-check-inline">
                                                            <label class="form-check-label"
                                                                   for="radioA<?php echo e($student->id); ?>">
                                                                <input
                                                                    <?php if(isset($student->attendance->is_absent) && $student->attendance->is_absent == 1): ?> checked
                                                                    <?php endif; ?> type="radio" class="form-check-input"
                                                                    id="radioA<?php echo e($student->id); ?>"
                                                                    name="attendance_status[<?php echo e($student->id); ?>]"
                                                                    value="A">Absent
                                                            </label>
                                                        </div>
                                                        <div class="form-check-inline">
                                                            <label class="form-check-label"
                                                                   for="radioL<?php echo e($student->id); ?>">
                                                                <input
                                                                    <?php if(isset($student->attendance->is_late) && $student->attendance->is_late == 1): ?> checked
                                                                    <?php endif; ?> type="radio" class="form-check-input"
                                                                    id="radioL<?php echo e($student->id); ?>"
                                                                    name="attendance_status[<?php echo e($student->id); ?>]"
                                                                    value="L">Late
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="attn__note">
                                    
                                    
                                    

                                    <input type="hidden" name="student_class_id[<?php echo e($student->id); ?>]"
                                           value="<?php if(!empty($student_class_id)): ?> <?php echo e($student_class_id); ?> <?php endif; ?>">
                                    <input type="hidden" name="shift_id"
                                           value="<?php if(!empty($shift_id)): ?> <?php echo e($shift_id); ?> <?php endif; ?>">
                                    <input type="hidden" name="section_id"
                                           value="<?php if(!empty($section_id)): ?> <?php echo e($section_id); ?> <?php endif; ?>">
                                    <input type="hidden" class="form-control attendance_date"
                                           name="attendance_date"
                                           value="<?php echo e($attendance_date ?? date("Y-m-d")); ?>"
                                           id="attendance_date" readonly required>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    <?php else: ?>
                    <tr>
                        <td colspan="6" class="text-center"> No data available in table</td>
                    </tr>
                    <?php endif; ?>
                        <?php if(isset($students) && !empty($students)): ?>
                            
                            <div class="text-center">
                                <button type="submit" class="btn btn-submit att__btn mt-3">Submit
                                </button>
                            </div>
                        <?php endif; ?>

                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/student_attendance/my-student.blade.php ENDPATH**/ ?>