<!DOCTYPE html>
<html lang="en">
<?php
    $logo_path = get_setting_value(Settings::SCHOOL_LOGO,1) ? get_setting_value(Settings::SCHOOL_LOGO,1) : 'uploads/images/logo.png';
    $school_name = get_setting_value(Settings::SCHOOL_NAME,1) ? get_setting_value(Settings::SCHOOL_NAME,1) : '';
?>

<head>

    <title>Login - EduEasy</title>
    <meta name="title" content="Login - EduEasy"/>
    <meta name="keywords" content="edueasy, best education management system"/>
    <meta property="og:title" content="Login - EduEasy"/>
    <meta property="og:description" content="">
    <meta name="twitter:title" content="Login - EduEasy"/>
</head>


<?php echo $__env->make('partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<body class="bg-gradient-login login__page">
<!-- Login Content -->
<div class="container-login d-flex justify-content-center align-items-center min-vh-100 position-relative">
    <div class="">
        <div class="card">
            <div class="card-body p-0">
                <div class="login-form">
                    <div class="text-center mb-4">
                        <a href="/" target="_blank" class="login__pg__logo"><img src="<?php echo e(asset($logo_path)); ?>"
                                                                                 class="img-fluid"></a>
                        <p>Welcome to</p>
                        <h4 class="title mb-4"><?php echo e($school_name); ?></h4>
                        <h4 class="title">Login</h4>
                        <h5 class="text-gray-900 mb-4 d-none">to your <span class="txt__edu">edu</span><span class="txt__easy">easy</span> account</h5>
                    </div>
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="list-group list-unstyled">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                    <form class="user" method="POST" action="/login">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <input type="text" name="email" class="form-control" id="exampleInputEmail"
                                   aria-describedby="emailHelp" value="" placeholder="Enter Student ID"
                                   required>
                        </div>
                        <div class="form-group">
                            <div class="pass__field position-relative">
                                <input type="password" name="password" class="form-control" value=""
                                       id="exampleInputPassword" placeholder="Enter Password" aria-describedby="passwordHelp">
                                <div class="view__pass">
                                        <span id="togglePassword" style="cursor: pointer;">
                                            <i class="fas fa-eye" id="eyeIcon"></i>
                                        </span>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="custom-control custom-checkbox small" style="line-height: 1.5rem;">
                                <input type="checkbox" class="custom-control-input" id="customCheck">
                                <label class="custom-control-label" for="customCheck">Remember Me</label>
                            </div>
                        </div>
                        <div class="">
                            <button type="submit"
                                    class="form-group login d-flex align-items-center justify-content-between">
                                <span>Next</span>
                                <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    width="25"
                                    height="25"
                                    viewBox="0 0 24 24"
                                    fill="none"
                                    stroke="#fff"
                                    stroke-width="2"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                >
                                    <path d="M5 12l14 0"/>
                                    <path d="M13 18l6 -6"/>
                                    <path d="M13 6l6 6"/>
                                </svg>
                            </button>
                        </div>
                    </form>
                    <div class="text-center">
                        <a class="small txt__underline" href="<?php echo e(route('forgot-password')); ?>">Forgot Password?</a>
                    </div>
                </div>
                <div class="login_rightside_box">
                    <div id="overlapBanner" class="overlapBanner" style="width: 300px; display: block;">
                        <!--   BANNER TYPE 1     -->
                        <style type="text/css">
                            .img {
                                display: block;
                                width: 100%;
                                height: 240px;
                                margin: auto;
                                background-size: 100%;
                            }

                            .heading {
                                display: block;
                                text-align: center;
                                color: #000000c7;
                                font-weight: 700;
                                margin: 15px 0 3px;
                            }
                        </style>
                        <div class="img"
                             style="background-image: url('/assets/img/login.svg');"></div>
                        <div class="heading">Use Strong Password</div>
                        <div style="" class="banner1_content px-3 text-center">A password that uses special characters,
                            uppercase and
                            lowercase letters, and is long at 6 to 14 characters.
                        </div>
                    </div>
                </div>
            </div>
            <div class="credit text-center my-3">

                <span>Powered by <a href="https://www.edueasybd.com/"
                                                                              target="_blank"><img
                            src="https://www.edueasybd.com/logo.svg" style="max-height: 17px;"> </a></span>
            </div>
        </div>
    </div>
</div>
<!-- Login Content -->
<?php if(session('status')): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            toastr.success("<?php echo e(session('status')); ?>");
        });
    </script>
<?php endif; ?>

<script>
    document.getElementById('togglePassword').addEventListener('click', function () {
        const passwordInput = document.getElementById('exampleInputPassword');
        const eyeIcon = document.getElementById('eyeIcon');
        const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordInput.setAttribute('type', type);
        eyeIcon.classList.toggle('fa-eye');
        eyeIcon.classList.toggle('fa-eye-slash');
    });
</script>

</body>

</html>
<?php /**PATH /var/www/html/EdueasyCollege/resources/views/auth/login.blade.php ENDPATH**/ ?>