<?php $__env->startSection('styles'); ?>
<style>
        .image-uploader {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative; /* Add position relative */
        }

        .image-uploader__label {
            display: flex;
            flex-direction: column;
            align-items: center;
            cursor: pointer;
            position: relative; /* Add position relative */
        }

        .image-uploader__icon-overlay {
            position: absolute;
            top: 50%; /* Align vertically centered */
            left: 50%; /* Align horizontally centered */
            transform: translate(-50%, -50%); /* Center the icon */
            width: 100%;
            height: calc(100%); /* Height equal to parent minus icon height */
            background-color: rgba(0, 0, 0, 0.2); /* Transparent black background */
            border-radius: 50%; /* Rounded border */
            display: flex;
            justify-content: center;
            align-items: center;
            opacity: 0.3;
        }

        .image-uploader__icon-overlay i {
            color: #ffffff; /* Icon color */
            font-size: 24px; /* Icon size */
        }

        /* Your existing styles */
        .image-uploader__preview {
            overflow: hidden;
        }

        .image-uploader__input {
            display: none;
        }

        .previous_institute_tc .dropify-wrapper{
            height: 122px !important;
        }

    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid mt-5 mb-5">
        <div class="row justify-content-center">
            <div class="col-md-12">
                
                <div class="card std__form">
                    <div class="card-header py-3 ">
                        <h2 class="mx-0 text-center">Online Applicant Info Show</h2>
                    </div>

                    <div class="card-body">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <?php if(session('success')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>
                        
                        <form action="<?php echo e(route('online-admission.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="py-2 mb-0 form__head">
                                Academic information
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="session">Session <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="session" id="session"
                                                value="<?php echo e($item->session); ?>" placeholder="Enter Session" readonly>
                                        </div>
                                    </div>
                                    
                                    <?php if($branches->count() > 1): ?>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="branch_id">Branch <span class="text-danger">*</span></label>
                                                <?php echo e(generateDropdown($branches, 'class="form-control branch_id" id="branch_id" name="branch_id" required', $item->branch_id )); ?>

                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <?php
                                            $branchId = $branches->keys()->first();
                                        ?>
                                        <input type="hidden" name="branch_id" value="<?php echo e($branchId); ?>">
                                    <?php endif; ?>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="student_class_id">Class <span class="text-danger">*</span> </label>
                                            <?php echo e(generateDropdown($studentClasses, 'class="form-control select2 student_class" id="student_class" name="student_class_id" required', $item->student_class_id, 'Select Option')); ?>

                                        </div>
                                    </div>

 
                                </div>
                            </div>

                            <div class="py-2 mb-0 form__head">
                                Personal information
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    <div class="col-md-9">
                                        <div class="row">
                                            
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="first_name">Name <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="first_name" id="first_name"
                                                        value="<?php echo e($item->first_name); ?>" placeholder="Enter First Name" required>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="gender">Gender <span class="text-danger">*</span> </label>
                                                    <?php echo e(generateDropdown($genderOptions, 'class="form-control" name="gender" required', $item->gender, 'Select Option')); ?>

                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="blood_group">Blood group </label>
                                                    <?php echo e(generateDropdown($bloodGroupOptions, 'class="form-control" name="blood_group"', $item->blood_group, 'Select Option')); ?>

                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="religion">Religion <span class="text-danger">*</span> </label>
                                                    <?php echo e(generateDropdown($religionOptions, 'class="form-control" name="religion" required', $item->religion )); ?>

                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="date_of_birth">Date of birth <span class="text-danger">*</span> </label>
                                                    <input type="date" class="form-control date360" name="date_of_birth"
                                                        value="<?php echo e($item->date_of_birth); ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="birth_certi_no">Birth certificate no </label>
                                                    <input type="number" class="form-control" name="birth_certi_no"
                                                        value="<?php echo e($item->birth_certi_no); ?>" placeholder="Enter Birth Certificate No">
                                                </div>
                                            </div>


                                            
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="mobile_no"><b>Mobile number (for SMS)</b> <span class="text-danger">*</span>
                                                    </label>
                                                    <input type="tel" class="form-control" name="mobile_no" value="<?php echo e($item->mobile_no); ?>"
                                                        placeholder="Enter Mobile Number" required>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="email">Email </label>
                                                    <input type="email" class="form-control" name="email" value="<?php echo e($item->email); ?>"
                                                        placeholder="Enter Email">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="image-uploader">
                                            <label for="image">Profile Image </label>
                                            <label for="imageFile" class="image-uploader__label">
                                                <!-- Icon overlay with transparent background -->
                                                <div class="image-uploader__icon-overlay">
                                                    <i class="fas fa-cloud-upload-alt"></i>
                                                </div>
                                                <!-- Preview image -->
                                                <img src="<?php echo e(asset( $item->profile_image ?? '/default/profile.png')); ?>" alt="Preview image"
                                                    class="image-uploader__preview-image img-thumbnail rounded-circle p-1"
                                                    style="width: 140px; height: 140px;">
                                                <!-- File input -->
                                                <input type="file" name="profile_image" class="image-uploader__input" id="imageFile"
                                                    accept="image/*">
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="py-2 mb-0 form__head">
                                Parent information
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="father_name">Father's name <span class="text-danger">*</span> </label>
                                            <input type="text" class="form-control" name="father_name"
                                                value="<?php echo e($item->father_name); ?>" placeholder="Enter Father Name" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="father_occupation">Father's occupation </label>
                                            <?php echo e(generateDropdown($occupations, 'class="form-control select2 father_occupation" id="father_occupation" name="father_occupation"', $item->father_occupation, 'Select Option')); ?>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="father_mobile">Father mobile </label>
                                            <input type="tel" class="form-control" name="father_mobile"
                                                value="<?php echo e($item->father_mobile); ?>" placeholder="Enter Father Mobile">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="mother_name">Mother name </label>
                                            <input type="text" class="form-control" name="mother_name"
                                                value="<?php echo e($item->mother_name); ?>" placeholder="Enter Mother Name">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="mother_occupation">Mother occupation </label>
                                            <?php echo e(generateDropdown($occupations, 'class="form-control select2" name="mother_occupation"', $item->mother_occupation, 'Select Option')); ?>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="mother_mobile">Mother mobile </label>
                                            <input type="tel" class="form-control" name="mother_mobile"
                                                value="<?php echo e($item->mother_mobile); ?>" placeholder="Enter Mother Mobile">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="py-2 mb-0 form__head">
                                Address
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    
                                    <label class="ml-2" for="present_address">Present address</label>
                                    <div class="row col-md-12 mt-2">
                                        <?php if (isset($component)) { $__componentOriginaled3462c3fe352bdde24ef8fe3b389577 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaled3462c3fe352bdde24ef8fe3b389577 = $attributes; } ?>
<?php $component = App\View\Components\LocationDropdown::resolve(['selectedDistrict' => old('present_district_id'),'selectedUpazila' => old('present_upazila_id'),'containerClass' => '','groupClass' => 'form-group col-md-3','labelClass' => 'form-label','selectClass' => 'form-control select2','prefix' => 'present'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('location-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LocationDropdown::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaled3462c3fe352bdde24ef8fe3b389577)): ?>
<?php $attributes = $__attributesOriginaled3462c3fe352bdde24ef8fe3b389577; ?>
<?php unset($__attributesOriginaled3462c3fe352bdde24ef8fe3b389577); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaled3462c3fe352bdde24ef8fe3b389577)): ?>
<?php $component = $__componentOriginaled3462c3fe352bdde24ef8fe3b389577; ?>
<?php unset($__componentOriginaled3462c3fe352bdde24ef8fe3b389577); ?>
<?php endif; ?>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <textarea class="form-control" name="present_address" id="present_address"
                                                        placeholder="Enter Present Address"><?php echo e(old('present_address')); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    

                                    
                                    <label class="ml-2 mt-4" for="permanent_address">Permanent address</label>
                                    <div class="mx-2 mt-4">
                                        (<input class="mx-2" type="checkbox" id="copyAddress"/>
                                        <label for="copyAddress"> Same as present address</label>)
                                    </div>

                                    <div class="row col-md-12 mt-2">
                                        <?php if (isset($component)) { $__componentOriginaled3462c3fe352bdde24ef8fe3b389577 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaled3462c3fe352bdde24ef8fe3b389577 = $attributes; } ?>
<?php $component = App\View\Components\LocationDropdown::resolve(['selectedDistrict' => old('permanent_district_id'),'selectedUpazila' => old('permanent_upazila_id'),'selectedUnion' => old('permanent_union_id'),'containerClass' => '','groupClass' => 'form-group col-md-3','labelClass' => 'form-label','selectClass' => 'form-control select2','prefix' => 'permanent'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('location-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LocationDropdown::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaled3462c3fe352bdde24ef8fe3b389577)): ?>
<?php $attributes = $__attributesOriginaled3462c3fe352bdde24ef8fe3b389577; ?>
<?php unset($__attributesOriginaled3462c3fe352bdde24ef8fe3b389577); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaled3462c3fe352bdde24ef8fe3b389577)): ?>
<?php $component = $__componentOriginaled3462c3fe352bdde24ef8fe3b389577; ?>
<?php unset($__componentOriginaled3462c3fe352bdde24ef8fe3b389577); ?>
<?php endif; ?>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <textarea class="form-control" name="permanent_address" id="permanent_address"
                                                        placeholder="Enter Permanent Address"><?php echo e(old('permanent_address')); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>


                            <div class="py-2 mb-0 form__head">
                                Sibling information
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="sibling_student_id_no">Sibling</label>
                                            <input type="number" class="form-control" name="sibling_student_id_no"
                                                value="<?php echo e($item->sibling_student_id_no); ?>" placeholder="Enter Student ID">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="py-2 mb-0 form__head">
                                Previous Institute Information
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    <div class="col-md-9">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="previous_institute_name">Institute name</label>
                                                    <input type="text" class="form-control" name="previous_institute_name"
                                                        value="<?php echo e($item->previous_institute_name); ?>" placeholder="Enter Institute Name">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="previous_institute_address">Institute address</label>
                                                    <input type="text" class="form-control" name="previous_institute_address"
                                                        value="<?php echo e($item->previous_institute_address); ?>" placeholder="Enter Institute Address">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="previous_institute_tc_no">T.C. No.</label>
                                                    <input type="text" class="form-control" name="previous_institute_tc_no"
                                                        value="<?php echo e($item->previous_institute_tc_no); ?>" placeholder="Enter T.C. No.">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="previous_institute_tc_date">T.C. Date</label>
                                                    <input type="date" class="form-control" name="previous_institute_tc_date"
                                                        value="<?php echo e($item->previous_institute_tc_date); ?>" placeholder="Enter T.C. Date">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group previous_institute_tc">
                                            <label for="previous_institute_tc">T.C.</label>
                                            <input name="previous_institute_tc" value="<?php echo e($item->previous_institute_tc); ?>" id="previous_institute_tc" type="file"
                                                class="dropify" data-default-file="<?php echo e(old('previous_institute_tc')); ?>"/>
                                            <?php $__errorArgs = ['previous_institute_tc'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>  
                                </div>
                            </div>


                            
                            <div class="mt-3 flex justify-content-end">
                                <a href="<?php echo e(url()->previous()); ?>" type="button" class="btn btn-default mr-3">Back</a>
                            </div>
                        </form>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
    <script>
        const input = document.querySelector('.image-uploader__input');
        const previewImage = document.querySelector('.image-uploader__preview-image');
        input.addEventListener('change', () => {
            const file = input.files[0];
            const reader = new FileReader();

            reader.onload = (event) => {
                previewImage.src = event.target.result;
            };
            reader.readAsDataURL(file);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function () {
    $('.dropify').dropify({
        messages: {
            'default': '<i class="fa fa-upload fa-2x mb-2 text-primary"></i><br>Drag and drop a file here or click',
            'replace': '<i class="fa fa-sync-alt fa-2x mb-2 text-warning"></i><br>Drag and drop or click to replace',
            'remove': 'Remove',
            'error': 'Ooops, something went wrong.'
        }
    });
});

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/admission/online-admission/show.blade.php ENDPATH**/ ?>