<?php $__env->startSection('content'); ?>
<style>
    .admit-card-wrapper {
        max-width: 600px;
      margin: 30px auto;
      padding: 20px;
    }
    .admit-card-wrapper h2 {
      text-align: center;
      margin-bottom: 20px;
      text-transform: uppercase;
    }
    .admit-card-wrapper .info-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 20px;
        font-size: 18px;
        color: #000;
    }
    .info-label {
      font-weight: bold;
      margin-right: 5px;
    }
    .info-item {
      display: flex;
        border-bottom: 1px dotted #464646;
    }

    .signature-section {
      display: flex;
      justify-content: space-between;
      margin-top: 36px;
      align-items: center;
    }
    .signature-box {
      text-align: center;
      width: 200px;
    }
    .signature-img{
        height: 40px;
    }
    .signature-img img{
        height: 40px;
    }
    .signature-line {
      border-top: 1px solid #333;
    margin-bottom: 1px;
    margin-top: 1px;
    }

    .institute-name h3{
        font-size: 30px;
        font-weight: bold;
        margin-top: 14px;
        margin-bottom: 1px;
        font-family: sans-serif;
    }

    .admit-card-name  {
        text-align: center;
        margin-bottom: 24px;
        font-size: 24px;
        color: #000;
        text-transform: none;
    }

    .admit-card-name span{
        border: 2px solid #000;
        padding: 2px 8px;

    }
   
    .title,
    .institute-name,
    .institute-address,
    .exam-name{
        text-align: center;
        color: #000;
        text-transform: none;
    }
    .admin__bg{
        position: absolute;
        width: 100%;
        background-image: url(/default/admin_bg_4.png);
        height: 100%;
        background-size: contain;
        background-repeat: no-repeat;
        left: 0;
        right: 0;
        top: 0;
        bottom: 0;
    }
    /*.institute-info .title{*/
    /*    font-family: serif;*/
    /*}*/
</style>
    <div class="card">
        <div class="card-body card__head">
            <!-- Nav tabs -->
            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(request()->input('tab') === 'search' || request()->input('tab') === null ? 'show active' : ''); ?>" data-toggle="tab" href="#search-tab">
                        Search By ID
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(request()->input('tab') === 'filter' ? 'show active' : ''); ?>" data-toggle="tab" href="#filter-tab">
                        Search by Class
                    </a>
                </li>
            </ul>
            <!-- Tab panes -->
            <div class="tab-content">
                <div id="search-tab" class="tab-pane <?php echo e(request()->input('tab') === 'search' || request()->input('tab') === null ? 'show active' : ''); ?>"><br>
                    <form method="post" action="<?php echo e(route('admit-card.student.filter')); ?>" class="row">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="tab" value="search">

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <select name="exam" class="form-control select2" id="exam" required>
                                <option value="">Exam</option>
                                <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($exam_id==$exam->id): ?>
                                        <option value="<?php echo e($exam->id); ?>" selected><?php echo e($exam->exam_name ." ". $exam->academic_year->year); ?></option>
                                    <?php else: ?>
                                        <option  <?php echo e($loop->first ? 'selected' : ''); ?> value="<?php echo e($exam->id); ?>"><?php echo e($exam->exam_name ." ". $exam->academic_year->year); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <?php $__env->startComponent('components.search_student', [
                                'student_name' => $student_name ?? '',
                                'student_id_no' => request()->student_id_no ?? '',
                                'required' => '',
                            ]); ?>
                            <?php echo $__env->renderComponent(); ?>
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
                <div id="filter-tab" class="tab-pane fade <?php echo e(request()->input('tab') === 'filter' ? 'show active' : ''); ?>"><br>
                    <form method="post" action="<?php echo e(route('admit-card.student.filter')); ?>" class="row">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="tab" value="filter">

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <select name="exam" class="form-control select2" id="exam" required>
                                <option value="">Exam</option>
                                <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($exam_id==$exam->id): ?>
                                        <option value="<?php echo e($exam->id); ?>" selected><?php echo e($exam->exam_name ." ". $exam->academic_year->year); ?></option>
                                    <?php else: ?>
                                        <option  <?php echo e($loop->first ? 'selected' : ''); ?> value="<?php echo e($exam->id); ?>"><?php echo e($exam->exam_name. " " .$exam->academic_year->year); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <select name="shift" class="form-control select2 shift_id" id="shift_id" required>
                                <option value="">Shift</option>
                                <?php $__currentLoopData = $shifts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($shift->id); ?>" <?php echo e($loop->first ? 'selected' : ''); ?>>
                                        <?php echo e($shift->shift_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <?php echo e(generateDropdown($studentClasses, 'class="form-control student_class student_class_id select2" id="student_class" name="student_class" required', request()->input('student_class'), "Class")); ?>

                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <?php echo e(generateDropdown([], 'class="form-control section" id="section" name="section"', request()->input('section'), "Section")); ?>

                        </div>

                    <?php if (isset($component)) { $__componentOriginal24102f1ac62c394be69e2bc4df251128 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal24102f1ac62c394be69e2bc4df251128 = $attributes; } ?>
<?php $component = App\View\Components\GroupSelector::resolve(['name' => 'group','label' => '','labelText' => 'Group','col' => 'form-group col-lg-2 col-md-6 col-sm-6','required' => (int) request()->input('student_class') >= 11,'selected' => old('group') ?? request()->input('group')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('group-selector'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\GroupSelector::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['student_class_id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute((int) request()->input('student_class'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal24102f1ac62c394be69e2bc4df251128)): ?>
<?php $attributes = $__attributesOriginal24102f1ac62c394be69e2bc4df251128; ?>
<?php unset($__attributesOriginal24102f1ac62c394be69e2bc4df251128); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal24102f1ac62c394be69e2bc4df251128)): ?>
<?php $component = $__componentOriginal24102f1ac62c394be69e2bc4df251128; ?>
<?php unset($__componentOriginal24102f1ac62c394be69e2bc4df251128); ?>
<?php endif; ?>


                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php if(isset($students) && !empty($students) && $students->count() > 0 ): ?>
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
                <h6 class="m-0 table__top__txt">Admit Card (Total Result: <?php echo e(count($students)); ?>)</h6>
                <div class="m-0 float-right">
                    <a class="btn btn-secondary btn__export mr-1" href="#" data-toggle="tooltip"
                    <?php if(count($students) > 0): ?>
                        onclick="prindAdmitCard()"
                    <?php else: ?>
                        onclick="return false;"
                    <?php endif; ?> title="Print" >
                        <i class="fas fa-print"></i>
                    </a>
                </div>
            </div>
                <?php
                    $logo_path = get_setting_value(Settings::EXPORT_LOGO) ? get_setting_value(Settings::EXPORT_LOGO) : 'uploads/images/logo.png';
                    $institute_name = get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : 'Jabalunnur Al-Jamiatul Islamia';
                    $principal_signature = get_setting_value(Settings::PRINCIPAL_SIGNATURE) ? get_setting_value(Settings::PRINCIPAL_SIGNATURE) : '';
                    $branch_info = get_branch_info();
                ?>
            <div class="card-body table_content row" id="admit-card">
                <?php $__currentLoopData = $students->sortBy('class_roll'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6 col-lg-6 items">
                        <section class="page-section">
                            <div class="container" >
                                <div class="admit-card-wrapper items position-relative">
                                    <div class="admin__bg"></div>
                                    <div class="institute-info">
                                        <h5 class="title" style="font-family: 'Amiri', 'Scheherazade', serif;font-size: 27px;margin-bottom: 0px;" dir="rtl">بِسْمِ اللهِ الرَّحْمٰنِ الرَّحِيْمِ                                        </h5>
                                        <div class="institute-name"><h3><?php echo e($institute_name); ?></h3></div>
                                        <div class="institute-address"><?php echo e($branch_info->address ?? 'N/A'); ?></div>
                                    </div>
                                    <div class="exam-name"><p><?php echo e($selected_exam->exam_name ?? 'N/A'); ?>-<?php echo e($selected_exam->academic_year->year ?? 'N/A'); ?></p></div>
                                    <div class="admit-card-name"><span>Admit Card</span></div>
                                    <div class="student-info">
                                        <div class="info-row">
                                            <div class="info-item"><div class="info-label">Name:</div> <?php echo e($student->name ?? 'N/A'); ?></div>
                                            <div class="info-item"><div class="info-label">Roll:</div> <?php echo e($student->class_roll ?? 'N/A'); ?></div>
                                          </div>

                                          <div class="info-row">
                                            <div class="info-item"><div class="info-label">Class:</div> <?php echo e($student->studentClass->class_name ?? 'N/A'); ?></div>
                                            <div class="info-item"><div class="info-label">ID No:</div> <?php echo e($student->student_id_no ?? 'N/A'); ?></div>
                                          </div>
                                    </div>

                                    <div class="signature-section">
                                        <div class="signature-box">
                                            <div class="signature-img">
                                            </div>
                                            <div class="signature-line"></div>
                                            <div>Class Teacher</div>
                                        </div>
                                        <div class="signature-box">
                                            <div class="signature-img">
                                                <?php if(!empty($principal_signature)): ?>
                                                    <img src="<?php echo e(asset($principal_signature)); ?>" alt="Principal Signature" >
                                                <?php endif; ?>
                                            </div>
                                            <div class="signature-line">
                                                
                                            </div>

                                            <div>Headmaster/Incharge</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    function prindAdmitCard() {
    let content = document.getElementById('admit-card').innerHTML;
    let printWindow = window.open('', '', 'height=900,width=1100');
    printWindow.document.write(`
        <html>
            <head>
                <style>

                    @media print {

                         #admit-card {
                            column-count: 2;
                            column-gap: 30px;
                        }
                         .admit-card-wrapper {
                            max-width: 600px;
                            margin: 30px auto;
                            padding: 10px 20px 15px ;
                        }
                        .page-section {
                            break-inside: avoid;
                            page-break-inside: avoid;
                            margin-top: 0 !important;
                            margin-bottom: 0 !important;
                        }

                        @page {
                            size: A4 portrait;
                            margin: 20mm;
                        }
                    }
                    .position-relative{
                        position:relative;
                    }
                    .admit-card-wrapper h2 {
                    text-align: center;
                    margin-bottom: 20px;
                    text-transform: uppercase;
                    }
                    .admit-card-wrapper .info-row {
                        display: flex;
                        justify-content: space-between;
                        margin-bottom: 20px;
                        font-size: 18px;
                        color: #000;
                    }
                    .info-label {
                    font-weight: bold;
                        margin-right: 5px;
                    }
                    .info-item {
                        display: flex;
                        border-bottom: 1px dotted #464646;
                    }

                    .signature-section {
                        display: flex;
                        justify-content: space-between;
                        margin-top: 36px;
                        align-items: center;
                    }
                    
                    .signature-box {
                        text-align: center;
                        width: 200px;
                    }
                    .signature-img{
        height: 40px;
    }
    .signature-img img{
        height: 40px;
    }
    .signature-line {
      border-top: 1px solid #333;
    margin-bottom: 1px;
    margin-top: 1px;
    }
    
                    .institute-name h3{
                        font-size: 30px;
                        font-weight: bold;
                        margin-top: 14px;
                        margin-bottom: 1px;
                        font-family: sans-serif;
                    }

                    .admit-card-name  {
                        text-align: center;
                        margin-bottom: 24px;
                        font-size: 24px;
                        color: #000;
                        text-transform: none;
                    }

                    .admit-card-name span{
                        border: 2px solid #000;
                        padding: 2px 8px;

                    }
                    .title,
                    .institute-name,
                    .institute-address,
                    .exam-name{
                        text-align: center;
                        color: #000;
                        text-transform: none;
                    }
                    .admin__bg{
                        position: absolute;
                        width: 100%;
                        background-image: url(/default/admin_bg_4.png);
                        height: 100%;
                        background-size: contain;
                        background-repeat: no-repeat;
                        left: 0;
                        right: 0;
                        top: 0;
                        bottom: 0;
                    }
                    .institute-info .title{
                        font-family: serif;
                    }
                </style>
            </head>
            <body>
                ${content}
            </body>
        </html>
    `);
    printWindow.document.close();
    printWindow.focus();

    setTimeout(() => {
        printWindow.print();
        printWindow.close();
    }, 500);  // Increased timeout for smoother operation
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/admit-card/index.blade.php ENDPATH**/ ?>