<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 col-md-12 col-lg-10 m-auto">
                <div class="page-header">
                    <div class="page-block mb-0">
                        <div class="row align-items-center">
                            <div class="col-md-12">
                                <div class="page-header-title mb-0">
                                    <h4 class="mb-0">My Subjects</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($mySubjects->isEmpty()): ?>
                    <div class="text-center py-5">
                        <i class="fas fa-books text-muted mb-3" style="font-size: 3rem;"></i>
                        <p class="text-muted">No subjects assigned yet.</p>
                    </div>
                <?php else: ?>
                    <div class="row g-3">
                        <?php $__currentLoopData = $mySubjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mySubject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card h-100 shadow-sm">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center mb-3">
                                            <div
                                                class="subject-icon rounded-circle d-flex align-items-center justify-content-center">
                                                <i class="fas fa-book"></i>
                                            </div>
                                            <div class="ms-3">
                                                <h5 class="mb-1"><?php echo e($mySubject->subject->subject_name ?? 'N/A'); ?></h5>
                                            </div>
                                        </div>

                                        <div class="subject-details">
                                            <div class="mb-2">
                                                <span class="teacher__name">Code: </span>
                                                <?php echo e($mySubject->subject->subject_code ?? 'N/A'); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <style>
        .subject-icon {
            width: 50px;
            height: 50px;
            background-color: #e3f2fd;
            color: #1976d2;
            font-size: 1.2rem;
        }

        .subject-details {
            font-size: 1rem;
        }

        .card {
            transition: transform 0.2s;
        }

        .card:hover {
            transform: translateY(-3px);
        }

        @media (max-width: 768px) {
            .card {
                margin-bottom: 1rem;
            }
        }
    </style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('students-dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/students-dashboard/pages/my-subjects.blade.php ENDPATH**/ ?>