<?php $__env->startSection('content'); ?>
    <div class="card marks__entry__head">
        <div class="card-header py-3 card__head">
            <form method="POST" action="<?php echo e(route('student_by_class')); ?>">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                        <select name="exam_id" class="form-control select2 exam_id" id="exam_id" required>
                            <option value="">Exam</option>
                            <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($exam->id); ?>" <?php echo e(getCurrentActiveExamId() == $exam->id ? 'selected' : ''); ?>>
                                    <?php echo e($exam->exam_name . ' ' . $exam->academic_year->year); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                        <select name="shift_id" class="form-control shift_id" id="shift_id" required>
                            <option value="">Shift</option>
                            <?php $__currentLoopData = $shifts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($shift->id); ?>" <?php echo e($loop->first ? 'selected' : ''); ?>>
                                    <?php echo e($shift->shift_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                        <?php echo e(generateDropdown($studentClasses, 'class="form-control select2 student_class student_class_id" id="student_class" name="student_class_id" required', $student_class_id, "Class")); ?>

                    </div>
                    <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                        <?php echo e(generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id"', $section_id, 'Section')); ?>

                    </div>
                    <?php if (isset($component)) { $__componentOriginal24102f1ac62c394be69e2bc4df251128 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal24102f1ac62c394be69e2bc4df251128 = $attributes; } ?>
<?php $component = App\View\Components\GroupSelector::resolve(['name' => 'group_id','label' => '','labelText' => 'Group','col' => 'form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6','required' => $student_class_id >= 11,'selected' => old('group_id') ?? $group_id] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('group-selector'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\GroupSelector::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['student_class_id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($student_class_id)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal24102f1ac62c394be69e2bc4df251128)): ?>
<?php $attributes = $__attributesOriginal24102f1ac62c394be69e2bc4df251128; ?>
<?php unset($__attributesOriginal24102f1ac62c394be69e2bc4df251128); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal24102f1ac62c394be69e2bc4df251128)): ?>
<?php $component = $__componentOriginal24102f1ac62c394be69e2bc4df251128; ?>
<?php unset($__componentOriginal24102f1ac62c394be69e2bc4df251128); ?>
<?php endif; ?>
                    <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                        <?php echo e(generateDropdown('', 'class="form-control subject_id" id="subject_id" name="subject_id" required', '', "Subject")); ?>

                    </div>
                    <div  class="col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6 btn__search">
                        <div class="form-group">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <?php if(isset($students)): ?>
        <div class="card mt-4 marks__entry__body">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <form method="POST" action="<?php echo e(route('marks.store')); ?>" class="form-inline">
                        <?php echo csrf_field(); ?>
                        <div class="table-responsive">
                            <?php if($assignedMarksHead): ?>
                                <input type="hidden" name="exam_id" value="<?php echo e($exam_id ?? ''); ?>">
                                <input type="hidden" name="student_class_id" value="<?php echo e($student_class_id ?? ''); ?>">
                                <input type="hidden" name="shift_id" value="<?php echo e($shift_id ?? ''); ?>">
                                <input type="hidden" name="branch_id" value="<?php echo e($branch_id ?? ''); ?>">
                                <input type="hidden" name="section_id" value="<?php echo e($section_id ?? ''); ?>">
                                <input type="hidden" name="subject_id" value="<?php echo e($subject_id ?? ''); ?>">
                                <input type="hidden" name="group_id" value="<?php echo e($group_id ?? ''); ?>">
                                <input type="hidden" name="academic_year" value="<?php echo e($academic_year ?? ''); ?>">
                                <table class="table">
                                    <thead class="thead-light">
                                    <tr>
                                        <th>Sl No</th>
                                        <th>Roll</th>
                                        <th>Student ID</th>
                                        <th class="th__name">Name</th>
                                        <?php
                                            $head_marks_array = json_decode($assignedMarksHead->head_marks, true);
                                        ?>
                                        <?php $__currentLoopData = $markHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(isset($head_marks_array[$head->id]) && $head_marks_array[$head->id] !== null): ?>
                                                <th class="th__marks__entry"
                                                    style="width: 10%; max-width: 10%; overflow: hidden;">
                                                    <?php echo e($head->short_name); ?>(<?php echo e($head_marks_array[$head->id]); ?>)
                                                </th>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><?php echo e($student->class_roll); ?></td>
                                            <td><?php echo e($student->student_id_no); ?></td>
                                            <td class="td__name">
                                                <?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?>

                                                <input type="hidden" name="student_id[]" value="<?php echo e($student->id); ?>">
                                            </td>
                                            
                                            <?php
                                                $head_wise_marks = $student->examRecords->isNotEmpty()
                                                    ? json_decode($student->examRecords->first()->head_wise_marks, true)
                                                    : [];
                                            ?>
                                            <?php $__currentLoopData = $markHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(isset($head_marks_array[$head->id]) && $head_marks_array[$head->id] !== null): ?>
                                                    <td class="w-15">
                                                        <input
                                                            type="number"
                                                            name="marks[<?php echo e($student->id); ?>][]"
                                                            value="<?php echo e($head_wise_marks[$head->id] ?? 0); ?>"
                                                            class="form-control"
                                                            oninput="this.value = Math.abs(this.value)"
                                                            onchange="MinMaxInput(this, 0, <?php echo e($head_marks_array[$head->id]); ?>, true)"
                                                        >
                                                        <input type="hidden" value="<?php echo e($head->id); ?>"
                                                               name="head_id[<?php echo e($student->id); ?>][]"
                                                               class="form-control">
                                                    </td>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            <?php else: ?>
                                <h5>Mark's head is not assigned for this Exam/Class yet. Please assign Mark's head, and
                                    then try.</h5>
                            <?php endif; ?>
                        </div>
                        <?php if($assignedMarksHead): ?>
                            <div class="form-group flex d-flex w-100 justify-content-end">
                                <button type="submit" class="btn btn-submit m-4">Submit</button>
                            </div>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {

    const $studentClass   = $('.student_class');
    const $department     = $('.department_id');
    const $sectionSelect  = $('select.section_id');
    const $subjectSelect  = $('select.subject_id');

    // On class change
    $studentClass.on('change', function () {
        const student_class_id = $(this).val();
        const department_id = $department.val();

        getSection(student_class_id);
        getSubjects(student_class_id, department_id);
    });

    // On department change
    $department.on('change', function () {
        const student_class_id = $studentClass.val();
        const department_id = $(this).val();

        getSubjects(student_class_id, department_id);
    });

    // Load on page reload (edit/filter)
    let student_class_id = "<?php echo e($student_class_id ?? ''); ?>";
    let department_id    = "<?php echo e($department_id ?? ''); ?>";

    if (student_class_id) {
        getSection(student_class_id);
        getSubjects(student_class_id, department_id);
    }

    function getSection(student_class_id) {
        let section_id = "<?php echo e($section_id ?? ''); ?>";

        if (!student_class_id) return;

        $.get('<?php echo e(route('sections.list_by_class')); ?>', {
            student_class_id: student_class_id
        }).done(function (response) {

            let option = '<option value="">Section</option>';

            response.forEach(function (section) {
                const selected = section_id == section.id ? ' selected' : '';
                option += `<option value="${section.id}"${selected}>${section.section_name}</option>`;
            });

            $sectionSelect.html(option);
        });
    }

    function getSubjects(student_class_id, department_id = '') {

        let subject_id = "<?php echo e($subject_id ?? ''); ?>";

        if (!student_class_id) return;

        $.get('<?php echo e(route('subjects.list_by_class')); ?>', {
            student_class_id: student_class_id,
            department_id: department_id // ✅ send department
        }).done(function (response) {

            let option = '<option value="">Subject</option>';

            response.forEach(function (item) {
                const selected = subject_id == item.subject_id ? ' selected' : '';
                option += `<option value="${item.subject_id}"${selected}>
                                ${item.subject.subject_name}
                           </option>`;
            });

            $subjectSelect.html(option);
        });
    }
});

// Marks validation
function MinMaxInput(element, min, max, zeroAllowed) {
    if (element.value == 0 && zeroAllowed) return;
    if (element.value > max) element.value = max;
    if (element.value < min) element.value = min;
}
</script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts2'); ?>
    <script>
        $(document).ready(function () {
            // Cache selectors
            const $studentClass = $('.student_class');
            const $department = $('.department_id');
            const $sectionSelect = $('select.section_id');
            const $subjectSelect = $('select.subject_id');
            $studentClass.on('change', function () {
                const student_class_id = $(this).val();
                getSection(student_class_id);
                getSubjects(student_class_id);
            });
            let student_class_id = "<?php echo e(isset($student_class_id) ? addslashes($student_class_id) : ''); ?>";
            if (student_class_id !== '') {
                getSection(student_class_id);
                getSubjects(student_class_id);
            }
            function getSection(student_class_id) {
                let section_id = "<?php echo e(isset($section_id) ? addslashes($section_id) : ''); ?>";
                if (student_class_id) {
                    $.get('<?php echo e(route('sections.list_by_class')); ?>', {student_class_id: student_class_id})
                        .done(function (response) {
                            let option = '<option value="">Section</option>';
                            response.forEach(function (section) {
                                const selected = section_id == section.id ? ' selected' : '';
                                option += `<option value="${section.id}"${selected}>${section.section_name}</option>`;
                            });
                            $sectionSelect.empty().append(option);
                        })
                        .fail(function (jqXHR, textStatus) {
                            console.error('Section load failed:', textStatus);
                        });
                }
            }
            function getSubjects(student_class_id) {
                let subject_id = "<?php echo e(isset($subject_id) ? addslashes($subject_id) : ''); ?>";
                if (student_class_id) {
                    $.get('<?php echo e(route('subjects.list_by_class')); ?>', {student_class_id: student_class_id})
                        .done(function (response) {
                            let option = '<option value="">Subject</option>';
                            response.forEach(function (item) {
                                if (item.student_class_id == student_class_id) {
                                    const selected = subject_id == item.subject_id ? ' selected' : '';
                                    option += `<option value="${item.subject_id}"${selected}>${item.subject.subject_name}</option>`;
                                }
                            });
                            $subjectSelect.empty().append(option);
                        })
                        .fail(function (jqXHR, textStatus) {
                            console.error('Subjects load failed:', textStatus);
                        });
                }
            }
        });
        function MinMaxInput(element, min, max, zeroAllowed) {
            if (element.value == 0 && zeroAllowed) return;
            if (element.value > max) element.value = max;
            if (element.value < min) element.value = min;
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/result/mark_entry/create.blade.php ENDPATH**/ ?>