<?php $__env->startSection('content'); ?>
<div class="card mt-4" id="print-layout">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Class Routine List</h6>
        <div class="m-0 float-right">
            <a class="btn btn-sm btn-light-blue" href="<?php echo e(route('class-routine.create')); ?>">Add New</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table table-strip">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Shift</th>
                            <th>Class</th>
                            <th>Section</th>
                            <th class="action__col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $sn = 0;
                        ?>
                        <?php $__currentLoopData = $classRoutines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $routine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(++$sn); ?></td>
                                <td><?php echo e($routine->shift->shift_name ?? 'N/A'); ?></td>
                                <td><?php echo e($routine->studentClass->class_name ?? ''); ?></td>
                                <td><?php echo e($routine->section->section_name ?? 'N/A'); ?></td>
                                <td class="d-flex justify-content-start">
                                    <?php if(!empty($routine->id)): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.class-routine.view')): ?>
                                            <a href="<?php echo e(route('class-routine.show', $routine->id)); ?>"
                                                class="btn btn-soft-success btn-sm"><i class="fas fa-eye"></i></a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.class-routine.edit')): ?>
                                            <a href="<?php echo e(route('class-routine.edit', $routine->id)); ?>"
                                                class="btn btn-soft-info btn-sm mx-1"><i class="fas fa-edit"></i></a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.class-routine.delete')): ?>
                                            <form action="<?php echo e(route('class-routine.destroy', $routine->id)); ?>" method="POST"
                                                class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-soft-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this class time period?')"><i class="fas fa-trash"></i></button>
                                            </form>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <a class="btn btn-sm btn-success"
                                            href="<?php echo e(route('class-routine.edit', $routine->id)); ?>">Create New Routine</a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/academic/class_routine/index.blade.php ENDPATH**/ ?>