<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12 col-md-12 col-lg-10 m-auto">
            <div class="page-header mb-4">
                <div class="page-block mb-0">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="page-header-title mb-0">
                                <h4 class="mb-0">Apply Leave</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                
                <div class="card-body">
                    <form action="<?php echo e(route('student.apply-leave.store')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <select class="form-select" id="floatingSelect"
                                        name="leave_type" aria-label="Floating label select example">
                                        <option selected="selected">Select Leave Type</option>
                                        <?php $__currentLoopData = $leaveTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leaveType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($leaveType->id); ?>"><?php echo e($leaveType->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select> 
                                    <label for="floatingSelect">Leave Type</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="fromDate" name="from_date" placeholder="Date">
                                    <label for="fromDate">From Date</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="toDate" name="to_date" placeholder="Date">
                                    <label for="toDate">To Date</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <input type="number" class="form-control" id="numberOfDays" name="requested_days" placeholder="Number" readonly>
                                    <label for="numberOfDays">Number of Days</label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-floating">
                                    <textarea name="leave_reason" class="form-control" id="floatingTextarea2"
                                        style="height: 100px"></textarea> 
                                        <label for="floatingTextarea2"></label>
                                    <label for="floatingInput">Leave Reason</label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div> 
            
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const fromDate = document.getElementById('fromDate');
        const toDate = document.getElementById('toDate');
        const numberOfDays = document.getElementById('numberOfDays');

        function calculateDays() {
            if (fromDate.value && toDate.value) {
                const start = new Date(fromDate.value);
                const end = new Date(toDate.value);
                const diffTime = Math.abs(end - start);
                const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24)) + 1;
                numberOfDays.value = diffDays;
            }
        }

        fromDate.addEventListener('change', calculateDays);
        toDate.addEventListener('change', calculateDays);
    });

    $(document).ready(function () {
        const today = new Date();
        const nextWeek = new Date(today);
        nextWeek.setDate(today.getDate() + 7);

      $('#fromDate').datepicker({
        format: 'dd-mm-yyyy', // Format of the date
        autoclose: true,      // Close the picker after date selection
        todayHighlight: true, // Highlight the current date
      }).datepicker('setDate', today); // Set the current date as the default

      $('#toDate').datepicker({
        format: 'dd-mm-yyyy', // Format of the date
        autoclose: true,      // Close the picker after date selection
        todayHighlight: true, // Highlight the current date
      }).datepicker('setDate', today); // Set the current date as the default
    });

</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('students-dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/students-dashboard/pages/apply-leave.blade.php ENDPATH**/ ?>