<?php $__env->startSection('content'); ?>
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Teacher List</h6>
        <div class="m-0 float-right">
            <a href="<?php echo e(route('teacher.create')); ?>" class="btn btn-sm btn-light-blue">Add New</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable">
                    <thead class="thead-light">
                        <tr>
                            <th>Emp. Code</th>
                            <th>Profile</th>
                            <th>Name</th>
                            <th>Gender</th>
                            <th>Mobile Number</th>
                            <th>Joining Date</th>
                            <th class="action__col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        $sn=1;
                    ?>
                    <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($teacher->employee_code); ?></td>
                            <td><img width="50" src="<?php echo e($teacher->employee_photo?asset($teacher->employee_photo):asset('/default/profile.png')); ?>"/></td>
                            <td><?php echo e($teacher->name); ?></td>
                            <td><?php echo e($teacher->gender); ?></td>
                            <td><?php echo e($teacher->mobile_number); ?></td>
                            <td><?php echo e($teacher->joining_date); ?></td>
                            <td class="btn__action">
                                <a href="<?php echo e(route('teacher.show', $teacher->id)); ?>" class="btn btn-sm btn-soft-success"><i class="fas fa-eye"></i></a>
                                <a href="<?php echo e(route('teacher.edit', $teacher->id)); ?>" class="btn btn-sm btn-soft-info mx-1"><i class="fas fa-edit"></i></a>
                                <form action="<?php echo e(route('teacher.destroy', $teacher->id)); ?>" method="POST" style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure you want to delete this building floor?')"><i class="fas fa-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/teacher/teacher-info/index.blade.php ENDPATH**/ ?>