<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12 col-md-12 col-lg-10 m-auto">
            <h5 class="mb-4"></h5>
            <div class="page-header mb-4">
                <div class="page-block mb-0">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="page-header-title mb-0">
                                <h4 class="mb-0">Apply For Book</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <!-- <div class="card-header">
                    <h5>Floating labels</h5>
                    <hr>
                </div> -->
                <div class="card-body">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger m-3">
                            <ul class="m-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?php if(session('success')): ?>
                        <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div id="successAlert" class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(route('student.syllabus.store')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row g-4">
                            
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <?php if(!empty($books)): ?>
                                    <select class="form-control select2" name="book" required>
                                        <option value="">--Select Book--</option>
                                        <?php $__currentLoopData = $books; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($book->id); ?>"><?php echo e($book->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label for="book_id">Book <span class="text-danger">*</span></label>
                                    <?php endif; ?>

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="datepicker" name="return_date" required>
                                    <label for="datepicker">Return Date <span class="text-danger">*</span></label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        

            <!-- //bookissue list -->
            <?php if(!empty($bookissues)): ?>
                <div class="card data__table">
                    <div class="card-header"><h5>My Books</h5>
                    </div>
                    <div class="card-body table-border-style">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Title</th>
                                    <th>Request Date</th>
                                    <th>Issue Date</th>
                                    <th title="Estimate Return Date">ERD Date</th>
                                    <th >Return Date</th>
                                    <th>Status</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $bookissues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$bookissue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(++$key); ?></td>
                                    <td><?php echo e($bookissue->booklist->title ?? 'N/A'); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($bookissue->created_at)->format('d-m-Y')); ?></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td class="text-capitalize"><?php echo e($bookissue->status ?? 'N/A'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function () {
        const today = new Date();
        const nextWeek = new Date(today);
        nextWeek.setDate(today.getDate() + 7);

      $('#datepicker').datepicker({
        format: 'dd-mm-yyyy', // Format of the date
        autoclose: true,      // Close the picker after date selection
        todayHighlight: true, // Highlight the current date
      }).datepicker('setDate', nextWeek); // Set the current date as the default
    });

</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('students-dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/students-dashboard/pages/my-library.blade.php ENDPATH**/ ?>