<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12 col-xxl-8 m-auto">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <div class="card mt-4" id="print-layout">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 table__top__txt">Academic Years</h6>
                    <div class="m-0 float-right">
                        <button class="btn btn-sm btn-light-blue" id="add-student-btn" data-toggle="modal"
                                data-target="#dataStoreModal">Add New
                        </button>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table table-strip table-bordered">
                                <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Year</th>
                                    <th>Is Default</th>
                                    <th>Status</th>
                                    <th class="action__col">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                    $sn = 0;
                                ?>
                                <?php $__currentLoopData = $academicYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $academicYear): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$sn); ?></td>
                                        <td><?php echo e($academicYear->year); ?></td>
                                        <td>
                                            <span
                                                class="badge <?php echo e($academicYear->is_default_year == 'yes' ? 'badge-success' : 'badge-warning'); ?>"><?php echo e(ucfirst($academicYear->is_default_year)); ?></span>
                                        </td>
                                        <td>
                                            <span
                                                class="badge <?php echo e($academicYear->status == 1 ? 'badge-success' : 'badge-warning'); ?>"><?php echo e($academicYear->status == 1 ? 'Active' : 'In-Active'); ?></span>
                                        </td>
                                        <td class="d-flex justify-content-start">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.academic-year.edit')): ?>
                                                <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn"
                                                        data-toggle="modal"
                                                        data-target="#dataEditModal"
                                                        data-year="<?php echo e($academicYear->year); ?>"
                                                        data-is_default_year="<?php echo e($academicYear->is_default_year); ?>"
                                                        data-status="<?php echo e($academicYear->status); ?>"
                                                        data-id="<?php echo e($academicYear->id); ?>"><i class="fas fa-edit"></i>
                                                </button>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.academic-year.edit')): ?>
                                                <form action="<?php echo e(route('academic-years.destroy', $academicYear->id)); ?>"
                                                      method="POST" style="display: inline;"
                                                      onsubmit="return confirm('Are you sure you want to delete this')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-soft-danger"><i
                                                            class="fas fa-trash"></i></button>
                                                </form>
                                            <?php endif; ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- create Modal -->
    <div class="modal fade" id="dataStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('academic-years.store')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Academic Year </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="year">Year <span class="text-danger">*</span></label>
                            <input type="text" name="year" class="form-control" placeholder="Enter Year" required>
                        </div>
                        <div class="form-group">
                            <label for="is_default_year" class="col-form-label text-md-right">Is Default Year <span
                                    class="text-danger">*</span></label>
                            <select name="is_default_year" id="is_default_year" required
                                    class="form-control <?php $__errorArgs = ['is_default_year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="yes">Yes</option>
                                <option value="no">No</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="status" class="col-form-label text-md-right">Status <span
                                    class="text-danger">*</span></label>
                            <select name="status" id="status" required
                                    class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="1">Active</option>
                                <option value="0">In-Active</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->

    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('academic-years.update')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Academic Year </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="year">Year <span class="text-danger">*</span></label>
                            <input type="text" name="year" id="year" class="form-control"
                                   placeholder="Enter Year" required>
                        </div>
                        <div class="form-group">
                            <label for="is_default_year" class="col-form-label text-md-right">Is Default Year <span
                                    class="text-danger">*</span></label>
                            <select name="is_default_year" id="is_default_year"
                                    class="form-control <?php $__errorArgs = ['is_default_year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="yes">Yes</option>
                                <option value="no">No</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="status" class="col-form-label text-md-right">Status <span
                                    class="text-danger">*</span></label>
                            <select name="status" id="status"
                                    class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="1">Active</option>
                                <option value="0">In-Active</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $('#dataEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var year = button.data('year')
            var is_default_year = button.data('is_default_year')
            var status = button.data('status')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#year').val(year)
            modal.find("#is_default_year option[value=" + is_default_year + "]").prop("selected", true);
            modal.find("#status option[value=" + status + "]").prop("selected", true);
            modal.find('#id').val(id)
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/academic/academic_year/index.blade.php ENDPATH**/ ?>