<style>
    .subject-box {
        display: inline-block;
        padding: 5px 10px;
        background-color: #f0f0f0;
        border-radius: 5px;
        margin-right: 5px;
    }
</style>

<?php $__env->startSection('content'); ?>
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Assigned Subject List</h6>
        <div class="m-0 float-right">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.subjects-assigns.create')): ?>
                <a class="btn btn-sm btn-light-blue" href="<?php echo e(route('subjects_assigns.create')); ?>">Add New</a>
            <?php endif; ?>
        </div>
    </div>
    <div class="card-body">
        <?php $__currentLoopData = $subjectsAssigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classId => $subjects): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="d-flex align-items-center justify-content-between mt-3">
                        <div class="align-items-start">
                            <h4>Class: <?php echo e($subjects->first()->studentClass->class_name); ?>  <?php echo e(optional($subjects->first()->group)->group_name ? '- ' . $subjects->first()->group->group_name : ''); ?></h4>
                        </div>
                        <div class="d-flex justify-content-start">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.subjects-assigns.edit')): ?>
                                <a href="<?php echo e(route('subjects_assigns.edit', ['student_class_id' => $subjects->first()->student_class_id])); ?>"
                                    class="btn btn-soft-info btn-sm mr-1"><i class="fas fa-edit"></i></a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.subjects-assigns.delete')): ?>
                                <form action="<?php echo e(route('subjects_assigns.destroy', ['student_class_id' => $subjects->first()->student_class_id])); ?>"
                                    method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-soft-danger btn-sm"
                                        onclick="return confirm('Are you sure you want to delete this class?')"><i class="fas fa-trash"></i></button>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>
                                <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="subject-box m-1"><?php echo e($subject->subject->subject_name); ?></div>
                                    <?php if($index !== $subjects->count() - 1): ?>
                                        
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/academic/subjects_assigns/index.blade.php ENDPATH**/ ?>