<?php $__env->startSection('content'); ?>

    <div class="card mt-4">
        <div class="card-header py-3 card__head">
            <div class="row">
                <div class="col-md-2">
                    <div class="form-group">
                        <?php echo e(generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id" disabled', old('shift_id', $classRoutine->shift_id), 'Select Shift')); ?>

                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <?php echo e(generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class" disabled', old('student_class_id', $classRoutine->student_class_id), "Select Class")); ?>

                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <?php echo e(generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id" disabled', old('section_id', $classRoutine->section_id), 'Select Section')); ?>

                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <?php echo e(generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id" disabled', old('group_id', $classRoutine->group_id), 'Select Group')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if(isset($assignedSubjects)): ?>
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
                <h6 class="m-0 table__top__txt">Edit Routine</h6>
                <div class="m-0 float-right">
                    <a href="<?php echo e(route('class-routine.index')); ?>" class="btn btn-sm btn-light-blue">View All</a>
                </div>
            </div>

            <div class="card-body">
                <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form class="routine-form" method="POST" action="<?php echo e(route('class-routine.update', $classRoutine->id)); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <input type="hidden" name="shift_id" value="<?php echo e(old('shift_id', $classRoutine->shift_id)); ?>">
                    <input type="hidden" name="student_class_id" value="<?php echo e(old('student_class_id', $classRoutine->student_class_id)); ?>">
                    <input type="hidden" name="section_id" value="<?php echo e(old('section_id', $classRoutine->section_id)); ?>">

                    <?php $__currentLoopData = ['Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <h3><?php echo e($day); ?></h3>
                        <input type="hidden" name="days[]" value="<?php echo e($day); ?>">
                        <div class="table-responsive py-3">
                            <table class ="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Action</th>
                                        <th>Subject</th>
                                        <th>Teacher</th>
                                        <th>Start Time</th>
                                        <th>End Time</th>
                                        <th>Room No</th>
                                    </tr>
                                </thead>
                                <tbody class="day-schedule">
                                    <?php $__currentLoopData = $classRoutine->routineDetails->where('day', $day); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $routineDetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="subject-entry">
                                            <td>
                                                <button type="button" class="btn btn-danger remove-subject"><i class="fas fa-minus-circle"></i></button>
                                            </td>
                                            <td>
                                                <select name="subjects[<?php echo e(strtolower($day)); ?>][<?php echo e($loop->index); ?>][subject]" class="form-control">
                                                    <?php $__currentLoopData = $assignedSubjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignedSubject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($assignedSubject->subject->id); ?>" <?php echo e($routineDetail->subject_id == $assignedSubject->subject->id ? 'selected' : ''); ?>><?php echo e($assignedSubject->subject->subject_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </td>
                                            <td>
                                                <?php echo e(generateDropdown($teachers, 'class="form-control select2" name="subjects[' . strtolower($day) . '][' . $loop->index . '][teacher]"', old("subjects.$day.$loop->index.teacher", $routineDetail->teacher_id), "Select Teacher")); ?>

                                            </td>
                                            <td>
                                                <input type="time" class="form-control" name="subjects[<?php echo e(strtolower($day)); ?>][<?php echo e($loop->index); ?>][start_time]" value="<?php echo e(old("subjects.$day.$loop->index.start_time", $routineDetail->start_time)); ?>" required>
                                            </td>
                                            <td>
                                                <input type="time" class="form-control" name="subjects[<?php echo e(strtolower($day)); ?>][<?php echo e($loop->index); ?>][end_time]" value="<?php echo e(old("subjects.$day.$loop->index.end_time", $routineDetail->end_time)); ?>" required>
                                            </td>
                                            <td>
                                                <input type="text" class="form-control" name="subjects[<?php echo e(strtolower($day)); ?>][<?php echo e($loop->index); ?>][room_no]" value="<?php echo e(old("subjects.$day.$loop->index.room_no", $routineDetail->class_room_id)); ?>" placeholder="Room No" required>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                            


                            <button type="button" class="btn btn-success add-subject my-3 px-2 py-1" data-day="<?php echo e(strtolower($day)); ?>"><i class="fas fa-plus-circle"></i> Add</button>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <div class="flex d-flex justify-content-end">
                        <a href="<?php echo e(route('class-routine.index')); ?>" type="submit" class="btn btn-default mt-3 mr-3">Discard</a>
                        <button type="submit" class="btn btn-submit mt-3">Update</button>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>


        $(document).ready(function() {
            $('.student_class').on('change', function(){
                let student_class_id =  $(this).val();
                if(student_class_id){
                    getSectionData(student_class_id);
                }

            });

            let student_class_id = "<?php echo e(request()->query('student_class') ?? $classRoutine->student_class_id); ?>";
            if(student_class_id){

                getSectionData(student_class_id)
            }

            function getSectionData(student_class_id){
                if(student_class_id){
                    $.get('<?php echo e(route('sections.list_by_class')); ?>', { student_class_id: student_class_id }, function(response) {
                        let sections = response;
                        let section_id = "<?php echo e(request()->query('section_id') ?? $classRoutine->section_id); ?>";
                        let option = '<option value="">--Select Section--</option>';
                        for(let i=0;i<sections.length;i++){

                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }
                        }
                        $('select.section_id').empty().append(option);
                    });
                }
            }


            // Add new subject entry
            $('.add-subject').click(function() {
                const day = $(this).data('day');
                const tbody = $(this).closest('div.table-responsive.py-3').find('tbody.day-schedule');

                const index = tbody.find('.subject-entry').length;

                if (tbody.length === 0) {
                    console.error("No tbody found! Check the HTML structure.");
                    return; // Exit if tbody is not found
                }
                const newSubjectEntry = `
                    <tr class="subject-entry">
                        <td>
                            <button type="button" class="btn btn-danger remove-subject"><i class="fas fa-minus-circle"></i></button>
                        </td>
                        <td>
                            <select name="subjects[${day}][${index}][subject]" class="form-control">
                                <?php $__currentLoopData = $assignedSubjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignedSubject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($assignedSubject->subject->id); ?>"><?php echo e($assignedSubject->subject->subject_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td>
                            <?php echo e(generateDropdown($teachers, 'class="form-control select2" name="subjects[${day}][${index}][teacher]"', '', "Select Teacher")); ?>

                        </td>
                        <td>
                            <input type="time" class="form-control" name="subjects[${day}][${index}][start_time]" required>
                        </td>
                        <td>
                            <input type="time" class="form-control" name="subjects[${day}][${index}][end_time]" required>
                        </td>
                        <td>
                            <input type="text" class="form-control" name="subjects[${day}][${index}][room_no]" placeholder="Room No" required>
                        </td>
                    </tr>
                `;

                tbody.append(newSubjectEntry);
            });
        });

        // Remove subject entry
        $(document).on('click', '.remove-subject', function() {
            $(this).closest('.subject-entry').remove();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/academic/class_routine/edit.blade.php ENDPATH**/ ?>