<?php $__env->startSection('content'); ?>
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Roles</h6>
        <div class="m-0 float-right">
         <button class="btn btn-sm btn-light-blue" id="add-role-btn" data-toggle="modal" data-target="#dataStoreModal">Add New</button>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Permissions</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $sn = 0;
                        ?>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(++$sn); ?></td>
                                <td><?php echo e(ucfirst(ucwords(str_replace('-', ' ', $role->name)))); ?></td>
                                <td>
                                    <?php
                                        $permissions = $role->getPermissionNames()->take(3);
                                    ?>
                                    <?php if(count($permissions)>0): ?>
                                        <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $permission_parts = explode('.',$permission);
                                            ?>
                                            <?php if(count($permission_parts)>=3): ?>
                                                <span class="badge badge-primary"><?php echo e(ucfirst(ucwords(str_replace('-', ' ', $permission_parts[1]))).' '.ucfirst($permission_parts[2])); ?></span>
                                            <?php elseif(count($permission_parts)==1): ?>
                                                <span class="badge badge-primary"><?php echo e(ucfirst($permission_parts[0])); ?></span>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        .... more
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a class="btn btn-sm btn-success" href="<?php echo e(route('roles.assign-permission', $role->id)); ?>">Give Permission</a>

                                    <button class="btn btn-sm btn-soft-info edit-role-btn" data-toggle="modal" data-target="#dataStoreModal" data-name="<?php echo e(ucfirst(ucwords(str_replace('-', ' ', $role->name)))); ?>" data-id="<?php echo e($role->id); ?>"><i class="fas fa-edit"></i></button>
                                    <a class="btn btn-sm btn-soft-danger" href="<?php echo e(route('roles.destroy', $role->id)); ?>" onclick="return confirm('Are you sure you want to delete this?')"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="dataStoreModal" role="dialog">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id="roleForm" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('POST'); ?>
                <input type="hidden" name="_method" id="formMethod">
                <div class="modal-header">
                    <h4 class="modal-title" id="modalTitle">Add New Role</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                        <span class="sr-only">Close</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="statusMsg"></p>
                    <div class="form-group">
                        <label for="role_name">Role Name *</label>
                        <input type="text" name="name" class="form-control" id="role_name" placeholder="Enter role name">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('scripts'); ?>

<script>
$(document).ready(function () {
    $('#dataStoreModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var name = button.data('name') || '';
        var id = button.data('id') || '';

        var modal = $(this);
        var form = modal.find('form');
        var actionUrl = id ? '/roles/' + id : '/roles';
        var method = id ? 'PUT' : 'POST';

        form.attr('action', actionUrl);
        modal.find('#role_name').val(name);
        modal.find('#formMethod').val(method);
        modal.find('#modalTitle').text(id ? 'Edit Role' : 'Add New Role');
        if (method === 'PUT') {
            modal.find('[name="_method"]').val('PUT');
        } else {
            modal.find('[name="_method"]').val('POST');
        }
    });

    $('#add-role-btn').on('click', function () {
        resetModal();
    });

    function resetModal() {
        var modal = $('#dataStoreModal');
        var form = modal.find('form');
        form.attr('action', '/roles');
        modal.find('#role_name').val('');
        modal.find('#formMethod').val('POST');
        modal.find('[name="_method"]').val('POST');
        modal.find('#modalTitle').text('Add New Role');
    }
});


</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/role-permission/role/index.blade.php ENDPATH**/ ?>