<?php $__env->startSection('content'); ?>

    <div class="card sub__grouping mt-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="mb-4 table__top__txt">Subject Grouping</h6>
            <div class="m-0 float-right">
                
            </div>
        </div>
        <div class="row">
            <div class="col-md-3 pr-md-5">
                <form role="form" method="POST" action="<?php echo e(route('group-subject.store')); ?>">
                    <?php echo csrf_field(); ?>

                    <div class="form-group">
                        <label for="name">Name <span class="text-danger"> *</span></label>
                        <input id="name" type="text" class="form-control" name="name" required
                               value="<?php echo e(old('name')); ?>" placeholder="Enter Name" maxlength="100" autofocus>
                    </div>

                    <div class="form-group">
                        <label for="type">Type <span class="text-danger"> *</span></label>
                        <select id="type" name="type" class="form-control" required>
                            <option value="">Select Type</option>
                            <?php $__currentLoopData = $subjectTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value); ?>"><?php echo e(Str::ucfirst($value)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group" id="group-field" style="display: none !important;">
                        <label for="group_id">Group <span class="text-danger"> *</span></label>
                        <select id="group_id" name="group_id" class="form-control" required>
                            <option value="">Select Group</option>
                            <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group" id="common-field" style="display: none !important;">
                        <label for="is_common " class="text-danger">Is Group Compulsory Subject?</label>
                        <input id="is_common" type="checkbox" class="ml-2" name="is_common" value="1"
                               placeholder="" autofocus>
                    </div>

                    <div class="form-group">
                        <label for="subject_id">Subject<span class="text-danger"> *</span></label>
                        <select id="subject_id" name="subject_id[]" class="form-control select2" multiple required>
                            <option value="">Select Subject</option>
                            <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="flex d-flex justify-content-end">

                        <button type="submit" class="btn btn-submit mt-3">Submit</button>
                    </div>
                </form>
            </div>
            <div class="col-md-9">
                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Subject</th>
                            
                            <th>Group</th>
                            <th>Type</th>
                            <th>G.C.</th>
                            <th class="action__col">Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(++$key); ?></td>
                                <td><?php echo e($grade->subject?->subject_name); ?></td>
                                
                                <td><?php echo e($grade->group?->group_name); ?></td>
                                <td><?php echo e(Str::ucfirst($grade->type)); ?></td>
                                <td><?php echo e($grade->is_common ? 'Yes' : ''); ?></td>
                                <td class="d-flex justify-content-start">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('hsc.group-subject.edit')): ?>
                                        <a href="<?php echo e(route('group-subject.edit',$grade->id )); ?>" class="btn btn-sm btn-soft-info mr-1"><i class="fas fa-edit"></i></a>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('hsc.group-subject.delete')): ?>
                                        <form action="<?php echo e(route('group-subject.destroy', $grade->id)); ?>" method="POST"
                                            style="display: inline;"
                                            onsubmit="return confirm('Are you sure you want to delete this')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        function toggleGroupFields() {
            const type = document.getElementById('type').value;
            const showFields = type !== 'compulsory';

            const groupField = document.getElementById('group-field');
            const commonField = document.getElementById('common-field');
            const groupSelect = document.getElementById('group_id');

            // Show or hide fields
            groupField.style.display = showFields ? 'block' : 'none';
            commonField.style.display = showFields ? 'block' : 'none';

            // Toggle required attribute
            if (showFields) {
                groupSelect.setAttribute('required', 'required');
            } else {
                groupSelect.removeAttribute('required');
            }
        }

        document.addEventListener('DOMContentLoaded', function () {
            toggleGroupFields(); // initial state
            document.getElementById('type').addEventListener('change', toggleGroupFields);
        });

        $('#subjectGroupingStoreModal').on('shown.bs.modal', function () {
            toggleGroupFields(); // re-evaluate visibility and required status
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/hsc/subject-group/index.blade.php ENDPATH**/ ?>