<?php $__env->startSection('content'); ?>
<div class="card marks__entry__head">
    <div class="card-header py-3 card__head">
        <form class="row" method="post" action="<?php echo e(route('teacher.marks.entry.create')); ?>">
            <?php echo csrf_field(); ?>
            <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-12">
                <select name="exam" class="form-control" id="exam" required>
                    <option value="<?php echo e($exam->id ?? ''); ?>">
                        <?php echo e($exam->exam_name ?? ''); ?> <?php echo e($exam->academic_year->year ?? 'N/A'); ?>

                    </option>
                </select>
            </div>

            <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-12">
                <select name="related_id" class="form-control select2" id="related_id" required>
                    <option value="">--Select Subject--</option>
                    <?php if($my_subjects): ?>
                        <?php $__currentLoopData = $my_subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                         <?php
                            $value = $subject->teacher_id.','.$subject->student_class_id.','.$subject->subject_id.','.$subject->section_id.','.$subject->shift_id.','.$subject->branch_id;
                        ?>

                            <option <?php echo e((isset($relatedId) && $relatedId == $value) ? 'selected' : ''); ?>  value="<?php echo e($value); ?>">
                                <?php echo e($subject->subject->subject_name ?? ''); ?>

                                (<?php echo e($subject->studentClass->class_name ?? ''); ?>

                                <?php echo e($subject->section->section_name ?? ''); ?>)
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </div>

            <div class="col-md-1 col-12 col-md-12 col-lg-12 col-xl-1 btn__search">
                <div class="form-group">
                    <button type="submit" class="btn btn-info">Search</button>
                </div>
            </div>
        </form>
    </div>
</div>


<?php if(isset($students)): ?>
<div class="card mt-4 marks__entry__body">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form method="POST" action="<?php echo e(route('teacher.marks.store')); ?>" class="form-inline">
                <?php echo csrf_field(); ?>
                <div class="table-responsive">
                    <?php if($assignedMarksHead): ?>
                        <input type="hidden" name="exam_id" value="<?php echo e($exam_id ?? ''); ?>">
                        <input type="hidden" name="student_class_id" value="<?php echo e($student_class_id ?? ''); ?>">
                        <input type="hidden" name="shift_id" value="<?php echo e($shift_id ?? ''); ?>">
                        <input type="hidden" name="branch_id" value="<?php echo e($branch_id ?? ''); ?>">
                        <input type="hidden" name="section_id" value="<?php echo e($section_id ?? ''); ?>">
                        <input type="hidden" name="subject_id" value="<?php echo e($subject_id ?? ''); ?>">
                        <input type="hidden" name="group_id" value="<?php echo e($group_id ?? ''); ?>">
                        <input type="hidden" name="academic_year" value="<?php echo e($academic_year ?? ''); ?>">
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>Roll</th>
                                    <th class="th__name">Name</th>
                                    <?php
                                        $head_marks_array = json_decode($assignedMarksHead->head_marks, true);
                                    ?>
                                    <?php $__currentLoopData = $markHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(isset($head_marks_array[$head->id]) && $head_marks_array[$head->id] !== null): ?>
                                            <th class="th__marks__entry" style="width: 10%; max-width: 10%; overflow: hidden;">
                                                <?php echo e($head->short_name); ?>(<?php echo e($head_marks_array[$head->id]); ?>)
                                            </th>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($student->class_roll); ?></td>
                                        <td>
                                            <?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?>

                                            <input type="hidden" name="student_id[]" value="<?php echo e($student->id); ?>">
                                        </td>

                                        <?php
                                            $head_wise_marks = $student->examRecords->isNotEmpty()
                                                ? json_decode($student->examRecords->first()->head_wise_marks, true)
                                                : [];
                                        ?>

                                        <?php $__currentLoopData = $markHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(isset($head_marks_array[$head->id]) && $head_marks_array[$head->id] !== null): ?>
                                                <td class="w-15">
                                                    <input
                                                        type="number"
                                                        name="marks[<?php echo e($student->id); ?>][]"
                                                        value="<?php echo e($head_wise_marks[$head->id] ?? ''); ?>"
                                                        class="form-control"
                                                        oninput="this.value = Math.abs(this.value)"
                                                        onchange="MinMaxInput(this, 0, <?php echo e($head_marks_array[$head->id]); ?>, true)"
                                                    >
                                                    <input type="hidden" value="<?php echo e($head->id); ?>" name="head_id[<?php echo e($student->id); ?>][]" class="form-control">
                                                </td>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <h5>Mark's head is not assigned for this Exam/Class yet. Please assign Mark's head, and then try.</h5>
                    <?php endif; ?>
                </div>
                <?php if($assignedMarksHead): ?>
                <div class="form-group flex d-flex w-100 justify-content-end">
                    <button type="submit" class="btn btn-info m-4">Save</button>
                </div>
                <?php endif; ?>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
            getSubjects(student_class_id)
        });

        let student_class_id = "<?php echo e(isset($student_class_id) ? $student_class_id : ''); ?>";

        if(student_class_id!=''){
            getSection(student_class_id);
            getSubjects(student_class_id)
        }

        function getSection(student_class_id){
            let section_id = "<?php echo e(isset($section_id) ? $section_id : ''); ?>";
            if(student_class_id){
                $.get('<?php echo e(route('sections.list_by_class')); ?>', { student_class_id: student_class_id }, function(response) {
                    let sections = response;

                    let option = '<option value="">Section</option>';
                    for(let i=0;i<sections.length;i++){
                        // if(sections[i].student_class_id == student_class_id){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }

                        // }
                    }
                    $('select.section_id').empty().append(option);
                });
            }
        }

        //------------------Get Class Wise Subject List----------------

        function getSubjects(student_class_id){
            let subject_id = "<?php echo e(isset($subject_id) ? $subject_id : ''); ?>";
            if(student_class_id){
                $.get('<?php echo e(route('subjects.list_by_class')); ?>', { student_class_id: student_class_id }, function(response) {
                    let subjects = response;

                    let option = '<option value="">Subject</option>';
                    for(let i=0;i<subjects.length;i++){
                        if(subjects[i].student_class_id == student_class_id){
                            if(subject_id==subjects[i].subject_id){
                                option += '<option value='+subjects[i].subject_id+' selected>'+subjects[i].subject.subject_name+'</option>';
                            }else{
                                option += '<option value='+subjects[i].subject_id+' >'+subjects[i].subject.subject_name+'</option>';
                            }

                        }
                    }
                    $('select.subject_id').empty().append(option);
                });
            }
        }
        function MinMaxInput(element, min, max, zeroAllowed){

            if(element.value == 0 && zeroAllowed)
                return;

            if(element.value > max){
                element.value = max;
                return;
            }

            if(element.value < min){
                element.value = min;
                return;
            }

        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/result/mark_entry/teacher-marks-entry.blade.php ENDPATH**/ ?>