<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('report.accounting.header-menu', ['active_header' => 'payment-details-report'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="card mt-4">
        <div class="card-body card__head">
            <form action="<?php echo e(route('accounting.payment-details.report')); ?>" method="GET">

                <div class="row">
                    <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                        <?php $__env->startComponent('components.search_student', [
                            'student_name' => $student_name ?? '',
                            'student_id_no' => request()->student_id_no ?? '',
                            'required' => '',
                        ]); ?>
                        <?php echo $__env->renderComponent(); ?>
                    </div>
                    <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                        <?php echo e(generateDropdown($studentClasses, 'class="form-control form-control-sm student_class select2" id="student_class" name="student_class"', request()->query('student_class'), 'Select Class')); ?>

                    </div>

                    <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                        <?php echo e(generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), 'Select Section')); ?>

                    </div>
                    

                    <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                        <button class="btn btn-sm btn-info">Search</button>
                    </div>
                </div>

            </form>
        </div>
    </div>
    <div class="card mt-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Payment Details Report</h6>
            <div>
                <?php if (isset($component)) { $__componentOriginal19177f836eb0edeca2d8d763c719daa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal19177f836eb0edeca2d8d763c719daa4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.report-actions','data' => ['print' => true,'exportExcel' => true,'exportPdf' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('report-actions'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['print' => true,'export_excel' => true,'export_pdf' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal19177f836eb0edeca2d8d763c719daa4)): ?>
<?php $attributes = $__attributesOriginal19177f836eb0edeca2d8d763c719daa4; ?>
<?php unset($__attributesOriginal19177f836eb0edeca2d8d763c719daa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal19177f836eb0edeca2d8d763c719daa4)): ?>
<?php $component = $__componentOriginal19177f836eb0edeca2d8d763c719daa4; ?>
<?php unset($__componentOriginal19177f836eb0edeca2d8d763c719daa4); ?>
<?php endif; ?>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table table_content table-bordered" id="dataTable">
                        <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Student ID</th>
                            <th>Name</th>
                            <th>Class</th>
                            <th>Section</th>
                            <th>Fees Category</th>
                            <th>Due Date</th>
                            <th>Paid Date</th>
                            <th>Total Amount</th>
                            <th>Paid Amount</th>
                            <th>Due Amount</th>
                            <th>Status</th>
                        </tr>
                        </thead>

                        <tbody>
                        <?php
                            $sn = 1;
                        ?>
                        <?php $__empty_1 = true; $__currentLoopData = $paymentDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($sn++); ?></td>
                                <td><?php echo e($payment->student_id_no); ?></td>
                                <td><?php echo e($payment->name); ?></td>
                                <td><?php echo e($payment->class_name); ?></td>
                                <td><?php echo e($payment->section_name ?? '--'); ?></td>
                                <td><?php echo e($payment->title); ?></td>
                                <td><?php echo e(lastDateOfMonth($payment->month)); ?></td>
                                <td><?php echo e($payment->payment_date ?? ''); ?></td>
                                <td><?php echo e(round($payment->assigned_fee)); ?></td>
                                <td><?php echo e(round($payment->paid_fee)); ?></td>
                                <td><?php echo e(round($payment->due_fee)); ?></td>
                                <td>
                                    <?php if($payment->paid_fee>0 && $payment->due_fee==0): ?>
                                        <?php echo getStatusBadge(Status::PAID); ?>

                                    <?php endif; ?>
                                    <?php if($payment->paid_fee==0 && $payment->due_fee>0): ?>
                                        <?php echo getStatusBadge(Status::DUE); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/report-actions.js')); ?>"></script>
    <script>
        $('.student_class').on('change', function () {
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "<?php echo e(request()->query('student_class') ?? ''); ?>";

        if (student_class_id != '') {
            getSection(student_class_id);
        }

        function getSection(student_class_id) {

            let section_id = "<?php echo e(request()->query('section') ?? ''); ?>";
            if (student_class_id) {
                $.get('<?php echo e(route('sections.list_by_class')); ?>', {
                    student_class_id: student_class_id
                }, function (response) {
                    let sections = response;
                    console.log(sections);
                    let option = '<option value="">Select Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if (section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name +
                                '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + ' >' + sections[i].section_name +
                                '</option>';
                        }
                    }
                    $('select.section').empty().append(option);
                });
            }
        }

        const exportExcelOptions = {
            url: '<?php echo e(route("accounting.payment-details.export-excel")); ?>',
            filename: 'payment-details',
            extraData: <?php echo json_encode(request()->query(), 15, 512) ?>,
        };

        const exportPdfOptions = {
            url: '<?php echo e(route("accounting.payment-details.export-pdf")); ?>',
            filename: 'payment-details',
            extraData: <?php echo json_encode(request()->query(), 15, 512) ?>,
        };

        const exportPrintOptions = {
            url: '<?php echo e(route("accounting.payment-details.export-print")); ?>',
            extraData: <?php echo json_encode(request()->query(), 15, 512) ?>,
        };
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/report/accounting/payment-details-report.blade.php ENDPATH**/ ?>