<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'classWiseSeries',
    'genderSeries',
    'examGradeSeries',
    'examName'
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'classWiseSeries',
    'genderSeries',
    'examGradeSeries',
    'examName'
]); ?>
<?php foreach (array_filter(([
    'classWiseSeries',
    'genderSeries',
    'examGradeSeries',
    'examName'
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div class="col-md-4 mb-3">
    <div class="chart__dash pi">
        <div id="class-wise-student" style="height: 320px"></div>
    </div>
</div>

<div class="col-md-4 mb-3">
    <div class="chart__dash pi">
        <div id="student-gender-pie" style="height: 320px"></div>
    </div>
</div>

<div class="col-md-4 mb-3">
    <div class="chart__dash pi">
        <div class="row">
            <div class="col-md-12">
                <div class="float-right">
                    <select name="exam_id" id="exam_id" class="form-control">
                        <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($exam->id); ?>"
                                <?php if(
                                    getCurrentActiveExamId() == $exam->id ||
                                    (!getCurrentActiveExamId() && $loop->first)
                                ): echo 'selected'; endif; ?>
                                >
                                <?php echo e($exam->exam_name); ?> <?php echo e($exam->academic_year?->year); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>
        <div id="last-exam-grade-chart" style="height: 320px"></div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {

    let examGradeChart = null;

    function renderPieChart(container, title, seriesData) {
        return Highcharts.chart(container, {
            chart: { type: 'pie' },
            title: { text: title },
            credits: { enabled: false },
            tooltip: {
                pointFormat: '<b>{point.percentage:.1f}%</b> ({point.y} students)'
            },
            plotOptions: {
                pie: {
                    dataLabels: {
                        enabled: true,
                        format: '{point.name}: {point.y}'
                    }
                }
            },
            series: [{
                name: 'Students',
                colorByPoint: true,
                data: seriesData
            }]
        });
    }

    // Static charts
    renderPieChart('class-wise-student', 'Class Wise Report', <?php echo json_encode($classWiseSeries, 15, 512) ?>);
    renderPieChart('student-gender-pie', 'Boys vs Girls', <?php echo json_encode($genderSeries, 15, 512) ?>);

    // Initial exam chart
    examGradeChart = renderPieChart(
        'last-exam-grade-chart',
        <?php echo json_encode($examName, 15, 512) ?>,
        <?php echo json_encode($examGradeSeries, 15, 512) ?>
    );

    // 🔁 Exam change → AJAX update
    $('#exam_id').on('change', function () {
        let examId = $(this).val();

        $.get("<?php echo e(route('dashboard.exam.grade.chart')); ?>", {
            exam_id: examId
        }, function (response) {
            console.log(response);
            
            examGradeChart.setTitle({ text: response.examName });
            examGradeChart.series[0].setData(response.series);

        });
    });

});
</script>


<script>
// document.addEventListener('DOMContentLoaded', function () {
//     function renderPieChart(container, title, seriesData) {
//         Highcharts.chart(container, {
//             chart: {
//                 type: 'pie'
//             },
//             title: {
//                 text: title
//             },
//             credits: {
//                 enabled: false
//             },
//             tooltip: {
//                 pointFormat: '<b>{point.percentage:.1f}%</b> ({point.y} students)'
//             },
//             accessibility: {
//                 point: {
//                     valueSuffix: '%'
//                 }
//             },
//             plotOptions: {
//                 pie: {
//                     allowPointSelect: true,
//                     cursor: 'pointer',
//                     dataLabels: {
//                         enabled: true,
//                         format: '{point.name}: {point.y}'
//                     }
//                 }
//             },
//             series: [{
//                 name: 'Students',
//                 colorByPoint: true,
//                 data: seriesData
//             }]
//         });
//     }

//     // Class-wise students
//     renderPieChart(
//         'class-wise-student',
//         'Class Wise Report',
//         <?php echo json_encode($classWiseSeries, 15, 512) ?>
//     );

//     // Gender wise
//     renderPieChart(
//         'student-gender-pie',
//         'Boys vs Girls',
//         <?php echo json_encode($genderSeries, 15, 512) ?>
//     );

//     // Last exam grade
//     renderPieChart(
//         'last-exam-grade-chart',
//         <?php echo json_encode($examName, 15, 512) ?>,
//         <?php echo json_encode($examGradeSeries, 15, 512) ?>
//     );
// });
</script>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script src="https://code.highcharts.com/highcharts.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">
<?php $__env->stopPush(); ?>


 <div class="heading"><span>Breaking:</span></div><?php /**PATH /var/www/html/EdueasyCollege/resources/views/components/dashboard-pie-chart.blade.php ENDPATH**/ ?>