<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
            <div class="card mt-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 table__top__txt">Designation List</h6>
                    <div class="m-0 float-right">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('hr-payroll.designation.create')): ?>
                            <button class="btn btn-sm btn-light-blue" id="add-student-btn" data-toggle="modal"
                                    data-target="#dataStoremodal">Add New
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table">
                                <thead class="thead-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Name</th>
                                    <th class="action__col">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if($designations->isNotEmpty()): ?>
                                    <?php $__currentLoopData = $designations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $designation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($designation->id); ?></td>
                                            <td><?php echo e($designation->name); ?></td>
                                            <td class="d-flex justify-content-start">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('hr-payroll.designation.edit')): ?>
                                                    <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn"
                                                            data-toggle="modal" data-target="#dataEditModal"
                                                            data-name="<?php echo e($designation->name); ?>"
                                                            data-id="<?php echo e($designation->id); ?>"><i class="fas fa-edit"></i>
                                                    </button>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('hr-payroll.designation.delete')): ?>
                                                    <form action="<?php echo e(route('designation.destroy', $designation->id)); ?>"
                                                          method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-soft-danger"
                                                                onclick="return confirm('Are you sure you want to delete this building floor?')">
                                                            <i class="fas fa-trash"></i></button>
                                                    </form>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="3" class="text-center">No data available in table</td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- create Modal -->
    <div class="modal fade" id="dataStoremodal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('designation.store')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Designation</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="inputName">Name</label>
                            <input type="text" class="form-control" maxlength="250" id="inputName" name="name" required
                                   placeholder="Enter Designation"/>
                            <span class="text-danger"><?php echo e($errors->has('name') ? $errors->first('name'):''); ?></span>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->

    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('designation.update')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Designation</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="hidden" id="id" name="id">
                            <input type="text" class="form-control" maxlength="250" id="name" name="name" required
                                   placeholder="Enter Designation"/>
                            <span class="text-danger"><?php echo e($errors->has('name') ? $errors->first('name'):''); ?></span>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $('#dataEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget) // Button that triggered the modal
            var name = button.data('name')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#name').val(name)
            modal.find('#id').val(id)
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/hr-payroll/designation/index.blade.php ENDPATH**/ ?>