<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Class Routine for <?php echo e($classRoutine->studentClass->class_name); ?> - <?php echo e($classRoutine->shift?->shift_name ?? "NA"); ?></h6>
        <div class="m-0 float-right">
            <a href="<?php echo e(route('class-routine.index')); ?>" class="btn btn-info">Back</a>
            <button class="btn btn-sm btn-secondary" onclick="printCardBody()">Print</button>
        </div>
    </div>
    <div class="card-body" id="printableArea">
        <?php
            $routinesByDay = $classRoutine->routineDetails->groupBy('day');
        ?>
        
        <?php $__currentLoopData = ['Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <h4><?php echo e($day); ?></h4>
            <div class="table-responsive py-3">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Subject</th>
                            <th>Teacher</th>
                            <th>Start Time</th>
                            <th>End Time</th>
                            <th>Room No</th>
                        </tr>
                    </thead>
                    <tbody class="day-schedule">
                        <?php if(!isset($routinesByDay[$day]) || $routinesByDay[$day]->isEmpty()): ?>
                            <tr>
                                <td colspan="5" class="text-center">No classes scheduled for this day.</td>
                            </tr>
                        <?php else: ?>
                            <?php $__currentLoopData = $routinesByDay[$day]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $routineDetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="subject-entry" style="<?php echo e(($routineDetail->teacher_id == auth()->user()->id && auth()->user()->user_type == 'teacher') ? 'background-color: #80dcff;' : ''); ?>">
                                    <td><?php echo e($routineDetail->subject->subject_name ?? 'N/A'); ?></td>
                                    <td><?php echo e($routineDetail->teacher->name ?? 'N/A'); ?> </td>
                                    <td><?php echo e($routineDetail->start_time); ?></td>
                                    <td><?php echo e($routineDetail->end_time); ?></td>
                                    <td><?php echo e($routineDetail->class_room_id ?? 'N/A'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function printCardBody() {
            var printContents = document.getElementById('printableArea').innerHTML;
            var originalContents = document.body.innerHTML;
        
            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
            location.reload();
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/academic/class_routine/show.blade.php ENDPATH**/ ?>