<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body card__head">
            <!-- Nav tabs -->
            <div class="d-flex justify-content-between align-items-start">
                <ul class="nav nav-tabs flex-grow-1">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->query('tab', 'search') === 'search' ? 'active' : ''); ?>" data-toggle="tab" href="#search-tab">
                            Search By ID
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->query('tab') === 'filter' ? 'active' : ''); ?>" data-toggle="tab" href="#filter-tab">
                            Search by Class
                        </a>
                    </li>
                </ul>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student.student-list.create')): ?>
                    <a href="<?php echo e(route('student_info.create')); ?>" class="btn btn-light-blue ml-3">
                        Add New
                    </a>
                <?php endif; ?>
                
                
            </div>

            <!-- Tab panes -->
            <div class="tab-content">
                <div id="search-tab" class="tab-pane <?php echo e(request()->query('tab', 'search') === 'search' ? 'show active' : ''); ?>">
                    <form method="GET" action="<?php echo e(route('student_info.index')); ?>" class="row">
                        <input type="hidden" name="tab" value="search">
                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <?php $__env->startComponent('components.search_student', [
                                'student_name' => $student_name ?? '',
                                'student_id_no' => request()->student_id_no ?? '',
                                'required' => '',
                            ]); ?>
                            <?php echo $__env->renderComponent(); ?>
                        </div>
                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
                <div id="filter-tab" class="tab-pane fade <?php echo e(request()->query('tab') === 'filter' ? 'show active' : ''); ?>">
                    <form method="GET" action="<?php echo e(route('student_info.index')); ?>" class="row">
                        <input type="hidden" name="tab" value="filter">
                        <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                            <?php echo e(generateDropdown($studentClasses, 'class="form-control student_class student_class_id select2" id="student_class" name="student_class" required', request()->query('student_class'), "Class")); ?>

                        </div>
                        
                        <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                            <?php echo e(generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), "Section")); ?>

                        </div>
                        
                        <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                            <?php echo e(generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Shift")); ?>

                        </div>
                        <?php if (isset($component)) { $__componentOriginal24102f1ac62c394be69e2bc4df251128 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal24102f1ac62c394be69e2bc4df251128 = $attributes; } ?>
<?php $component = App\View\Components\GroupSelector::resolve(['name' => 'group','label' => '','labelText' => 'Group','col' => 'form-group col-lg-2 col-md-6 col-sm-6','required' => (int) request()->input('student_class') >= 11,'selected' => old('group') ?? request()->input('group')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('group-selector'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\GroupSelector::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['student_class_id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute((int) request()->input('student_class'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal24102f1ac62c394be69e2bc4df251128)): ?>
<?php $attributes = $__attributesOriginal24102f1ac62c394be69e2bc4df251128; ?>
<?php unset($__attributesOriginal24102f1ac62c394be69e2bc4df251128); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal24102f1ac62c394be69e2bc4df251128)): ?>
<?php $component = $__componentOriginal24102f1ac62c394be69e2bc4df251128; ?>
<?php unset($__componentOriginal24102f1ac62c394be69e2bc4df251128); ?>
<?php endif; ?>

                        <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                            <?php echo e(generateDropdown(Status::STUDENT_STATUS(), 'class="form-control status" id="status" name="status"', request()->query('status'), "")); ?>

                        </div>
                        <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="card mt-4 d-none" id="print-layout">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Student Manage</h6>
            <div class="m-0 float-right">
                <?php if (isset($component)) { $__componentOriginal19177f836eb0edeca2d8d763c719daa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal19177f836eb0edeca2d8d763c719daa4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.report-actions','data' => ['columns' => [
                    'class_roll' => 'Roll',
                    'student_id_no' => 'Student ID',
                    'name' => 'Name',
                    'student_class.class_name' => 'Class',
                    'section.section_name' => 'Section',
                    'mobile_no' => 'Mobile NO',
                ],'print' => true,'exportPdf' => true,'exportExcel' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('report-actions'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['columns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
                    'class_roll' => 'Roll',
                    'student_id_no' => 'Student ID',
                    'name' => 'Name',
                    'student_class.class_name' => 'Class',
                    'section.section_name' => 'Section',
                    'mobile_no' => 'Mobile NO',
                ]),'print' => true,'exportPdf' => true,'exportExcel' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal19177f836eb0edeca2d8d763c719daa4)): ?>
<?php $attributes = $__attributesOriginal19177f836eb0edeca2d8d763c719daa4; ?>
<?php unset($__attributesOriginal19177f836eb0edeca2d8d763c719daa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal19177f836eb0edeca2d8d763c719daa4)): ?>
<?php $component = $__componentOriginal19177f836eb0edeca2d8d763c719daa4; ?>
<?php unset($__componentOriginal19177f836eb0edeca2d8d763c719daa4); ?>
<?php endif; ?>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table table_content cell-border table-bordered" id="studentsTable">
                        <thead class="thead-light">
                            <tr>
                                <th>Roll</th>
                                <th>Std. ID</th>
                                <th>Name</th>
                                <th>Class</th>
                                <th>Section</th>
                                <th>Mobile No</th>
                                <th>Status</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/report-actions.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            let query = <?php echo json_encode(request()->query(), 15, 512) ?>;
            let table;
            const assetUrl = "<?php echo e(asset('')); ?>";
            if (Object.keys(query).length > 0) {
                $("#print-layout").removeClass("d-none");
                table = $('#studentsTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '<?php echo route('student_info.index'); ?>',
                        type: 'GET',
                        data: function(d) {
                            $.extend(d, query);
                        }
                    },
                    columns: [
                        { data: 'class_roll', name: 'class_roll' },
                        { data: 'student_id_no', name: 'student_id_no', orderable: false, searchable: false },
                        { data: 'name', name: 'name' },
                        { data: 'student_class.class_name', name: 'student_class.class_name' },
                        {
                            data: 'section.section_name',
                            name: 'section.section_name',
                            render: function(data, type, row) {
                                return row.section ? row.section.section_name : '--';
                            }
                        },
                        {
                            data: 'mobile_no',
                            name: 'mobile_no',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'status',
                            name: 'status',
                            orderable: false,
                            searchable: false,
                            render: function (data, type, row) {
                                let checked = data == 'active' ? 'checked' : '';
                                return `
                                    <div class="custom-control custom-switch text-center">
                                        <input type="checkbox"
                                            class="custom-control-input status-switch"
                                            id="switch_${row.id}"
                                            data-id="${row.id}"
                                            ${checked}>
                                        <label class="custom-control-label" for="switch_${row.id}"></label>
                                    </div>
                                `;
                            }
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false,
                            render: function(data, type, row) {
                                let viewButton = '<a href="<?php echo e(route("student_info.view", ":student_id_no")); ?>'.replace(":student_id_no", row.student_id_no) + '" class="btn btn-sm btn-soft-info mr-1" data-toggle="tooltip" title="View" target="_blank"><i class="fas fa-eye"></i></a>';
                                let editButton = '<a href="<?php echo e(route("student_info.edit", ":id")); ?>'.replace(":id", row.id) + '" class="btn btn-sm btn-soft-success mr-1" data-toggle="tooltip" title="Edit"><i class="fas fa-edit"></i></a>';
                                let deleteButton = '<a href="<?php echo e(route("student_info.destroy", ":id")); ?>'.replace(":id", row.id) + '" class="btn btn-sm btn-soft-danger mr-1" data-toggle="tooltip" title="Delete"><i class="fas fa-trash"></i></a>';
                                return '<div class="d-flex justify-content-center">' + viewButton + editButton + deleteButton + '</div>';
                            }
                        }
                    ],
                    language: {
                        emptyTable: "No data available in table",
                        zeroRecords: "No matching records found",
                        processing: "<span class='spinner-border spinner-border-sm' role='status' aria-hidden='true'></span> Loading..."
                    }
                });

                // Initialize column toggle after table is created
                initializeColumnToggle(table, {
                    'class_roll': 0,
                    'student_id_no': 1,
                    'name': 2,
                    'student_class.class_name': 3,
                    'section.section_name': 4,
                    'mobile_no': 5,
                });
            }
        });

        $(document).on('change', '.status-switch', function () {
            let studentId = $(this).data('id');
            let status = $(this).is(':checked') ? 'active' : 'inactive';

            $.ajax({
                url: "<?php echo e(route('student.status.update')); ?>",
                type: "POST",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    id: studentId,
                    status: status
                },
                success: function (response) {
                    if (response.success) {
                        toastr.success(response.message);
                    }
                },
                error: function () {
                    toastr.error('Something went wrong');
                }
            });
        });


        const exportExcelOptions = {
            url: '<?php echo e(route("students.information.export-excel")); ?>',
            filename: 'student-information',
            extraData: <?php echo json_encode(request()->query(), 15, 512) ?>,
        };

        const exportPdfOptions = {
            url: '<?php echo e(route("students.information.export-pdf")); ?>',
            filename: 'student-information',
            extraData: <?php echo json_encode(request()->query(), 15, 512) ?>,
        };

        const exportPrintOptions = {
            url: '<?php echo e(route("students.information.export-print")); ?>',
            extraData: <?php echo json_encode(request()->query(), 15, 512) ?>,
        };

        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "<?php echo e(request()->query('student_class') ?? ''); ?>";

        if(student_class_id!=''){
            getSection(student_class_id);
        }

        function getSection(student_class_id){

            let section_id = "<?php echo e(request()->query('section') ?? ''); ?>";
            if(student_class_id){
                $.get('<?php echo e(route('sections.list_by_class')); ?>', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                    let option = '<option value="">Section</option>';
                    for(let i=0;i<sections.length;i++){
                        if(section_id==sections[i].id){
                            option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                        }else{
                            option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                        }
                    }
                    $('select.section').empty().append(option);
                });
            }
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/students/student_infos/index.blade.php ENDPATH**/ ?>