<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        <div class="card">
            <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6>Fee Type</h6>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('accounting.fees-type.create')): ?>
                    <button class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#createModal">Add New</button>
                <?php endif; ?>
            </div>
            <div class="row">

                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table" id="dataTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $sn = 0;
                                ?>
                                <?php $__currentLoopData = $feeTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feeType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$sn); ?></td>
                                        <td><?php echo e($feeType->title); ?></td>
                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('accounting.fees-type.edit')): ?>
                                                <button class="btn btn-sm btn-soft-info mr-1" data-toggle="modal" data-target="#editModal<?php echo e($feeType->id); ?>"><i class="fas fa-edit"></i></button>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('accounting.fees-type.delete')): ?>
                                                <form action="<?php echo e(route('fee_types.destroy', $feeType->id)); ?>"
                                                    method="POST" style="display:inline-block;"
                                                    onsubmit="return confirm('Are you sure you want to delete this')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                                </form>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <!-- Edit Modal -->
                                    <div class="modal fade" id="editModal<?php echo e($feeType->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editModalLabel<?php echo e($feeType->id); ?>" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editModalLabel<?php echo e($feeType->id); ?>">Edit Fee Type</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action="<?php echo e(route('fee_types.update', $feeType->id)); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PUT'); ?>
                                                        <div class="form-group">
                                                            <label for="title">Name <span class="text-danger">*</span></label>
                                                            <input type="text" name="title" class="form-control" value="<?php echo e($feeType->title); ?>" required>
                                                        </div>

                                                        
                                                        <button type="submit" class="btn btn-submit">Update</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Create Modal -->
                <div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="createModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="createModalLabel">Create Fee Type</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <form action="<?php echo e(route('fee_types.store')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label for="title">Name <span class="text-danger">*</span></label>
                                        <input type="text" name="title" class="form-control" required>
                                    </div>

                                    
                                    <button type="submit" class="btn btn-submit">Submit</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/accounting/fee_types/index.blade.php ENDPATH**/ ?>