<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('report.accounting.header-menu', ['active_header' => 'payroll-report'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="card mt-2">
        <div class="card-body">
            <form action="<?php echo e(route('accounting.payroll.report')); ?>" method="GET">
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="form-group col-lg-3 col-md-3 col-sm-6">
                                <input type="text" id="reportrange" name="date_range" value="<?php echo e(request()->query('date_range')); ?>" class="form-control form-control-sm">
                            </div>
                            <div class="col-lg-2">
                                <button class="btn btn-sm btn-info">Search</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-3" id="print-layout">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Expense Report</h6>
            <div class="d-flex justify-content-end">
                <a class="btn btn-secondary btn__export" id="print-btn" href="#" data-toggle="tooltip" title="Print" onclick="printDiv()"><i class="fas fa-print"></i></a>
            </div>
        </div>
        <div class="row table_content">
            <div class="col-md-12">
          
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead class="thead-light">
                            <tr>
                                <th>Emp. Code</th>
                                <th>Name</th>
                                <th>Mobile</th>
                                <th>Grade</th>
                                <th>Processed Date</th>
                                <?php $__currentLoopData = $salary_heads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th><?php echo e($head->title); ?></th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $newSalaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($salary->employee->employee_code); ?></td>
                                    <td><?php echo e($salary->employee->name); ?></td>
                                    <td><?php echo e($salary->employee->mobile_number ?? '-'); ?></td>
                                    <td><?php echo e($salary->employee->salaryGrade->title ?? '-'); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($salary->process_date)->format('d-m-Y')); ?></td>
                                    <?php $__currentLoopData = $salary->salaryGrade->salaryGradeRules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gradeRule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($gradeRule->rule_type == 'Percentage'): ?>
                                            <td><?php echo e(($salary->amount * $gradeRule->amount)/100); ?></td>
                                        <?php else: ?>
                                            <td><?php echo e($salary->amount); ?></td>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <td><?php echo getStatusBadge($salary->status); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="100%" class="text-center">No data found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
        </div>
    </div>
    <?php $__env->startPush('scripts'); ?>
        <script>

        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/report/accounting/payroll-report.blade.php ENDPATH**/ ?>