<?php $__env->startSection('content'); ?>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Lora:ital,wght@0,400..700;1,400..700&family=Montserrat:ital,wght@0,100..900;1,100..900&family=Oswald:wght@200..700&family=Source+Sans+3:ital,wght@0,200..900;1,200..900&display=swap');

        body {
            font-family: "Roboto", sans-serif;
            font-style: normal;
        }
        a {
            text-decoration: none;
        }
        .container {
            max-width: 860px;
            padding: 20px 10px;
            margin: auto;
            width: 100%;
        }
        .first-row {
            padding: 20px 10px;
            background-color: transparent;
            border: 3px double #ccc;
        }
        table, th, td {
            border: 1px solid black;
            border-collapse: collapse;
        }

        .first-table-wrapper {
            display: flex;
            gap: 20px;
            justify-content: center;
            margin-top: 15px;
            flex-wrap: nowrap;
        }

        .left-side {
            width: 30% !important;
            text-align: center;
        }

        .left-side h2 {
            font-size: 22px;
            width: 266px;
        }

        .left-side a {
            background-color: #000;
            padding: 8px 10px;
            color: #fff;
            display: inline-block;
            border-radius: 4px;
            cursor: pointer;
        }

        .result-table {
            border: 2px solid #565656;
            margin-top: 20px;
        }

        .second-and-third-wrapper {
            height: 560px;
        }

        .second-table-wrapper {
            margin-top: 25px;
        }

        .third-table-wrapper {
            display: flex;
            gap: 20px;
            margin-top: 25px;
        }

        .last-table-wrapper {
            margin-top: 25px;
        }

        .sig {
            font-family: "Dancing Script", cursive;
            font-weight: 600;
            text-align: center;
        }

        table tr td {
            padding-left: 5px;
        }

        .col-height {
            height: 34px;
        }

        .bg-gray {
            background-color: #e9e9e9;
        }

        /*//water-mark*/
        .container .first-row {
            position: relative;
        }

        .container .first-row .ms__icon {
            /* background-image: url(<?php echo e(asset('/default/icon-marksheet1.png')); ?>); */
            position: absolute;
            background-repeat: no-repeat;
            background-position: center;
            background-size: contain;
            width: 349px;
            height: 349px;
            opacity: .15;
            left: 37%;
            top: 48%;
        }

        .middle-side {
            width: 30% !important;
        }

        .right-side {
            width: 40% !important;
        }

        .work-information {
            width: 40% !important;
        }

        .conduct-info {
            width: 60% !important;
        }

        /* Mobile styles */
        @media screen and (max-width: 768px) {
            .first-table-wrapper {
                flex-wrap: wrap;
            }

            .first-table-wrapper > div,
            .left-side,
            .middle-side,
            .right-side,
            .work-information,
            .conduct-info {
                width: 100% !important;
                margin-bottom: 20px;
            }

            .second-and-third-wrapper {
                height: auto;
            }

            .third-table-wrapper {
                flex-direction: column;
            }

            .third-table-wrapper > div {
                width: 100% !important;
            }

            .result-table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }

            table {
                font-size: 14px;
            }

            .container .first-row .ms__icon {
                width: 200px;
                height: 200px;
                left: 50%;
                top: 50%;
                transform: translate(-50%, -50%);
            }

            .left-side h2 {
                width: 100%;
                font-size: 18px;
            }
        }

        @media print {
            .btn-primary {
                display: none;
            }

            .card {
                border: none !important;
            }

            .container-fluid {
                padding: 0 !important;
            }

            .result-table {
                page-break-inside: avoid;
            }

            .third-table-wrapper {
                page-break-inside: avoid;
            }
        }
    </style>
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-10 m-auto">
                <div class="card-body card__head">
                    <form method="GET" action="<?php echo e(route('student.my-mark-sheet')); ?>">
                        <div class="page-header">
                            <div class="page-block mb-0 mt-3">
                                <div class="row align-items-center">
                                    <div class="col-md-12">
                                        <div class="page-header-title mb-0">
                                            <h4 class="mb-0">My Mark Sheet</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="mt-4">
                            <div class="row gap-1">
                                <div class="col-md-3 my-2">
                                    <select name="exam_id" class="form-control select2 exam_id" id="exam_id" required>
                                        <option value="">Exam</option>
                                        <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $examItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($examItem->id); ?>" <?php if($exam_id == $examItem->id || (!$exam_id && $loop->first)): echo 'selected'; endif; ?> >
                                                <?php echo e($examItem->exam_name . ' ' . $examItem->academic_year->year); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                                    </select>
                                </div>
                                <div class="col-md-3 my-2">
                                    <button type="submit" class="btn btn-info btn__search">Search</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <?php if(!empty($student)): ?>
                    <div class="my-3">
                        <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                            <h5>Mark Sheet</h5>
                            <div>
                                <button class="btn btn-sm btn-primary" onclick="printMarkDiv()">Print</button>
                            </div>
                        </div>
                        <div class="card-body table_content">
                            <?php
                            $logo_path = get_setting_value(Settings::EXPORT_LOGO)
                                ? get_setting_value(Settings::EXPORT_LOGO)
                                : 'uploads/images/logo.png';
                            $institute_name = get_setting_value(Settings::SCHOOL_NAME)
                                ? get_setting_value(Settings::SCHOOL_NAME)
                                : '';
                            $principal_signature = get_setting_value(Settings::PRINCIPAL_SIGNATURE)
                                ? get_setting_value(Settings::PRINCIPAL_SIGNATURE)
                                : '';

                                $grades_str = '';
                                foreach ($grades as $grade) {
                                    $grades_str .= "<tr>
                                                <td align='center'>$grade->mark_from-$grade->mark_to</td>
                                                <td align='center'>$grade->name</td>
                                                <td align='center'>$grade->remark</td>
                                            </tr>";
                                }

                                $head_marks_array = json_decode($assignedMarksHead->first(), true);

                                $head_id_array = array_keys($head_marks_array);
                                $subject_head_marks = $assignedMarksHead;
                                $highest_grand_total_obtain = 0;
                            ?>

                            <?php
                                $grand_total = 0;
                                $grand_total_obtain = 0;
                                $fail_count = 0;
                                $head_wise_grand_total = [];
                                $section = $sections[$studentPromotion?->from_section_id ?? $student->section_id] ?? '';
                                $class = $studentClasses[$studentPromotion?->from_class_id ?? $student->student_class_id] ?? '';
                                $academicYear = $academicYears[$academic_year] ?? '';
                                $examRecords = $student->examRecords ?? '';
                               
                            ?>

                            <?php if($examRecords): ?>
                                <section class="page-section">
                                    <div class="container">
                                        <div class="table-responsive">
                                            <div class="first-row">
                                                <div class="ms__icon"></div>
                                                <div class="first-table-wrapper" style="display: flex; padding-bottom:20px; width: 100%;">
                                                    <!-- Left Side -->
                                                    <div class="left-side" style="width: 30%; text-align: center;">
                                                        <p><?php echo e($institute_name ?? ''); ?></p>
                                                        <img src="<?php echo e(asset($logo_path ?? '')); ?>" height="135"
                                                            width="200" alt="">
                                                    </div>

                                                    <!-- Middle Side (Student Info) -->
                                                    <div class="middle-side" style="width: 30%;">
                                                        <div class="student-information">
                                                            <table width="100%"
                                                                style="height: 250px; border: 1px solid black; border-collapse: collapse;">
                                                                <tr>
                                                                    <th colspan="2" align="center">Student Information</th>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">ID</th>
                                                                    <td align="center"><?php echo e($student->student_id_no); ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Name</th>
                                                                    <td align="center"><?php echo e($student->first_name); ?>

                                                                        <?php echo e($student->last_name); ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Session</th>
                                                                    <td align="center"><?php echo e($selectedExam->academic_year->year ?? ''); ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Class</th>
                                                                    <td align="center"><?php echo e($class); ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Section</th>
                                                                    <td align="center"><?php echo e($section); ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Roll</th>
                                                                    <td align="center"><?php echo e($student->class_roll); ?></td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>

                                                    <!-- Right Side (Grade Reference) -->
                                                    <div class="right-side" style="width: 40%;">
                                                        <div class="Grade-reference">
                                                            <table width="100%"
                                                                style="height: 250px; border: 1px solid black; border-collapse: collapse;">
                                                                <tr>
                                                                    <th colspan="3" align="center">Grade Reference</th>
                                                                </tr>
                                                                <tr>
                                                                    <th align="center">Marks(%)</th>
                                                                    <th align="center">Grade</th>
                                                                    <th align="center">Comments</th>
                                                                </tr>
                                                                <?php echo $grades_str; ?>

                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>

                                                

                                                <div class="second-and-third-wrapper" >
                                                    <div class="second-table-wrapper" style="padding-bottom:20px;">
                                                        <table class="result-table" width="100%">
                                                            <tr>
                                                                <th rowspan="2">Subject</th>
                                                                <th rowspan="2" class="bg-gray">Full <br> Marks</th>
                                                                <th colspan="<?php echo e(count($head_id_array) + 3); ?>"
                                                                    class="text-center col-height"><?php echo e($selectedExam->exam_name ?? ''); ?> <?php echo e($selectedExam->academic_year->year ?? ''); ?></th>
                                                            </tr>

                                                            <tr align="center">
                                                                <?php if(isset($head_id_array)): ?>
                                                                    <?php $__currentLoopData = $markHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php if(in_array($head->id, $head_id_array)): ?>
                                                                            <th><?php echo e($head->short_name); ?></th>
                                                                        <?php endif; ?>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                                <th>Total Obt.</th>
                                                                <th>Grade</th>
                                                                <th>Heighest marks</th>
                                                            </tr>

                                                            <?php $__currentLoopData = $subjects_assigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subjects_assign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php
                                                                    $subject_id = $subjects_assign->subject_id;
                                                                    $recoards = $examRecords->firstWhere('subject_id', $subject_id);

                                                                    $full_marks = 0;
                                                                    $head_wise_fail_count = 0;
                                                                    $head_wise_total_obtain = [];
                                                                    $total_marks_obtain = 0;
                                                                    $head_records_str = '';

                                                                    $head_wise_marks_record = $recoards
                                                                        ? json_decode($recoards->head_wise_marks)
                                                                        : null;
                                                                    $head_marks_data = $subject_head_marks[$subject_id] ?? '{}';
                                                                    $head_marks_array = json_decode($head_marks_data);

                                                                    $head_marks_array2 = json_decode($head_marks_data, true);       // array
                                                                    $head_wise_marks_record2 = $recoards ? json_decode($recoards->head_wise_marks, true) : []; // array

                                                                    // ==============================
                                                                    // HEAD-WISE PASS FAIL CHECK
                                                                    // ==============================
                                                                    $head_wise_pass_fail = [];

                                                                    foreach ($head_marks_array2 as $head_id => $total_marks) {
                                                                        $pass_marks = $total_marks * 0.33;  // 33%
                                                                        $marks_obtained = $head_wise_marks_record2[$head_id] ?? 0;

                                                                        $head_wise_pass_fail[$head_id] = ($marks_obtained >= $pass_marks)
                                                                            ? 'Pass'
                                                                            : 'Fail';
                                                                    }

                                                                    // subject fail if ANY head failed
                                                                    if (in_array('Fail', $head_wise_pass_fail)) {
                                                                        $head_wise_fail_count++;
                                                                    }
                                                                    

                                                                    // Skip subject if all head-wise marks (e.g., written + viva) are null
                                                                    $all_marks_null = true;
                                                                    if ($head_wise_marks_record) {
                                                                        foreach ($head_id_array as $head_id) {
                                                                            if (isset($head_wise_marks_record->{$head_id}) && $head_wise_marks_record->{$head_id} !== null) {
                                                                                $all_marks_null = false;
                                                                                break;
                                                                            }
                                                                        }
                                                                    }
                                                                    if ($all_marks_null) {
                                                                        continue;
                                                                    }
                                                                ?>

                                                                <tr align="center">
                                                                    <td align="left"><?php echo e($subjects_assign->subject->subject_name); ?></td>

                                                                    <?php if($head_wise_marks_record): ?>
                                                                        <?php $__currentLoopData = $markHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php if(in_array($head->id, $head_id_array)): ?>
                                                                                <?php
                                                                                    $full_marks += $head_marks_array->{$head?->id} ?? 0;
                                                                                    $head_records_str .= '<td>' . ($head_wise_marks_record->{$head?->id} ?? '0') . '</td>';
                                                                                    $total_marks_obtain += $head_wise_marks_record->{$head?->id} ?? 0;
                                                                                    $head_wise_grand_total[$head?->id] =
                                                                                        ($head_wise_grand_total[$head?->id] ?? 0) +
                                                                                        ($head_wise_marks_record->{$head?->id} ?? 0);
                                                                                ?>
                                                                            <?php endif; ?>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                        <td class="bg-gray"><?php echo e($full_marks); ?></td>
                                                                        <?php echo $head_records_str; ?>


                                                                        <?php
                                                                            $grand_total_obtain += $total_marks_obtain;
                                                                            $grand_total += $full_marks;
                                                                        ?>
                                                                    <?php else: ?>
                                                                        <?php
                                                                            $full_marks = 0;
                                                                            // First: calculate full marks
                                                                            foreach ($markHeads as $head) {
                                                                                if (in_array($head->id, $head_id_array)) {
                                                                                    $full_marks += $head_marks_array->{$head->id} ?? 0;
                                                                                }
                                                                            }
                                                                            $grand_total += $full_marks;
                                                                        ?>

                                                                        <td class="bg-gray"><?php echo e($full_marks); ?></td>
                                                                        <?php $__currentLoopData = $markHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php if(in_array($head->id, $head_id_array)): ?>
                                                                                <td>0</td>
                                                                            <?php endif; ?>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php endif; ?>

                                                                    <td><?php echo e($total_marks_obtain); ?></td>

                                                                    <?php
                                                                        $subject_grade_name = 'F';
                                                                            $subject_gp = 0; // store GP for this single subject

                                                                        $total_percentage =
                                                                            $total_marks_obtain > 0 && $full_marks > 0
                                                                                ? round(($total_marks_obtain * 100) / $full_marks)
                                                                                : 0;
                                                                        
                                                                        if ($head_wise_fail_count == 0) {
                                                                            foreach ($grades as $grade) {
                                                                                if ($grade->mark_from <= $total_percentage && $grade->mark_to >= $total_percentage) {
                                                                                    $subject_grade_name = $grade->name;
                                                                                    $subject_gp = (float) $grade->gpa;   // save GP for this subject
                                                                                    // dd($grade->gpa);
                                                                                    if ($subject_grade_name == 'F') {
                                                                                        $fail_count++;
                                                                                    }
                                                                                }
                                                                            }
                                                                        } else {
                                                                            $fail_count++; // fail due to head-wise fail
                                                                            $subject_grade_name == 'F';
                                                                            $subject_gp = 0.00;
                                                                        }

                                                                            // add to final GP list
                                                                        $total_gp_sum = ($total_gp_sum ?? 0) + $subject_gp;
                                                                        $total_subjects_count = ($total_subjects_count ?? 0) + 1;
                                                                        
                                                                    ?>

                                                                    <td><?php echo e($subject_grade_name); ?></td>
                                                                    <td>
                                                                        <?php if(array_key_exists($subject_id, $highest_marks_array)): ?>
                                                                            <?php echo e(round($highest_marks_array[$subject_id])); ?>

                                                                        <?php endif; ?>
                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            <?php
                                                                if ($grand_total_obtain > $highest_grand_total_obtain) {
                                                                    $highest_grand_total_obtain = $grand_total_obtain;
                                                                }
                                                            ?>

                                                            <tr align="center">
                                                                <td align="left"> <b>Grand Total</b></td>
                                                                <td class="bg-gray"><b><?php echo e($grand_total); ?></b></td>
                                                                <?php $__currentLoopData = $markHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php if(in_array($head->id, $head_id_array)): ?>
                                                                        <th><?php echo e($head_wise_grand_total[$head->id]); ?></th>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <td> <b><?php echo e($grand_total_obtain); ?></b></td>
                                                                <td></td>
                                                                <td><?php echo e(array_sum($highest_marks_array)); ?></td>
                                                            </tr>

                                                            <?php
                                                                $grade_name = 'F';
                                                                $grand_total_percentage =
                                                                    $grand_total_obtain > 0 && $grand_total > 0
                                                                        ? round(($grand_total_obtain * 100) / $grand_total)
                                                                        : 0;
                                                            ?>

                                                            <tr align="center">
                                                                <td class="col-height" align="left"> <b>Percentage</b> </td>
                                                                <td colspan="<?php echo e(count($head_id_array) + 4); ?>">
                                                                    <b><?php echo e(round($grand_total_percentage, 2)); ?>%</b>
                                                                </td>
                                                            </tr>
                                                            <tr align="center">
                                                                <td class="col-height" align="left"><b>Grade</b></td>
                                                                <td colspan="<?php echo e(count($head_id_array) + 1); ?>">
                                                                    <?php if($fail_count > 0): ?>
                                                                        <b>F</b>
                                                                    <?php else: ?>
                                                                    <?php
                                                                        $grade_name = gradeCalculation(number_format($total_gp_sum / $total_subjects_count, 2))
                                                                        ?>
                                                                        <b><?php echo e($grade_name); ?></b>
                                                                    <?php endif; ?>
                                                                </td>
                                                                <td class="col-height" align="left"><b>GPA</b></td>
                                                                <td colspan="<?php echo e(count($head_id_array) + 1); ?>">
                                                                    <?php if($fail_count > 0): ?>
                                                                        <b>0.00</b>
                                                                    <?php else: ?>
                                                                        <b><?php echo e(number_format($total_gp_sum / $total_subjects_count, 2)); ?></b>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>

                                                    <div class="third-table-wrapper" style="display: flex; padding-bottom:50px; width: 100%;">
                                                        <div class="work-information" style="width: 50%;">
                                                            <table width="100%">
                                                                <tr>
                                                                    <td style="width: 50%">Working Days</td>
                                                                    <td style="width: 50%"></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Present</td>
                                                                    <td><?php echo e(''); ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Absent</td>
                                                                    <td><?php echo e(''); ?></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Remarks</td>
                                                                    <td></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Result Published</td>
                                                                    <td><?php echo e($publish_date); ?></td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                        <div class="conduct-info" style="width: 50%;">
                                                            <table width="100%">
                                                                <tr>
                                                                    <td style="width: 50%">Conduct</td>
                                                                    <td style="width: 50%"></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Moral Development</td>
                                                                    <td></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Discipline</td>
                                                                    <td></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Hand Writing</td>
                                                                    <td></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>General Remark</td>
                                                                    <td><?php echo e(gradeNameRemarks($grade_name)); ?></td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="last-table-wrapper">
                                                    <table border="1" width="100%">
                                                        <tr>
                                                            <th>Class Teacher's Signature</th>
                                                            <th>Principle's Signature</th>
                                                            <th>Guardian's Signature</th>
                                                        </tr>
                                                        <tr>
                                                            <td class="sig" style="height: 30px"></td>
                                                            <td class="sig"><img width="150px"
                                                                    src="<?php echo e(asset('signature/principal.jpg')); ?>" /></td>
                                                            <td class="sig"></td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    <div class="page-break"></div>
                                </section>
                            <?php endif; ?>

                        </div>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        @media print {
            .btn-primary {
                display: none;
            }

            .card {
                border: none !important;
            }

            .container-fluid {
                padding: 0 !important;
            }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('students-dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/students-dashboard/pages/my-mark-sheet.blade.php ENDPATH**/ ?>